/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.converter.xml.xslt.PluginFactoryImpl;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentSerializerImpl
implements DocumentSerializer,
OfficeConstants,
URIResolver {
    private GenericOfficeDocument sxwDoc = null;
    private PluginFactoryImpl pluginFactory = null;

    public DocumentSerializerImpl(PluginFactoryImpl pluginFactoryImpl, Document document) {
        this.pluginFactory = pluginFactoryImpl;
        this.sxwDoc = (GenericOfficeDocument)document;
    }

    public ConvertData serialize() throws ConvertException, IOException {
        Object object;
        String string = this.sxwDoc.getName();
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        org.w3c.dom.Document document2 = this.sxwDoc.getMetaDOM();
        org.w3c.dom.Document document3 = this.sxwDoc.getStyleDOM();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConvertData convertData = new ConvertData();
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equals("office:document")) {
            try {
                Node node;
                NodeList nodeList;
                object = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
                DocumentType documentType = dOMImplementation.createDocumentType("office:document", "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", null);
                org.w3c.dom.Document document4 = dOMImplementation.createDocument("http://openoffice.org/2000/office", "office:document", documentType);
                Element element2 = document4.getDocumentElement();
                element2.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
                element2.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
                element2.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
                element2.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
                element2.setAttribute("xmlns:draw", "http://openoffice.org/2000/drawing");
                element2.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
                element2.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
                element2.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
                element2.setAttribute("xmlns:meta", "http://openoffice.org/2000/meta");
                element2.setAttribute("xmlns:number", "http://openoffice.org/2000/datastyle");
                element2.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
                element2.setAttribute("xmlns:chart", "http://openoffice.org/2000/chart");
                element2.setAttribute("xmlns:dr3d", "http://openoffice.org/2000/dr3d");
                element2.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
                element2.setAttribute("xmlns:form", "http://openoffice.org/2000/form");
                element2.setAttribute("xmlns:script", "http://openoffice.org/2000/script");
                element2.setAttribute("xmlns:config", "http://openoffice.org/2001/config");
                element2.setAttribute("office:class", "text");
                element2.setAttribute("office:version", "1.0");
                Element element3 = element2;
                if (document2 != null && (nodeList = document2.getElementsByTagName("office:meta")).getLength() > 0) {
                    node = document4.importNode(nodeList.item(0), true);
                    element3.appendChild(node);
                }
                if (document3 != null && (nodeList = document3.getElementsByTagName("office:styles")).getLength() > 0) {
                    node = document4.importNode(nodeList.item(0), true);
                    element3.appendChild(node);
                }
                if ((nodeList = document.getElementsByTagName("office:automatic-styles")).getLength() > 0) {
                    node = document4.importNode(nodeList.item(0), true);
                    element3.appendChild(node);
                }
                if ((nodeList = document.getElementsByTagName("office:body")).getLength() > 0) {
                    node = document4.importNode(nodeList.item(0), true);
                    element3.appendChild(node);
                }
                document = document4;
            }
            catch (Exception exception) {
                System.out.println("\nAn Exception occurred with Xslt Serializer" + exception);
            }
        }
        try {
            byteArrayOutputStream = this.transform(document);
        }
        catch (Exception exception) {
            System.out.println("\n Error with Xslt\n");
        }
        object = (DOMDocument)this.pluginFactory.createDeviceDocument(string, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        convertData.addDocument((Document)object);
        return convertData;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        if (string != null) {
            if (string.equals("javax.xml.transform.dom.DOMSource") || string.equals("")) {
                return null;
            }
            try {
                ConverterInfo converterInfo = this.pluginFactory.getConverterInfo();
                String string3 = "jar:" + converterInfo.getJarName() + "!/" + string;
                StreamSource streamSource = new StreamSource(string3);
                return streamSource;
            }
            catch (Exception exception) {
                System.out.println("\nException in Xslt Resolver " + exception);
                return null;
            }
        }
        return null;
    }

    private ByteArrayOutputStream transform(org.w3c.dom.Document document) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        ConverterInfo converterInfo = this.pluginFactory.getConverterInfo();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string = converterInfo.getXsltSerial();
            string = string.substring(0, 6);
            org.w3c.dom.Document document2 = null;
            if (string.equals("http:/") || string.equals("file:/") || string.equals("jar://")) {
                System.out.println(converterInfo.getXsltSerial());
                document2 = documentBuilder.parse(converterInfo.getXsltSerial());
            } else {
                document2 = documentBuilder.parse("jar:" + converterInfo.getJarName() + "!/" + converterInfo.getXsltSerial());
            }
            DOMSource dOMSource = new DOMSource(document2);
            DOMSource dOMSource2 = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(this);
            Transformer transformer = transformerFactory.newTransformer(dOMSource);
            transformer.transform(dOMSource2, new StreamResult(byteArrayOutputStream));
        }
        catch (Exception exception) {
            System.out.println("An error occurred in the transformation : " + exception);
        }
        return byteArrayOutputStream;
    }
}

