/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.NameLookup;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Special;
import gnu.kawa.functions.MultiplyOp;
import gnu.kawa.reflect.MakeAnnotation;
import gnu.kawa.xml.XmlNamespace;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.NamedUnit;
import gnu.math.Unit;
import gnu.text.SourceMessages;
import java.util.Vector;
import kawa.lang.Lambda;
import kawa.lang.Translator;
import kawa.repl;
import kawa.standard.Scheme;
import kawa.standard.expt;

public class SchemeCompilation
extends Translator {
    public static final Declaration applyFieldDecl = Declaration.getDeclarationFromStatic("kawa.standard.Scheme", "applyToArgs");
    public static final repl repl;
    public static final Lambda lambda;

    public SchemeCompilation(Language language, SourceMessages messages, NameLookup lexical) {
        super(language, messages, lexical);
    }

    @Override
    public ApplyExp makeApply(Expression func, Expression[] args) {
        Expression[] exps = new Expression[args.length + 1];
        exps[0] = func;
        System.arraycopy(args, 0, exps, 1, args.length);
        return new ApplyExp(new ReferenceExp(applyFieldDecl), exps);
    }

    @Override
    public boolean isApplyFunction(Expression exp) {
        return this.isSimpleApplyFunction(exp);
    }

    @Override
    public boolean isSimpleApplyFunction(Expression exp) {
        return exp instanceof ReferenceExp && ((ReferenceExp)exp).getBinding() == applyFieldDecl;
    }

    @Override
    public boolean appendBodyValues() {
        return ((Scheme)this.getLanguage()).appendBodyValues();
    }

    @Override
    public Expression checkDefaultBinding(Symbol symbol, Translator tr) {
        boolean sawAngle;
        char ch0;
        int len;
        String name;
        Namespace namespace;
        block56: {
            int llen;
            NamedUnit val;
            namespace = symbol.getNamespace();
            String local = symbol.getLocalPart();
            if (namespace instanceof XmlNamespace) {
                return this.makeQuoteExp(((XmlNamespace)namespace).get(local));
            }
            if (namespace.getName() == Scheme.unitNamespace.getName() && (val = Unit.lookup(local)) != null) {
                return this.makeQuoteExp(val);
            }
            name = symbol.toString();
            len = name.length();
            if (len == 0) {
                return null;
            }
            if (len > 1 && name.charAt(len - 1) == '?' && (llen = local.length()) > 1) {
                String tlocal = local.substring(0, llen - 1).intern();
                Symbol tsymbol = namespace.getSymbol(tlocal);
                Expression texp = tr.rewrite((Object)tsymbol, false);
                if (texp instanceof ReferenceExp) {
                    Declaration decl = ((ReferenceExp)texp).getBinding();
                    if (decl == null || decl.getFlag(65536L)) {
                        texp = null;
                    }
                } else if (!(texp instanceof QuoteExp)) {
                    texp = null;
                }
                if (texp != null) {
                    LambdaExp lexp = new LambdaExp(1);
                    lexp.setSymbol(symbol);
                    Declaration param = lexp.addDeclaration((Object)null);
                    param.noteValueUnknown();
                    lexp.body = new ApplyExp(Scheme.instanceOf, new ReferenceExp(param), texp);
                    return lexp;
                }
            }
            if ((ch0 = name.charAt(0)) == '@') {
                String rest = name.substring(1);
                Expression classRef = tr.rewrite(Symbol.valueOf(rest));
                return MakeAnnotation.makeAnnotationMaker(classRef);
            }
            if (ch0 == '-' || ch0 == '+' || Character.digit(ch0, 10) >= 0) {
                int i;
                int state = 0;
                for (i = 0; i < len; ++i) {
                    char ch = name.charAt(i);
                    if (Character.digit(ch, 10) >= 0) {
                        state = state < 3 ? 2 : (state < 5 ? 4 : 5);
                        continue;
                    }
                    if ((ch == '+' || ch == '-') && state == 0) {
                        state = 1;
                        continue;
                    }
                    if (ch == '.' && state < 3) {
                        state = 3;
                        continue;
                    }
                    if (ch != 'e' && ch != 'E' || state != 2 && state != 4 || i + 1 >= len) break;
                    int j = i + 1;
                    char next = name.charAt(j);
                    if ((next == '-' || next == '+') && ++j < len) {
                        next = name.charAt(j);
                    }
                    if (Character.digit(next, 10) < 0) break;
                    state = 5;
                    i = j + 1;
                }
                if (i < len && state > 1) {
                    DFloNum num = new DFloNum(name.substring(0, i));
                    boolean div = false;
                    Vector<Object> vec = new Vector<Object>();
                    while (i < len) {
                        int unitEnd;
                        char ch;
                        if ((ch = name.charAt(i++)) == '*') {
                            if (i == len) break block56;
                            ch = name.charAt(i++);
                        } else if (ch == '/') {
                            if (i == len || div) break block56;
                            div = true;
                            ch = name.charAt(i++);
                        }
                        int unitStart = i - 1;
                        while (true) {
                            if (!Character.isLetter(ch)) {
                                unitEnd = i - 1;
                                if (unitEnd != unitStart) break;
                                break block56;
                            }
                            if (i == len) {
                                unitEnd = i;
                                ch = '1';
                                break;
                            }
                            ch = name.charAt(i++);
                        }
                        vec.addElement(name.substring(unitStart, unitEnd));
                        boolean expRequired = false;
                        if (ch == '^') {
                            expRequired = true;
                            if (i == len) break block56;
                            ch = name.charAt(i++);
                        }
                        boolean neg = div;
                        if (ch == '+') {
                            expRequired = true;
                            if (i == len) break block56;
                            ch = name.charAt(i++);
                        } else if (ch == '-') {
                            expRequired = true;
                            if (i == len) break block56;
                            ch = name.charAt(i++);
                            neg = !neg;
                        }
                        int nexp = 0;
                        int exp = 0;
                        while (true) {
                            int dig;
                            if ((dig = Character.digit(ch, 10)) <= 0) {
                                --i;
                                break;
                            }
                            exp = 10 * exp + dig;
                            ++nexp;
                            if (i == len) break;
                            ch = name.charAt(i++);
                        }
                        if (nexp == 0) {
                            exp = 1;
                            if (expRequired) break block56;
                        }
                        if (neg) {
                            exp = -exp;
                        }
                        vec.addElement(IntNum.make(exp));
                    }
                    if (i == len) {
                        int nunits = vec.size() >> 1;
                        Expression[] units = new Expression[nunits];
                        for (i = 0; i < nunits; ++i) {
                            String uname = (String)vec.elementAt(2 * i);
                            Symbol usym = Scheme.unitNamespace.getSymbol(uname.intern());
                            Expression uref = tr.rewrite(usym);
                            IntNum uexp = (IntNum)vec.elementAt(2 * i + 1);
                            if (uexp.longValue() != 1L) {
                                uref = new ApplyExp(expt.expt, uref, this.makeQuoteExp(uexp));
                            }
                            units[i] = uref;
                        }
                        Expression unit = nunits == 1 ? units[0] : new ApplyExp(MultiplyOp.$St, units);
                        return new ApplyExp(MultiplyOp.$St, this.makeQuoteExp(num), unit);
                    }
                }
            }
        }
        if (len > 2 && ch0 == '<' && name.charAt(len - 1) == '>') {
            name = name.substring(1, len - 1);
            len -= 2;
            sawAngle = true;
        } else {
            sawAngle = false;
        }
        int rank = 0;
        while (len > 2 && name.charAt(len - 2) == '[' && name.charAt(len - 1) == ']') {
            len -= 2;
            ++rank;
        }
        String cname = name;
        if (rank != 0) {
            cname = name.substring(0, len);
        }
        try {
            Class clas;
            Type type = this.getLanguage().getNamedType(cname);
            if (!(rank <= 0 || sawAngle && type != null)) {
                Symbol tsymbol = namespace.getSymbol(cname.intern());
                Expression texp = tr.rewrite((Object)tsymbol, false);
                if (!((texp = InlineCalls.inlineCalls(texp, tr)) instanceof ErrorExp)) {
                    type = tr.getLanguage().getTypeFor(texp);
                }
            }
            if (type != null) {
                while (--rank >= 0) {
                    type = ArrayType.make(type);
                }
                return this.makeQuoteExp(type);
            }
            type = Type.lookupType(cname);
            if (type instanceof PrimType) {
                clas = type.getReflectClass();
            } else {
                if (cname.indexOf(46) < 0) {
                    cname = tr.classPrefix + Compilation.mangleNameIfNeeded(cname);
                }
                clas = ClassType.getContextClass(cname);
            }
            if (clas != null) {
                if (rank > 0) {
                    type = Type.make(clas);
                    while (--rank >= 0) {
                        type = ArrayType.make(type);
                    }
                    clas = type.getReflectClass();
                }
                return this.makeQuoteExp(clas);
            }
        }
        catch (ClassNotFoundException ex) {
            Package pack = ArrayClassLoader.getContextPackage(name);
            if (pack != null) {
                return this.makeQuoteExp(pack);
            }
        }
        catch (NoClassDefFoundError ex) {
            tr.error('w', "error loading class " + cname + " - " + ex.getMessage() + " not found");
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return null;
    }

    static {
        lambda = new Lambda();
        repl = new repl(Scheme.instance);
        lambda.setKeywords(Special.optional, Special.rest, Special.key);
    }
}

