/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.helper;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Errors;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyHelper {
    private RubyHelper() {
    }

    public static void createHelper(Ruby runtime, RubyModule krypt) {
        RubyModule mHelper = runtime.defineModuleUnder("Helper", krypt);
        RubyModule mString = runtime.defineModuleUnder("String", mHelper);
        mString.defineAnnotatedMethods(RubyString.class);
    }

    public static class RubyString {
        @JRubyMethod(meta=true)
        public static IRubyObject buffer(ThreadContext ctx, IRubyObject recv, IRubyObject size) {
            return ctx.getRuntime().newString(new ByteList(new byte[RubyNumeric.num2int((IRubyObject)size)], false));
        }

        @JRubyMethod(meta=true)
        public static IRubyObject xor(ThreadContext ctx, IRubyObject recv, IRubyObject s1, IRubyObject s2) {
            int len;
            ByteList tmp1 = s1.asString().getByteList();
            ByteList tmp2 = s2.asString().getByteList();
            byte[] src1 = tmp1.getUnsafeBytes();
            byte[] src2 = tmp2.getUnsafeBytes();
            int begin1 = tmp1.getBegin();
            int end1 = tmp1.getRealSize();
            int begin2 = tmp2.getBegin();
            int end2 = tmp2.getRealSize();
            if (end2 - begin2 != (len = end1 - begin1)) {
                throw Errors.newKryptError(ctx.getRuntime(), "String sizes don't match");
            }
            byte[] target = new byte[len];
            for (int i = 0; i < len; ++i) {
                target[i] = (byte)(src1[begin1 + i] ^ src2[begin2 + i]);
            }
            return ctx.getRuntime().newString(new ByteList(target, false));
        }

        @JRubyMethod(meta=true, name={"xor!"})
        public static IRubyObject xor_bang(ThreadContext ctx, IRubyObject recv, IRubyObject s1, IRubyObject s2) {
            ByteList target = s1.asString().getByteList();
            ByteList tmp = s2.asString().getByteList();
            byte[] src = tmp.getUnsafeBytes();
            int begin = tmp.getBegin();
            int end = tmp.getRealSize();
            int len = end - begin;
            if (target.getRealSize() - target.getBegin() != len) {
                throw Errors.newKryptError(ctx.getRuntime(), "String sizes don't match");
            }
            for (int i = 0; i < end; ++i) {
                target.set(i, target.get(i) ^ src[begin + i]);
            }
            return s1;
        }
    }
}

