/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.maven.polyglot.ruby.SetupClassRealm;

@Component(role=SetupClassRealm.class, hint="ruby")
public class SetupClassRealmRuby
extends SetupClassRealm {
    private static final String JRUBY_HOME = "jruby.home";

    @Override
    public void setupArtifact(String gav, ClassRealm realm) throws MalformedURLException {
        try {
            realm.loadClass("org.jruby.embed.ScriptingContainer");
        }
        catch (ClassNotFoundException e) {
            this.setup(gav, realm);
        }
    }

    private void setup(String gav, ClassRealm realm) throws MalformedURLException {
        String jrubyHome = System.getenv("JRUBY_HOME");
        if (jrubyHome == null) {
            jrubyHome = System.getProperty(JRUBY_HOME);
        }
        if (jrubyHome == null) {
            jrubyHome = this.legacySupport.getSession().getRequest().getUserProperties().getProperty(JRUBY_HOME);
        }
        if (jrubyHome == null) {
            jrubyHome = this.legacySupport.getSession().getRequest().getSystemProperties().getProperty(JRUBY_HOME);
        }
        if (jrubyHome == null && this.legacySupport.getSession().getCurrentProject() != null) {
            jrubyHome = this.legacySupport.getSession().getCurrentProject().getProperties().getProperty(JRUBY_HOME);
        }
        if (jrubyHome != null) {
            this.setupFromJrubyHome(jrubyHome);
        } else {
            super.setupArtifact(gav, realm);
        }
    }

    protected void setupFromJrubyHome(String jrubyHome) throws MalformedURLException {
        ClassRealm realm = (ClassRealm)Thread.currentThread().getContextClassLoader();
        System.setProperty(JRUBY_HOME, jrubyHome);
        File[] jars = new File(jrubyHome, "lib").listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        if (jars == null || jars.length == 0) {
            throw new RuntimeException("found jruby-home variable but no jruby.jar: " + jrubyHome);
        }
        for (File jar : jars) {
            realm.addURL(jar.toURI().toURL());
        }
    }
}

