/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.x509store.CRL;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Lookup;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.PolicyTree;
import org.jruby.ext.openssl.x509store.Purpose;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.Trust;
import org.jruby.ext.openssl.x509store.VerifyParameter;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.ext.openssl.x509store.X509Utils;

public class StoreContext {
    private Store store;
    public int currentMethod;
    public X509AuxCertificate certificate;
    public List<X509AuxCertificate> untrusted;
    public List<X509CRL> crls;
    public VerifyParameter verifyParameter;
    public List<X509AuxCertificate> otherContext;
    Store.VerifyFunction verify;
    Store.VerifyCallbackFunction verifyCallback;
    Store.GetIssuerFunction getIssuer;
    Store.CheckIssuedFunction checkIssued;
    Store.CheckRevocationFunction checkRevocation;
    Store.GetCRLFunction getCRL;
    Store.CheckCRLFunction checkCRL;
    Store.CertificateCRLFunction certificateCRL;
    CheckPolicyFunction checkPolicy;
    Store.CleanupFunction cleanup;
    public boolean isValid;
    public int lastUntrusted;
    public List<X509AuxCertificate> chain;
    public PolicyTree tree;
    public int explicitPolicy;
    public int errorDepth;
    public int error;
    public X509AuxCertificate currentCertificate;
    public X509AuxCertificate currentIssuer;
    public java.security.cert.CRL currentCRL;
    public List<Object> extraData;
    private static final Set<String> CRITICAL_EXTENSIONS = new HashSet<String>();
    static final Store.GetIssuerFunction getFirstIssuer;
    static final Store.GetIssuerFunction getIssuerStack;
    static final Store.CheckIssuedFunction defaultCheckIssued;
    static final Store.VerifyCallbackFunction nullCallback;
    static final Store.VerifyFunction internalVerify;
    static final Store.CheckRevocationFunction defaultCheckRevocation;
    static final Store.GetCRLFunction defaultGetCRL;
    static final Store.CheckCRLFunction defaultCheckCRL;
    static final Store.CertificateCRLFunction defaultCertificateCRL;
    static final CheckPolicyFunction defaultCheckPolicy;

    public Store getStore() {
        return this.store;
    }

    public void setDepth(int depth) {
        this.verifyParameter.setDepth(depth);
    }

    public void setApplicationData(Object data) {
        this.setExtraData(0, data);
    }

    public Object getApplicationData() {
        return this.getExtraData(0);
    }

    int getFirstIssuer(X509AuxCertificate[] issuers, X509AuxCertificate x) throws Exception {
        int ok;
        Name xn = new Name(x.getIssuerX500Principal());
        X509Object[] s_obj = new X509Object[1];
        int n = ok = this.store == null ? 0 : this.getBySubject(1, xn, s_obj);
        if (ok != 1) {
            if (ok == -1) {
                X509Error.addError(106);
                return -1;
            }
            if (ok != 0) {
                return -1;
            }
            return 0;
        }
        X509Object obj = s_obj[0];
        if (this.checkIssued.call(this, x, ((Certificate)obj).x509) != 0) {
            issuers[0] = ((Certificate)obj).x509;
            return 1;
        }
        int idx = X509Object.indexBySubject(this.store.objects, 1, xn);
        if (idx == -1) {
            return 0;
        }
        for (int i = idx; i < this.store.objects.size(); ++i) {
            X509Object pobj = this.store.objects.get(i);
            if (pobj.type() != 1) {
                return 0;
            }
            X509AuxCertificate x509 = ((Certificate)pobj).x509;
            if (!xn.isEqual(x509.getSubjectX500Principal())) {
                return 0;
            }
            if (this.checkIssued.call(this, x, x509) == 0) continue;
            issuers[0] = x509;
            return 1;
        }
        return 0;
    }

    public static List<X509AuxCertificate> ensureAux(Collection<X509Certificate> input) {
        if (input == null) {
            return null;
        }
        ArrayList<X509AuxCertificate> out = new ArrayList<X509AuxCertificate>(input.size());
        for (X509Certificate cert : input) {
            out.add(StoreContext.ensureAux(cert));
        }
        return out;
    }

    public static List<X509AuxCertificate> ensureAux(X509Certificate[] input) {
        if (input == null) {
            return null;
        }
        ArrayList<X509AuxCertificate> out = new ArrayList<X509AuxCertificate>(input.length);
        for (X509Certificate cert : input) {
            out.add(StoreContext.ensureAux(cert));
        }
        return out;
    }

    public static X509AuxCertificate ensureAux(X509Certificate input) {
        if (input == null) {
            return null;
        }
        if (input instanceof X509AuxCertificate) {
            return (X509AuxCertificate)input;
        }
        return new X509AuxCertificate(input);
    }

    public int init(Store store, X509AuxCertificate x509, List<X509AuxCertificate> chain) {
        int ret = 1;
        this.store = store;
        this.currentMethod = 0;
        this.certificate = x509;
        this.untrusted = chain;
        this.crls = null;
        this.lastUntrusted = 0;
        this.otherContext = null;
        this.isValid = false;
        this.chain = null;
        this.error = 0;
        this.explicitPolicy = 0;
        this.errorDepth = 0;
        this.currentCertificate = null;
        this.currentIssuer = null;
        this.tree = null;
        this.verifyParameter = new VerifyParameter();
        if (store != null) {
            ret = this.verifyParameter.inherit(store.verifyParameter);
        } else {
            this.verifyParameter.flags |= 0x11L;
        }
        if (store != null) {
            this.verifyCallback = store.getVerifyCallback();
            this.cleanup = store.cleanup;
        } else {
            this.cleanup = Store.CleanupFunction.EMPTY;
        }
        if (ret != 0) {
            ret = this.verifyParameter.inherit(VerifyParameter.lookup("default"));
        }
        if (ret == 0) {
            X509Error.addError(65);
            return 0;
        }
        this.checkIssued = defaultCheckIssued;
        this.getIssuer = getFirstIssuer;
        this.verifyCallback = nullCallback;
        this.verify = internalVerify;
        this.checkRevocation = defaultCheckRevocation;
        this.getCRL = defaultGetCRL;
        this.checkCRL = defaultCheckCRL;
        this.certificateCRL = defaultCertificateCRL;
        if (store != null) {
            if (store.checkIssued != null && store.checkIssued != Store.CheckIssuedFunction.EMPTY) {
                this.checkIssued = store.checkIssued;
            }
            if (store.getIssuer != null && store.getIssuer != Store.GetIssuerFunction.EMPTY) {
                this.getIssuer = store.getIssuer;
            }
            if (store.verifyCallback != null && store.verifyCallback != Store.VerifyCallbackFunction.EMPTY) {
                this.verifyCallback = store.verifyCallback;
            }
            if (store.verify != null && store.verify != Store.VerifyFunction.EMPTY) {
                this.verify = store.verify;
            }
            if (store.checkRevocation != null && store.checkRevocation != Store.CheckRevocationFunction.EMPTY) {
                this.checkRevocation = store.checkRevocation;
            }
            if (store.getCRL != null && store.getCRL != Store.GetCRLFunction.EMPTY) {
                this.getCRL = store.getCRL;
            }
            if (store.checkCRL != null && store.checkCRL != Store.CheckCRLFunction.EMPTY) {
                this.checkCRL = store.checkCRL;
            }
            if (store.certificateCRL != null && store.certificateCRL != Store.CertificateCRLFunction.EMPTY) {
                this.certificateCRL = store.certificateCRL;
            }
        }
        this.checkPolicy = defaultCheckPolicy;
        this.extraData = new ArrayList<Object>();
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        return 1;
    }

    public void trustedStack(List<X509AuxCertificate> sk) {
        this.otherContext = sk;
        this.getIssuer = getIssuerStack;
    }

    public void cleanup() throws Exception {
        if (this.cleanup != null && this.cleanup != Store.CleanupFunction.EMPTY) {
            this.cleanup.call(this);
        }
        this.verifyParameter = null;
        this.tree = null;
        this.chain = null;
        this.extraData = null;
    }

    public X509AuxCertificate findIssuer(List<X509AuxCertificate> certs, X509AuxCertificate cert) throws Exception {
        for (X509AuxCertificate issuer : certs) {
            if (this.checkIssued.call(this, cert, issuer) == 0) continue;
            return issuer;
        }
        return null;
    }

    public int setExtraData(int idx, Object data) {
        this.extraData.set(idx, data);
        return 1;
    }

    public Object getExtraData(int idx) {
        return this.extraData.get(idx);
    }

    public int getError() {
        return this.error;
    }

    public void setError(int s) {
        this.error = s;
    }

    public int getErrorDepth() {
        return this.errorDepth;
    }

    public X509AuxCertificate getCurrentCertificate() {
        return this.currentCertificate;
    }

    public List<X509AuxCertificate> getChain() {
        return this.chain;
    }

    public List<X509AuxCertificate> getFirstChain() {
        if (null == this.chain) {
            return null;
        }
        return new ArrayList<X509AuxCertificate>(this.chain);
    }

    public void setCertificate(X509AuxCertificate x) {
        this.certificate = x;
    }

    public void setCertificate(X509Certificate x) {
        this.certificate = StoreContext.ensureAux(x);
    }

    public void setChain(List<X509Certificate> sk) {
        this.untrusted = StoreContext.ensureAux(sk);
    }

    public void setChain(X509Certificate[] sk) {
        this.untrusted = StoreContext.ensureAux(sk);
    }

    public void setCRLs(List<X509CRL> sk) {
        this.crls = sk;
    }

    public int setPurpose(int purpose) {
        return this.purposeInherit(0, purpose, 0);
    }

    public int setTrust(int trust) {
        return this.purposeInherit(0, 0, trust);
    }

    private void resetSettingsToWithoutStore() {
        this.store = null;
        this.verifyParameter = new VerifyParameter();
        this.verifyParameter.flags |= 0x11L;
        this.verifyParameter.inherit(VerifyParameter.lookup("default"));
        this.cleanup = Store.CleanupFunction.EMPTY;
        this.checkIssued = defaultCheckIssued;
        this.getIssuer = getFirstIssuer;
        this.verifyCallback = nullCallback;
        this.verify = internalVerify;
        this.checkRevocation = defaultCheckRevocation;
        this.getCRL = defaultGetCRL;
        this.checkCRL = defaultCheckCRL;
        this.certificateCRL = defaultCertificateCRL;
    }

    public int loadVerifyLocations(String CAfile, String CApath) {
        boolean reset = false;
        try {
            int ret;
            if (this.store == null) {
                reset = true;
                this.store = new Store();
                this.verifyParameter.inherit(this.store.verifyParameter);
                this.verifyParameter.inherit(VerifyParameter.lookup("default"));
                this.cleanup = this.store.cleanup;
                if (this.store.checkIssued != null && this.store.checkIssued != Store.CheckIssuedFunction.EMPTY) {
                    this.checkIssued = this.store.checkIssued;
                }
                if (this.store.getIssuer != null && this.store.getIssuer != Store.GetIssuerFunction.EMPTY) {
                    this.getIssuer = this.store.getIssuer;
                }
                if (this.store.verify != null && this.store.verify != Store.VerifyFunction.EMPTY) {
                    this.verify = this.store.verify;
                }
                if (this.store.verifyCallback != null && this.store.verifyCallback != Store.VerifyCallbackFunction.EMPTY) {
                    this.verifyCallback = this.store.verifyCallback;
                }
                if (this.store.checkRevocation != null && this.store.checkRevocation != Store.CheckRevocationFunction.EMPTY) {
                    this.checkRevocation = this.store.checkRevocation;
                }
                if (this.store.getCRL != null && this.store.getCRL != Store.GetCRLFunction.EMPTY) {
                    this.getCRL = this.store.getCRL;
                }
                if (this.store.checkCRL != null && this.store.checkCRL != Store.CheckCRLFunction.EMPTY) {
                    this.checkCRL = this.store.checkCRL;
                }
                if (this.store.certificateCRL != null && this.store.certificateCRL != Store.CertificateCRLFunction.EMPTY) {
                    this.certificateCRL = this.store.certificateCRL;
                }
            }
            if ((ret = this.store.loadLocations(CAfile, CApath)) == 0 && reset) {
                this.resetSettingsToWithoutStore();
            }
            return ret;
        }
        catch (Exception e) {
            if (reset) {
                this.resetSettingsToWithoutStore();
            }
            return 0;
        }
    }

    public int purposeInherit(int defaultPurpose, int purpose, int trust) {
        int idx;
        if (purpose == 0) {
            purpose = defaultPurpose;
        }
        if (purpose != 0) {
            idx = Purpose.getByID(purpose);
            if (idx == -1) {
                X509Error.addError(121);
                return 0;
            }
            Purpose ptmp = Purpose.getFirst(idx);
            if (ptmp.trust == -1) {
                idx = Purpose.getByID(defaultPurpose);
                if (idx == -1) {
                    X509Error.addError(121);
                    return 0;
                }
                ptmp = Purpose.getFirst(idx);
            }
            if (trust == 0) {
                trust = ptmp.trust;
            }
        }
        if (trust != 0 && (idx = Trust.getByID(trust)) == -1) {
            X509Error.addError(120);
            return 0;
        }
        if (purpose != 0 && this.verifyParameter.purpose == 0) {
            this.verifyParameter.purpose = purpose;
        }
        if (trust != 0 && this.verifyParameter.trust == 0) {
            this.verifyParameter.trust = trust;
        }
        return 1;
    }

    public void setFlags(long flags) {
        this.verifyParameter.setFlags(flags);
    }

    public void setTime(long flags, Date t) {
        this.verifyParameter.setTime(t);
    }

    public void setVerifyCallback(Store.VerifyCallbackFunction verifyCallback) {
        this.verifyCallback = verifyCallback;
    }

    PolicyTree getPolicyTree() {
        return this.tree;
    }

    public int getExplicitPolicy() {
        return this.explicitPolicy;
    }

    public VerifyParameter getParam() {
        return this.verifyParameter;
    }

    public void setParam(VerifyParameter param) {
        this.verifyParameter = param;
    }

    public int setDefault(String name) {
        VerifyParameter p = VerifyParameter.lookup(name);
        if (p == null) {
            return 0;
        }
        return this.verifyParameter.inherit(p);
    }

    public int getBySubject(int type, Name name, X509Object[] ret) throws Exception {
        Store c = this.store;
        X509Object tmp = X509Object.retrieveBySubject(c.objects, type, name);
        if (tmp == null) {
            for (int i = this.currentMethod; i < c.certificateMethods.size(); ++i) {
                X509Object[] stmp;
                Lookup lu = c.certificateMethods.get(i);
                int j = lu.bySubject(type, name, stmp = new X509Object[1]);
                if (j < 0) {
                    this.currentMethod = i;
                    return j;
                }
                if (j <= 0) continue;
                tmp = stmp[0];
                break;
            }
            this.currentMethod = 0;
            if (tmp == null) {
                return 0;
            }
        }
        ret[0] = tmp;
        return 1;
    }

    public int verifyCertificate() throws Exception {
        int ok;
        int ok2;
        X509AuxCertificate[] p_xtmp;
        int num;
        X509AuxCertificate xtmp = null;
        X509AuxCertificate chain_ss = null;
        boolean bad_chain = false;
        ArrayList<X509AuxCertificate> sktmp = null;
        if (this.certificate == null) {
            X509Error.addError(105);
            return -1;
        }
        if (this.chain == null) {
            this.chain = new ArrayList<X509AuxCertificate>();
            this.chain.add(this.certificate);
            this.lastUntrusted = 1;
        }
        if (this.untrusted != null) {
            sktmp = new ArrayList<X509AuxCertificate>(this.untrusted);
        }
        X509AuxCertificate x = this.chain.get(num - 1);
        int depth = this.verifyParameter.depth;
        for (num = this.chain.size(); depth >= num && this.checkIssued.call(this, x, x) == 0 && this.untrusted != null && (xtmp = this.findIssuer(sktmp, x)) != null; ++num) {
            this.chain.add(xtmp);
            sktmp.remove(xtmp);
            ++this.lastUntrusted;
            x = xtmp;
        }
        int i = this.chain.size();
        x = this.chain.get(i - 1);
        if (this.checkIssued.call(this, x, x) != 0) {
            if (this.chain.size() == 1) {
                p_xtmp = new X509AuxCertificate[]{xtmp};
                ok2 = this.getIssuer.call(this, p_xtmp, x);
                xtmp = p_xtmp[0];
                if (ok2 <= 0 || !x.equals(xtmp)) {
                    this.error = 18;
                    this.currentCertificate = x;
                    this.errorDepth = i - 1;
                    bad_chain = true;
                    ok2 = this.verifyCallback.call(this, 0);
                    if (ok2 == 0) {
                        return ok2;
                    }
                } else {
                    x = xtmp;
                    this.chain.set(i - 1, x);
                    this.lastUntrusted = 0;
                }
            } else {
                chain_ss = this.chain.remove(this.chain.size() - 1);
                --this.lastUntrusted;
                x = this.chain.get(--num - 1);
            }
        }
        while (depth >= num && this.checkIssued.call(this, x, x) == 0) {
            p_xtmp = new X509AuxCertificate[]{xtmp};
            ok2 = this.getIssuer.call(this, p_xtmp, x);
            xtmp = p_xtmp[0];
            if (ok2 < 0) {
                return ok2;
            }
            if (ok2 == 0) break;
            x = xtmp;
            this.chain.add(x);
            ++num;
        }
        if (this.checkIssued.call(this, x, x) == 0) {
            if (chain_ss == null || this.checkIssued.call(this, x, chain_ss) == 0) {
                this.error = this.lastUntrusted >= num ? 20 : 2;
                this.currentCertificate = x;
            } else {
                this.chain.add(chain_ss);
                this.lastUntrusted = ++num;
                this.currentCertificate = chain_ss;
                this.error = 19;
                chain_ss = null;
            }
            this.errorDepth = num - 1;
            bad_chain = true;
            int ok3 = this.verifyCallback.call(this, 0);
            if (ok3 == 0) {
                return ok3;
            }
        }
        if ((ok = this.checkChainExtensions()) == 0) {
            return ok;
        }
        if (this.verifyParameter.trust > 0) {
            ok = this.checkTrust();
        }
        if (ok == 0) {
            return ok;
        }
        ok = this.checkRevocation.call(this);
        if (ok == 0) {
            return ok;
        }
        ok = this.verify != null && this.verify != Store.VerifyFunction.EMPTY ? this.verify.call(this) : internalVerify.call(this);
        if (ok == 0) {
            return ok;
        }
        if (!bad_chain && (this.verifyParameter.flags & 0x80L) != 0L) {
            ok = this.checkPolicy.call(this);
        }
        return ok;
    }

    private static boolean supportsCriticalExtension(String oid) {
        return CRITICAL_EXTENSIONS.contains(oid);
    }

    private static boolean unhandledCritical(X509Extension xx) {
        if (xx.getCriticalExtensionOIDs() == null || xx.getCriticalExtensionOIDs().size() == 0) {
            return false;
        }
        for (String ss : xx.getCriticalExtensionOIDs()) {
            if (StoreContext.supportsCriticalExtension(ss)) continue;
            return true;
        }
        return false;
    }

    public int checkChainExtensions() throws Exception {
        int proxy_path_length = 0;
        boolean allow_proxy_certs = (this.verifyParameter.flags & 0x40L) != 0L;
        int must_be_ca = -1;
        try {
            String allowProxyCerts = System.getenv("OPENSSL_ALLOW_PROXY_CERTS");
            if (allowProxyCerts != null && !"false".equalsIgnoreCase(allowProxyCerts)) {
                allow_proxy_certs = true;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        for (int i = 0; i < this.lastUntrusted; ++i) {
            int ok;
            X509AuxCertificate x = this.chain.get(i);
            if ((this.verifyParameter.flags & 0x10L) == 0L && StoreContext.unhandledCritical(x)) {
                this.error = 34;
                this.errorDepth = i;
                this.currentCertificate = x;
                ok = this.verifyCallback.call(this, 0);
                if (ok == 0) {
                    return ok;
                }
            }
            if (!allow_proxy_certs && x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                this.error = 40;
                this.errorDepth = i;
                this.currentCertificate = x;
                ok = this.verifyCallback.call(this, 0);
                if (ok == 0) {
                    return ok;
                }
            }
            int ret = Purpose.checkCA(x);
            switch (must_be_ca) {
                case -1: {
                    if ((this.verifyParameter.flags & 0x20L) != 0L && ret != 1 && ret != 0) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                    break;
                }
                case 0: {
                    if (ret != 0) {
                        ret = 0;
                        this.error = 37;
                        break;
                    }
                    ret = 1;
                    break;
                }
                default: {
                    if (ret == 0 || (this.verifyParameter.flags & 0x20L) != 0L && ret != 1) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                }
            }
            if (ret == 0) {
                this.errorDepth = i;
                this.currentCertificate = x;
                ok = this.verifyCallback.call(this, 0);
                if (ok == 0) {
                    return ok;
                }
            }
            if (this.verifyParameter.purpose > 0 && ((ret = Purpose.checkPurpose(x, this.verifyParameter.purpose, must_be_ca > 0 ? 1 : 0)) == 0 || (this.verifyParameter.flags & 0x20L) != 0L && ret != 1)) {
                this.error = 26;
                this.errorDepth = i;
                this.currentCertificate = x;
                ok = this.verifyCallback.call(this, 0);
                if (ok == 0) {
                    return ok;
                }
            }
            if (i > 1 && x.getBasicConstraints() != -1 && x.getBasicConstraints() != Integer.MAX_VALUE && i > x.getBasicConstraints() + proxy_path_length + 1) {
                this.error = 25;
                this.errorDepth = i;
                this.currentCertificate = x;
                ok = this.verifyCallback.call(this, 0);
                if (ok == 0) {
                    return ok;
                }
            }
            if (x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                int pcpathlen;
                ASN1Sequence pci = (ASN1Sequence)new ASN1InputStream(x.getExtensionValue("1.3.6.1.5.5.7.1.14")).readObject();
                if (pci.size() > 0 && pci.getObjectAt(0) instanceof ASN1Integer && i > (pcpathlen = ((ASN1Integer)pci.getObjectAt(0)).getValue().intValue())) {
                    this.error = 38;
                    this.errorDepth = i;
                    this.currentCertificate = x;
                    ok = this.verifyCallback.call(this, 0);
                    if (ok == 0) {
                        return ok;
                    }
                }
                ++proxy_path_length;
                must_be_ca = 0;
                continue;
            }
            must_be_ca = 1;
        }
        return 1;
    }

    public int checkTrust() throws Exception {
        int i = this.chain.size() - 1;
        X509AuxCertificate x = this.chain.get(i);
        int ok = Trust.checkTrust(x, this.verifyParameter.trust, 0);
        if (ok == 1) {
            return 1;
        }
        this.errorDepth = 1;
        this.currentCertificate = x;
        this.error = ok == 2 ? 28 : 27;
        return this.verifyCallback.call(this, 0);
    }

    public int checkCertificateTime(X509AuxCertificate x) throws Exception {
        Date pTime = (this.verifyParameter.flags & 2L) != 0L ? this.verifyParameter.checkTime : Calendar.getInstance().getTime();
        if (!x.getNotBefore().before(pTime)) {
            this.error = 9;
            this.currentCertificate = x;
            if (this.verifyCallback.call(this, 0) == 0) {
                return 0;
            }
        }
        if (!x.getNotAfter().after(pTime)) {
            this.error = 10;
            this.currentCertificate = x;
            if (this.verifyCallback.call(this, 0) == 0) {
                return 0;
            }
        }
        return 1;
    }

    public int checkCertificate() throws Exception {
        X509AuxCertificate x;
        X509CRL[] crl = new X509CRL[1];
        int cnum = this.errorDepth;
        this.currentCertificate = x = this.chain.get(cnum);
        int ok = this.getCRL.call(this, crl, x);
        if (ok == 0) {
            this.error = 3;
            ok = this.verifyCallback.call(this, 0);
            this.currentCRL = null;
            return ok;
        }
        this.currentCRL = crl[0];
        ok = this.checkCRL.call(this, crl[0]);
        if (ok == 0) {
            this.currentCRL = null;
            return ok;
        }
        ok = this.certificateCRL.call(this, crl[0], x);
        this.currentCRL = null;
        return ok;
    }

    public int checkCRLTime(X509CRL crl, int notify) throws Exception {
        this.currentCRL = crl;
        Date pTime = (this.verifyParameter.flags & 2L) != 0L ? this.verifyParameter.checkTime : Calendar.getInstance().getTime();
        if (!crl.getThisUpdate().before(pTime)) {
            this.error = 11;
            if (notify == 0 || this.verifyCallback.call(this, 0) == 0) {
                return 0;
            }
        }
        if (crl.getNextUpdate() != null && !crl.getNextUpdate().after(pTime)) {
            this.error = 12;
            if (notify == 0 || this.verifyCallback.call(this, 0) == 0) {
                return 0;
            }
        }
        this.currentCRL = null;
        return 1;
    }

    public int getCRLStack(X509CRL[] pcrl, Name name, List<X509CRL> crls) throws Exception {
        X509CRL bestCrl = null;
        if (crls != null) {
            for (X509CRL crl : crls) {
                if (!name.isEqual(crl.getIssuerX500Principal())) continue;
                if (this.checkCRLTime(crl, 0) != 0) {
                    pcrl[0] = crl;
                    return 1;
                }
                bestCrl = crl;
            }
        }
        if (bestCrl != null) {
            pcrl[0] = bestCrl;
        }
        return 0;
    }

    static {
        CRITICAL_EXTENSIONS.add("2.16.840.1.113730.1.1");
        CRITICAL_EXTENSIONS.add("2.5.29.15");
        CRITICAL_EXTENSIONS.add("2.5.29.17");
        CRITICAL_EXTENSIONS.add("2.5.29.19");
        CRITICAL_EXTENSIONS.add("2.5.29.37");
        CRITICAL_EXTENSIONS.add("1.3.6.1.5.5.7.1.14");
        getFirstIssuer = new Store.GetIssuerFunction(){

            @Override
            public int call(StoreContext context, X509AuxCertificate[] issuer, X509AuxCertificate cert) throws Exception {
                return context.getFirstIssuer(issuer, cert);
            }
        };
        getIssuerStack = new Store.GetIssuerFunction(){

            @Override
            public int call(StoreContext context, X509AuxCertificate[] issuer, X509AuxCertificate x) throws Exception {
                issuer[0] = context.findIssuer(context.otherContext, x);
                if (issuer[0] != null) {
                    return 1;
                }
                return 0;
            }
        };
        defaultCheckIssued = new Store.CheckIssuedFunction(){

            @Override
            public int call(StoreContext context, X509AuxCertificate cert, X509AuxCertificate issuer) throws Exception {
                int ret = X509Utils.checkIfIssuedBy(issuer, cert);
                if (ret == 0) {
                    return 1;
                }
                if ((context.verifyParameter.flags & 1L) == 0L) {
                    return 0;
                }
                context.error = ret;
                context.currentCertificate = cert;
                context.currentIssuer = issuer;
                return context.verifyCallback.call(context, 0);
            }
        };
        nullCallback = new Store.VerifyCallbackFunction(){

            @Override
            public int call(StoreContext context, Integer outcome) {
                return outcome;
            }
        };
        internalVerify = new Store.VerifyFunction(){

            @Override
            public int call(StoreContext context) throws Exception {
                Store.VerifyCallbackFunction verifyCallback = context.verifyCallback;
                int n = context.chain.size();
                context.errorDepth = n - 1;
                X509AuxCertificate xi = context.chain.get(--n);
                X509AuxCertificate xs = null;
                int ok = 0;
                if (context.checkIssued.call(context, xi, xi) != 0) {
                    xs = xi;
                } else {
                    if (n <= 0) {
                        context.error = 21;
                        context.currentCertificate = xi;
                        ok = verifyCallback.call(context, 0);
                        return ok;
                    }
                    context.errorDepth = --n;
                    xs = context.chain.get(n);
                }
                while (n >= 0) {
                    block9: {
                        context.errorDepth = n;
                        if (!xs.isValid()) {
                            try {
                                xs.verify(xi.getPublicKey());
                            }
                            catch (Exception e) {
                                context.error = 7;
                                context.currentCertificate = xs;
                                ok = verifyCallback.call(context, 0);
                                if (ok != 0) break block9;
                                return ok;
                            }
                        }
                    }
                    xs.setValid(true);
                    ok = context.checkCertificateTime(xs);
                    if (ok == 0) {
                        return ok;
                    }
                    context.currentIssuer = xi;
                    context.currentCertificate = xs;
                    ok = verifyCallback.call(context, 1);
                    if (ok == 0) {
                        return ok;
                    }
                    if (--n < 0) continue;
                    xi = xs;
                    xs = context.chain.get(n);
                }
                ok = 1;
                return ok;
            }
        };
        defaultCheckRevocation = new Store.CheckRevocationFunction(){

            @Override
            public int call(StoreContext context) throws Exception {
                if ((context.verifyParameter.flags & 4L) == 0L) {
                    return 1;
                }
                int last = (context.verifyParameter.flags & 8L) != 0L ? context.chain.size() - 1 : 0;
                int i = 0;
                while (i <= last) {
                    context.errorDepth = i++;
                    int ok = context.checkCertificate();
                    if (ok != 0) continue;
                    return 0;
                }
                return 1;
            }
        };
        defaultGetCRL = new Store.GetCRLFunction(){

            @Override
            public int call(StoreContext context, X509CRL[] crls, X509AuxCertificate x) throws Exception {
                X509CRL[] crl = new X509CRL[1];
                Name name = new Name(x.getIssuerX500Principal());
                int ok = context.getCRLStack(crl, name, context.crls);
                if (ok != 0) {
                    crls[0] = crl[0];
                    return 1;
                }
                X509Object[] xobj = new X509Object[1];
                ok = context.getBySubject(2, name, xobj);
                if (ok == 0) {
                    if (crl[0] != null) {
                        crls[0] = crl[0];
                        return 1;
                    }
                    return 0;
                }
                crls[0] = (X509CRL)((CRL)xobj[0]).crl;
                return 1;
            }
        };
        defaultCheckCRL = new Store.CheckCRLFunction(){

            @Override
            public int call(StoreContext context, X509CRL crl) throws Exception {
                int ok;
                block13: {
                    X509AuxCertificate issuer;
                    int errorDepth = context.errorDepth;
                    int lastInChain = context.chain.size() - 1;
                    if (errorDepth < lastInChain) {
                        issuer = context.chain.get(errorDepth + 1);
                    } else {
                        issuer = context.chain.get(lastInChain);
                        if (context.checkIssued.call(context, issuer, issuer) == 0) {
                            context.error = 33;
                            ok = context.verifyCallback.call(context, 0);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                    }
                    if (issuer != null) {
                        PublicKey ikey;
                        if (issuer.getKeyUsage() != null && !issuer.getKeyUsage()[6]) {
                            context.error = 35;
                            ok = context.verifyCallback.call(context, 0);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                        if ((ikey = issuer.getPublicKey()) == null) {
                            context.error = 6;
                            ok = context.verifyCallback.call(context, 0);
                            if (ok == 0) {
                                return ok;
                            }
                        } else {
                            try {
                                SecurityHelper.verify(crl, ikey);
                            }
                            catch (GeneralSecurityException ex) {
                                context.error = 8;
                                ok = context.verifyCallback.call(context, 0);
                                if (ok != 0) break block13;
                                return ok;
                            }
                        }
                    }
                }
                if ((ok = context.checkCRLTime(crl, 1)) == 0) {
                    return ok;
                }
                return 1;
            }
        };
        defaultCertificateCRL = new Store.CertificateCRLFunction(){

            @Override
            public int call(StoreContext context, X509CRL crl, X509AuxCertificate x) throws Exception {
                int ok;
                if (crl.getRevokedCertificate(x.getSerialNumber()) != null) {
                    context.error = 23;
                    ok = context.verifyCallback.call(context, 0);
                    if (ok == 0) {
                        return 0;
                    }
                }
                if ((context.verifyParameter.flags & 0x10L) != 0L) {
                    return 1;
                }
                if (crl.getCriticalExtensionOIDs() != null && crl.getCriticalExtensionOIDs().size() > 0) {
                    context.error = 36;
                    ok = context.verifyCallback.call(context, 0);
                    if (ok == 0) {
                        return 0;
                    }
                }
                return 1;
            }
        };
        defaultCheckPolicy = new CheckPolicyFunction(){

            @Override
            public int call(StoreContext context) throws Exception {
                return 1;
            }
        };
    }

    public static interface CheckPolicyFunction
    extends Function1<StoreContext> {
        public static final CheckPolicyFunction EMPTY = new CheckPolicyFunction(){

            @Override
            public int call(StoreContext context) {
                return -1;
            }
        };
    }
}

