/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ext.openssl.impl.BIO;
import org.jruby.ext.openssl.impl.MimeHeader;
import org.jruby.ext.openssl.impl.MimeParam;

public interface Mime {
    public static final Mime DEFAULT = new Mime(){
        private static final int MIME_START = 1;
        private static final int MIME_TYPE = 2;
        private static final int MIME_NAME = 3;
        private static final int MIME_VALUE = 4;
        private static final int MIME_QUOTE = 5;
        private static final int MIME_COMMENT = 6;
        private static final int MAX_SMLEN = 1024;

        private int stripStart(byte[] buffer, int start, int end) {
            for (int p = start; p < end; ++p) {
                byte c = buffer[p];
                if (c == 34) {
                    if (p + 1 < end) {
                        return p + 1;
                    }
                    return -1;
                }
                if (Character.isWhitespace((char)c)) continue;
                return p;
            }
            return -1;
        }

        private int stripEnd(byte[] buffer, int start, int end) {
            this.mimeDebug("stripEnd(" + start + "," + end + ")");
            if (start == -1) {
                return -1;
            }
            for (int p = end - 1; p >= start; --p) {
                this.mimeDebug("  p = " + p + ", c = " + (char)buffer[p] + "(" + buffer[p] + ")");
                byte c = buffer[p];
                if (c == 34) {
                    if (p - 1 == start) {
                        return -1;
                    }
                    return p;
                }
                if (Character.isWhitespace((char)c)) continue;
                return p + 1;
            }
            return -1;
        }

        private String stripEnds(byte[] buffer, int start, int end) {
            start = this.stripStart(buffer, start, end);
            end = this.stripEnd(buffer, start, end);
            try {
                return new String(buffer, start, end - start, "ISO8859-1");
            }
            catch (Exception e) {
                return null;
            }
        }

        public void mimeDebug(String str) {
        }

        @Override
        public List<MimeHeader> parseHeaders(BIO bio) throws IOException {
            this.mimeDebug("\n!!!!!!!!!!!!!!!!!\n" + bio + "\n^^^^^^^^^^^^^^^^^^^^^^^^\n");
            int state = 0;
            byte[] linebuf = new byte[1024];
            int len = 0;
            String ntmp = null;
            MimeHeader mhdr = null;
            int saveState = -1;
            ArrayList<MimeHeader> headers = new ArrayList<MimeHeader>();
            while ((len = bio.gets(linebuf, 1024)) > 0) {
                int p;
                state = mhdr != null && Character.isWhitespace((char)linebuf[0]) ? 3 : 1;
                int q = 0;
                block9: for (p = 0; p < len && linebuf[p] != 13 && linebuf[p] != 10; ++p) {
                    byte c = linebuf[p];
                    switch (state) {
                        case 1: {
                            if (c != 58) continue block9;
                            state = 2;
                            this.mimeDebug("creating new: " + q + ":" + p);
                            ntmp = this.stripEnds(linebuf, q, p);
                            q = p + 1;
                            continue block9;
                        }
                        case 2: {
                            if (c == 59) {
                                this.mimeDebug("Found End Value");
                                this.mimeDebug("creating new: " + q + ":" + p);
                                mhdr = new MimeHeader(ntmp, this.stripEnds(linebuf, q, p));
                                headers.add(mhdr);
                                ntmp = null;
                                q = p + 1;
                                state = 3;
                                continue block9;
                            }
                            if (c != 40) continue block9;
                            saveState = state;
                            state = 6;
                            continue block9;
                        }
                        case 6: {
                            if (c != 41) continue block9;
                            state = saveState;
                            continue block9;
                        }
                        case 3: {
                            if (c != 61) continue block9;
                            state = 4;
                            this.mimeDebug("creating new: " + q + ":" + p);
                            ntmp = this.stripEnds(linebuf, q, p);
                            q = p + 1;
                            continue block9;
                        }
                        case 4: {
                            if (c == 59) {
                                state = 3;
                                mhdr.getParams().add(new MimeParam(ntmp, this.stripEnds(linebuf, q, p)));
                                ntmp = null;
                                q = p + 1;
                                continue block9;
                            }
                            if (c == 34) {
                                this.mimeDebug("Found Quote");
                                state = 5;
                                continue block9;
                            }
                            if (c != 40) continue block9;
                            saveState = state;
                            state = 6;
                            continue block9;
                        }
                        case 5: {
                            if (c != 34) continue block9;
                            this.mimeDebug("Found Match Quote");
                            state = 4;
                        }
                    }
                }
                if (state == 2) {
                    this.mimeDebug("creating new: " + q + ":" + p);
                    mhdr = new MimeHeader(ntmp, this.stripEnds(linebuf, q, p));
                    headers.add(mhdr);
                } else if (state == 4) {
                    this.mimeDebug("creating new: " + q + ":" + p);
                    mhdr.getParams().add(new MimeParam(ntmp, this.stripEnds(linebuf, q, p)));
                }
                if (p != 0) continue;
                break;
            }
            return headers;
        }

        @Override
        public MimeHeader findHeader(List<MimeHeader> headers, String key) {
            for (MimeHeader hdr : headers) {
                if (!hdr.getName().equals(key)) continue;
                return hdr;
            }
            return null;
        }

        @Override
        public MimeParam findParam(MimeHeader header, String key) {
            for (MimeParam par : header.getParams()) {
                if (!par.getParamName().equals(key)) continue;
                return par;
            }
            return null;
        }
    };

    public List<MimeHeader> parseHeaders(BIO var1) throws IOException;

    public MimeHeader findHeader(List<MimeHeader> var1, String var2);

    public MimeParam findParam(MimeHeader var1, String var2);
}

