/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Name
extends RubyObject {
    private static final long serialVersionUID = -226196051911335103L;
    private static ObjectAllocator X509NAME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Name(runtime, klass);
        }
    };
    public static final int COMPAT = 0;
    public static final int RFC2253 = 17892119;
    public static final int ONELINE = 8520479;
    public static final int MULTILINE = 44302342;
    private final List<ASN1ObjectIdentifier> oids = new ArrayList<ASN1ObjectIdentifier>();
    private final List<String> values = new ArrayList<String>();
    private final List<RubyInteger> types = new ArrayList<RubyInteger>();

    public static void createX509Name(Ruby runtime, RubyModule _X509) {
        RubyClass _Name = _X509.defineClassUnder("Name", runtime.getObject(), X509NAME_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("NameError", _OpenSSLError, _OpenSSLError.getAllocator());
        _Name.defineAnnotatedMethods(X509Name.class);
        _Name.includeModule((IRubyObject)runtime.getComparable());
        _Name.setConstant("COMPAT", (IRubyObject)runtime.newFixnum(0));
        _Name.setConstant("RFC2253", (IRubyObject)runtime.newFixnum(17892119));
        _Name.setConstant("ONELINE", (IRubyObject)runtime.newFixnum(8520479));
        _Name.setConstant("MULTILINE", (IRubyObject)runtime.newFixnum(44302342));
        _Name.setConstant("DEFAULT_OBJECT_TYPE", (IRubyObject)runtime.newFixnum(12));
        ThreadContext context = runtime.getCurrentContext();
        RubyHash hash = new RubyHash(runtime, (IRubyObject)runtime.newFixnum(12));
        hash.op_aset(context, (IRubyObject)runtime.newString("C"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(context, (IRubyObject)runtime.newString("countryName"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(context, (IRubyObject)runtime.newString("serialNumber"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(context, (IRubyObject)runtime.newString("dnQualifier"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(context, (IRubyObject)runtime.newString("DC"), (IRubyObject)runtime.newFixnum(22));
        hash.op_aset(context, (IRubyObject)runtime.newString("domainComponent"), (IRubyObject)runtime.newFixnum(22));
        hash.op_aset(context, (IRubyObject)runtime.newString("emailAddress"), (IRubyObject)runtime.newFixnum(22));
        _Name.setConstant("OBJECT_TYPE_TEMPLATE", (IRubyObject)hash);
    }

    static RubyClass _Name(Ruby runtime) {
        return X509._X509(runtime).getClass("Name");
    }

    public X509Name(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    void addEntry(ASN1ObjectIdentifier oid, String value, RubyInteger type) {
        this.oids.add(oid);
        this.values.add(value);
        this.types.add(type);
    }

    public static X509Name create(Ruby runtime, X500Name realName) {
        X509Name name = new X509Name(runtime, X509Name._Name(runtime));
        name.fromASN1Sequence((ASN1Sequence)realName.toASN1Primitive());
        return name;
    }

    void fromASN1Sequence(ASN1Sequence seq) {
        this.oids.clear();
        this.values.clear();
        this.types.clear();
        if (seq != null) {
            Enumeration e = seq.getObjects();
            while (e.hasMoreElements()) {
                ASN1Object element = (ASN1Object)e.nextElement();
                if (element instanceof RDN) {
                    this.fromRDNElement((RDN)element);
                    continue;
                }
                if (element instanceof ASN1Sequence) {
                    this.fromASN1Sequence(element);
                    continue;
                }
                this.fromASN1Set(element);
            }
        }
    }

    private void fromRDNElement(RDN rdn) {
        for (AttributeTypeAndValue tv : rdn.getTypesAndValues()) {
            this.oids.add(tv.getType());
            if (tv.getValue() instanceof ASN1String) {
                this.values.add(((ASN1String)tv.getValue()).getString());
            } else {
                this.values.add(null);
            }
            this.types.add((RubyInteger)this.getRuntime().newFixnum(ASN1.idForJava(tv.getValue())));
        }
    }

    private void fromASN1Set(Object element) {
        ASN1Set typeAndValue = ASN1Set.getInstance((Object)element);
        Enumeration enumRdn = typeAndValue.getObjects();
        while (enumRdn.hasMoreElements()) {
            this.fromASN1Sequence(enumRdn.nextElement());
        }
    }

    private void fromASN1Sequence(Object element) {
        ASN1Sequence typeAndValue = ASN1Sequence.getInstance((Object)element);
        this.oids.add((ASN1ObjectIdentifier)typeAndValue.getObjectAt(0));
        if (typeAndValue.getObjectAt(1) instanceof ASN1String) {
            this.values.add(((ASN1String)typeAndValue.getObjectAt(1)).getString());
        } else {
            this.values.add(null);
        }
        this.types.add((RubyInteger)this.getRuntime().newFixnum(ASN1.idForJava(typeAndValue.getObjectAt(1))));
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject str_or_dn) {
        return this.initialize(context, str_or_dn, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject dn, IRubyObject template) {
        Ruby runtime = context.runtime;
        if (dn instanceof RubyArray) {
            RubyArray ary = (RubyArray)dn;
            RubyClass _Name = X509Name._Name(runtime);
            if (template.isNil()) {
                template = _Name.getConstant("OBJECT_TYPE_TEMPLATE");
            }
            for (int i = 0; i < ary.size(); ++i) {
                IRubyObject entry2;
                IRubyObject obj = ary.eltOk((long)i);
                if (!(obj instanceof RubyArray)) {
                    throw runtime.newTypeError(obj, runtime.getArray());
                }
                RubyArray arr = (RubyArray)obj;
                IRubyObject entry0 = arr.size() > 0 ? arr.eltOk(0L) : context.nil;
                IRubyObject entry1 = arr.size() > 1 ? arr.eltOk(1L) : context.nil;
                IRubyObject iRubyObject = entry2 = arr.size() > 2 ? arr.eltOk(2L) : context.nil;
                if (entry2.isNil()) {
                    entry2 = template.callMethod(context, "[]", entry0);
                }
                if (entry2.isNil()) {
                    entry2 = _Name.getConstant("DEFAULT_OBJECT_TYPE");
                }
                this.add_entry(context, entry0, entry1, entry2);
            }
        } else {
            try {
                byte[] bytes = OpenSSLImpl.to_der_if_possible(context, dn).asString().getBytes();
                ASN1InputStream is = new ASN1InputStream(bytes);
                ASN1Sequence seq = (ASN1Sequence)is.readObject();
                this.fromASN1Sequence(seq);
            }
            catch (IOException e) {
                throw X509Name.newNameError(runtime, e.getClass().getName() + ":" + e.getLocalizedMessage());
            }
        }
        return this;
    }

    private static void printASN(ASN1Encodable obj, StringBuilder out) {
        X509Name.printASN(obj, 0, out);
    }

    private static void printASN(ASN1Encodable obj, int indent, StringBuilder out) {
        for (int i = 0; i < indent; ++i) {
            out.append(' ');
        }
        if (obj instanceof ASN1Sequence) {
            out.append("- Sequence:");
            Enumeration e = ((ASN1Sequence)obj).getObjects();
            while (e.hasMoreElements()) {
                X509Name.printASN((ASN1Encodable)e.nextElement(), indent + 1, out);
            }
        } else if (obj instanceof ASN1Set) {
            out.append("- Set:");
            Enumeration e = ((ASN1Set)obj).getObjects();
            while (e.hasMoreElements()) {
                X509Name.printASN((ASN1Encodable)e.nextElement(), indent + 1, out);
            }
        } else if (obj instanceof ASN1String) {
            out.append("- ").append(obj).append('=').append(((ASN1String)obj).getString()).append('[').append(obj.getClass().getName()).append(']');
        } else {
            out.append("- ").append(obj).append('[').append(obj.getClass().getName()).append(']');
        }
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context, IRubyObject oid, IRubyObject value) {
        return this.add_entry(context, oid, value, context.nil);
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context, IRubyObject oid, IRubyObject value, IRubyObject type) {
        ASN1ObjectIdentifier objectId;
        Ruby runtime = context.runtime;
        if (type.isNil()) {
            type = X509Name._Name(runtime).getConstant("OBJECT_TYPE_TEMPLATE").callMethod(context, "[]", oid);
        }
        try {
            String oidStr = oid.asString().toString();
            objectId = ASN1.getObjectIdentifier(runtime, oidStr);
        }
        catch (IllegalArgumentException e) {
            throw X509Name.newNameError(runtime, "invalid field name: " + e.getMessage());
        }
        if (objectId == null) {
            throw X509Name.newNameError(runtime, (String)null);
        }
        String valueStr = value.asString().toString();
        this.oids.add(objectId);
        this.values.add(valueStr);
        this.types.add((RubyInteger)type);
        return this;
    }

    @JRubyMethod(name={"to_s"}, rest=true)
    public IRubyObject to_s(IRubyObject[] args) {
        Iterator<String> valuesIter;
        Iterator<ASN1ObjectIdentifier> oidsIter;
        Ruby runtime = this.getRuntime();
        int flag = -1;
        if (args.length > 0 && !args[0].isNil()) {
            flag = RubyNumeric.fix2int((IRubyObject)args[0]);
        }
        if (flag == 17892119) {
            ArrayList<ASN1ObjectIdentifier> reverseOids = new ArrayList<ASN1ObjectIdentifier>(this.oids);
            ArrayList<String> reverseValues = new ArrayList<String>(this.values);
            Collections.reverse(reverseOids);
            Collections.reverse(reverseValues);
            oidsIter = reverseOids.iterator();
            valuesIter = reverseValues.iterator();
        } else {
            oidsIter = this.oids.iterator();
            valuesIter = this.values.iterator();
        }
        StringBuilder str = new StringBuilder();
        String sep = "";
        while (oidsIter.hasNext()) {
            ASN1ObjectIdentifier oid = oidsIter.next();
            String name = ASN1.oid2Sym(runtime, oid);
            if (name == null) {
                name = oid.toString();
            }
            String value = valuesIter.next();
            if (flag == 17892119) {
                str.append(sep).append(name).append('=').append(value);
                sep = ",";
                continue;
            }
            str.append('/').append(name).append('=').append(value);
        }
        return runtime.newString(str.toString());
    }

    @JRubyMethod
    public RubyArray to_a() {
        Ruby runtime = this.getRuntime();
        RubyArray entries = runtime.newArray(this.oids.size());
        Iterator<ASN1ObjectIdentifier> oidsIter = this.oids.iterator();
        Iterator<String> valuesIter = this.values.iterator();
        Iterator<RubyInteger> typesIter = this.types.iterator();
        while (oidsIter.hasNext()) {
            ASN1ObjectIdentifier oid = oidsIter.next();
            String name = ASN1.oid2Sym(runtime, oid);
            if (name == null) {
                name = "UNDEF";
            }
            String value = valuesIter.next();
            IRubyObject type = (IRubyObject)typesIter.next();
            IRubyObject[] entry = new IRubyObject[]{runtime.newString(name), runtime.newString(value), type};
            entries.append((IRubyObject)runtime.newArrayNoCopy(entry));
        }
        return entries;
    }

    @JRubyMethod(name={"cmp", "<=>"})
    public IRubyObject cmp(IRubyObject other) {
        if (this.eql_p(other).isTrue()) {
            return RubyFixnum.zero((Ruby)this.getRuntime());
        }
        return RubyFixnum.one((Ruby)this.getRuntime());
    }

    org.bouncycastle.asn1.x509.X509Name getRealName() {
        return new org.bouncycastle.asn1.x509.X509Name(new Vector<ASN1ObjectIdentifier>(this.oids), new Vector<String>(this.values));
    }

    X500Name getX500Name() {
        return X500Name.getInstance((Object)this.getRealName().toASN1Primitive());
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(IRubyObject other) {
        if (!(other instanceof X509Name)) {
            return this.getRuntime().getFalse();
        }
        X509Name o = (X509Name)other;
        org.bouncycastle.asn1.x509.X509Name nm = new org.bouncycastle.asn1.x509.X509Name(new Vector<ASN1ObjectIdentifier>(this.oids), new Vector<String>(this.values));
        org.bouncycastle.asn1.x509.X509Name o_nm = new org.bouncycastle.asn1.x509.X509Name(new Vector<ASN1ObjectIdentifier>(o.oids), new Vector<String>(o.values));
        return nm.equals((Object)o_nm) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyFixnum hash() {
        Name name = new Name(this.getX500Name());
        return this.getRuntime().newFixnum(name.hash());
    }

    @JRubyMethod
    public IRubyObject to_der() {
        DLSequence seq;
        if (this.oids.size() > 0) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            ASN1EncodableVector sVec = new ASN1EncodableVector();
            ASN1ObjectIdentifier lastOid = null;
            for (int i = 0; i != this.oids.size(); ++i) {
                ASN1ObjectIdentifier oid = this.oids.get(i);
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add((ASN1Encodable)oid);
                String value = this.values.get(i);
                int type = RubyNumeric.fix2int((IRubyObject)((IRubyObject)this.types.get(i)));
                v.add((ASN1Encodable)this.convert(oid, value, type));
                if (lastOid == null) {
                    sVec.add((ASN1Encodable)new DLSequence(v));
                } else {
                    vec.add((ASN1Encodable)new DLSet(sVec));
                    sVec = new ASN1EncodableVector();
                    sVec.add((ASN1Encodable)new DLSequence(v));
                }
                lastOid = oid;
            }
            vec.add((ASN1Encodable)new DLSet(sVec));
            seq = new DLSequence(vec);
        } else {
            seq = new DLSequence();
        }
        try {
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])seq.getEncoded("DER"));
        }
        catch (IOException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
    }

    private ASN1Primitive convert(ASN1ObjectIdentifier oid, String value, int type) {
        Class<? extends ASN1Encodable> clazz = ASN1.classForId(type);
        try {
            Constructor<? extends ASN1Encodable> ctor;
            if (clazz != null && null != (ctor = clazz.getConstructor(String.class))) {
                return (ASN1Primitive)ctor.newInstance(value);
            }
            return new X509DefaultEntryConverter().getConvertedValue(oid, value);
        }
        catch (NoSuchMethodException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (InstantiationException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (IllegalAccessException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (IllegalArgumentException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (InvocationTargetException e) {
            throw X509Name.newNameError(this.getRuntime(), e.getTargetException());
        }
        catch (RuntimeException e) {
            if (OpenSSLReal.isDebug(this.getRuntime())) {
                e.printStackTrace(this.getRuntime().getOut());
            }
            throw X509Name.newNameError(this.getRuntime(), e);
        }
    }

    private static RaiseException newNameError(Ruby runtime, Throwable e) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("NameError"), e.getMessage());
    }

    private static RaiseException newNameError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("NameError"), message);
    }
}

