/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.PKeyDSA;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.Base64;
import org.jruby.ext.openssl.impl.NetscapeCertRequest;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class NetscapeSPKI
extends RubyObject {
    private static final long serialVersionUID = 3211242351810109432L;
    private static ObjectAllocator NETSCAPESPKI_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new NetscapeSPKI(runtime, klass);
        }
    };
    private IRubyObject public_key;
    private IRubyObject challenge;
    private Object cert;

    public static void createNetscapeSPKI(Ruby runtime, RubyModule ossl) {
        RubyModule mNetscape = ossl.defineModuleUnder("Netscape");
        RubyClass cSPKI = mNetscape.defineClassUnder("SPKI", runtime.getObject(), NETSCAPESPKI_ALLOCATOR);
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        mNetscape.defineClassUnder("SPKIError", openSSLError, openSSLError.getAllocator());
        cSPKI.defineAnnotatedMethods(NetscapeSPKI.class);
    }

    private static RubyModule _Netscape(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("Netscape");
    }

    public NetscapeSPKI(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args) {
        Ruby runtime = context.runtime;
        if (args.length > 0) {
            NetscapeCertRequest cert;
            byte[] request = args[0].convertToString().getBytes();
            request = NetscapeSPKI.tryBase64Decode(request);
            try {
                cert = new NetscapeCertRequest(request);
                this.cert = cert;
                this.challenge = runtime.newString(cert.getChallenge());
            }
            catch (GeneralSecurityException e) {
                throw this.newSPKIError(e);
            }
            catch (IllegalArgumentException e) {
                throw this.newSPKIError(e);
            }
            PublicKey publicKey = cert.getPublicKey();
            String algorithm = publicKey.getAlgorithm();
            RubyString pub_key = RubyString.newString((Ruby)runtime, (byte[])publicKey.getEncoded());
            if ("RSA".equalsIgnoreCase(algorithm)) {
                this.public_key = PKeyRSA._RSA(runtime).callMethod(context, "new", (IRubyObject)pub_key);
            } else if ("DSA".equalsIgnoreCase(algorithm)) {
                this.public_key = PKeyDSA._DSA(runtime).callMethod(context, "new", (IRubyObject)pub_key);
            } else {
                throw runtime.newLoadError("not implemented algo for public key: " + algorithm);
            }
        }
        return this;
    }

    private static byte[] tryBase64Decode(byte[] b) {
        try {
            b = Base64.decode(b, 0, b.length, 0);
        }
        catch (IOException ignored) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return b;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            byte[] derBytes = this.toDER();
            return this.getRuntime().newString(new ByteList(derBytes, false));
        }
        catch (IOException ioe) {
            throw this.newSPKIError(ioe);
        }
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        try {
            byte[] source = this.toDER();
            source = Base64.encodeBytesToBytes(source, 0, source.length, 0);
            return this.getRuntime().newString(new ByteList(source, false));
        }
        catch (IOException ioe) {
            throw this.newSPKIError(ioe);
        }
    }

    private byte[] toDER() throws IOException {
        ASN1Sequence b = (ASN1Sequence)((NetscapeCertRequest)this.cert).toASN1Primitive();
        ASN1ObjectIdentifier encType = (ASN1ObjectIdentifier)((ASN1Sequence)((ASN1Sequence)((ASN1Sequence)b.getObjectAt(0)).getObjectAt(0)).getObjectAt(0)).getObjectAt(0);
        ASN1ObjectIdentifier sigAlg = ((AlgorithmIdentifier)b.getObjectAt(1)).getAlgorithm();
        DERBitString sig = (DERBitString)b.getObjectAt(2);
        DERBitString publicKey = new DERBitString(((PKey)this.public_key).to_der().convertToString().getBytes());
        DERIA5String encodedChallenge = new DERIA5String(this.challenge.toString());
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        ASN1EncodableVector v1_2 = new ASN1EncodableVector();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        ASN1EncodableVector v3 = new ASN1EncodableVector();
        ASN1EncodableVector v4 = new ASN1EncodableVector();
        v4.add((ASN1Encodable)encType);
        v4.add((ASN1Encodable)DERNull.INSTANCE);
        v3.add((ASN1Encodable)new DLSequence(v4));
        v3.add((ASN1Encodable)publicKey);
        v2.add((ASN1Encodable)new DLSequence(v3));
        v2.add((ASN1Encodable)encodedChallenge);
        v1.add((ASN1Encodable)new DLSequence(v2));
        v1_2.add((ASN1Encodable)sigAlg);
        v1_2.add((ASN1Encodable)DERNull.INSTANCE);
        v1.add((ASN1Encodable)new DLSequence(v1_2));
        v1.add((ASN1Encodable)sig);
        return new DLSequence(v1).getEncoded();
    }

    @JRubyMethod
    public IRubyObject to_text() {
        OpenSSLReal.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: Netscape::SPKI#to_text");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject public_key() {
        return this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject public_key) {
        this.public_key = public_key;
        return this.public_key;
    }

    @JRubyMethod
    public IRubyObject sign(IRubyObject key, IRubyObject digest) {
        String keyAlg = ((PKey)key).getAlgorithm();
        String digAlg = ((Digest)digest).getShortAlgorithm();
        String symKey = keyAlg.toLowerCase() + '-' + digAlg.toLowerCase();
        try {
            ASN1ObjectIdentifier alg = ASN1.sym2Oid(this.getRuntime(), symKey);
            PublicKey publicKey = ((PKey)this.public_key).getPublicKey();
            String challengeStr = this.challenge.toString();
            NetscapeCertRequest cert = new NetscapeCertRequest(challengeStr, new AlgorithmIdentifier(alg), publicKey);
            this.cert = cert;
            cert.sign(((PKey)key).getPrivateKey());
        }
        catch (NoSuchAlgorithmException e) {
            OpenSSLReal.debugStackTrace(this.getRuntime(), e);
            throw this.newSPKIError(e);
        }
        catch (GeneralSecurityException e) {
            throw this.newSPKIError(e);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject pkey) {
        NetscapeCertRequest cert = (NetscapeCertRequest)this.cert;
        cert.setPublicKey(((PKey)pkey).getPublicKey());
        try {
            boolean result = cert.verify(this.challenge.toString());
            return this.getRuntime().newBoolean(result);
        }
        catch (NoSuchAlgorithmException e) {
            OpenSSLReal.debugStackTrace(this.getRuntime(), e);
            throw this.newSPKIError(e);
        }
        catch (GeneralSecurityException e) {
            throw this.newSPKIError(e);
        }
    }

    @JRubyMethod
    public IRubyObject challenge() {
        return this.challenge;
    }

    @JRubyMethod(name={"challenge="})
    public IRubyObject set_challenge(IRubyObject challenge) {
        this.challenge = challenge;
        return this.challenge;
    }

    private RaiseException newSPKIError(Exception e) {
        return NetscapeSPKI.newSPKIError(this.getRuntime(), e.getMessage());
    }

    private static RaiseException newSPKIError(Ruby runtime, String message) {
        return Utils.newError(runtime, NetscapeSPKI._Netscape(runtime).getClass("SPKIError"), message);
    }
}

