/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSequence;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Attribute
extends RubyObject {
    private static final long serialVersionUID = 5569940260019783275L;
    private static ObjectAllocator ATTRIBUTE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Attribute(runtime, klass);
        }
    };
    private IRubyObject oid;
    private IRubyObject value;

    public static void createAttribute(Ruby runtime, RubyModule _X509) {
        RubyClass _Attribute = _X509.defineClassUnder("Attribute", runtime.getObject(), ATTRIBUTE_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("AttributeError", openSSLError, openSSLError.getAllocator());
        _Attribute.defineAnnotatedMethods(Attribute.class);
    }

    static RubyClass _Attribute(Ruby runtime) {
        RubyModule _X509 = (RubyModule)runtime.getModule("OpenSSL").getConstant("X509");
        return _X509.getClass("Attribute");
    }

    public Attribute(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private ASN1ObjectIdentifier getObjectIdentifier(String nameOrOid) {
        return ASN1.getObjectIdentifier(this.getRuntime(), nameOrOid);
    }

    ASN1Primitive toASN1() {
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add((ASN1Encodable)this.getObjectIdentifier(this.oid.toString()));
        if (this.value instanceof ASN1.ASN1Constructive) {
            ThreadContext context = this.getRuntime().getCurrentContext();
            v1.add(((ASN1.ASN1Constructive)this.value).toASN1(context));
        } else {
            ThreadContext context = this.getRuntime().getCurrentContext();
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(((ASN1.ASN1Data)this.value).toASN1(context));
            v1.add((ASN1Encodable)new DERSet(v2));
        }
        return new DLSequence(v1);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] str) {
        if (Arity.checkArgumentCount((Ruby)context.runtime, (IRubyObject[])str, (int)1, (int)2) == 1) {
            this.set_oid(OpenSSLImpl.to_der_if_possible(context, str[0]));
            return this;
        }
        this.set_oid(str[0]);
        this.set_value(context, str[1]);
        return this;
    }

    @JRubyMethod
    public IRubyObject to_der(ThreadContext context) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: attribute#to_der");
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject oid() {
        return this.oid;
    }

    @JRubyMethod(name={"oid="})
    public IRubyObject set_oid(IRubyObject oid) {
        this.oid = oid;
        return this.oid;
    }

    @JRubyMethod
    public IRubyObject value() {
        return this.value;
    }

    @JRubyMethod(name={"value="})
    public IRubyObject set_value(ThreadContext context, IRubyObject val) {
        try {
            this.value = ASN1.decodeImpl(context, val);
            return this.value;
        }
        catch (IOException e) {
            throw Utils.newIOError(context.runtime, e);
        }
        catch (IllegalArgumentException e) {
            throw context.runtime.newArgumentError(e.getMessage());
        }
    }
}

