/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PlatformHookWindows
extends PlatformHookUnixoid
implements PlatformHook {
    private static final byte[] INSECURE_PUBLIC_KEY = new byte[]{48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -107, -107, -120, -124, -56, -39, 107, -59, -38, 11, 105, -65, -4, 126, -71, -106, 44, -21, -113, -68, 110, 64, -26, -30, -4, -15, 127, 115, -89, -99, -34, -57, -120, 87, 81, -124, -19, -106, -5, -31, 56, -17, 8, 43, -13, -57, -61, 93, -2, -7, 81, -26, 41, -4, -27, 13, -95, 13, -88, -76, -82, 38, 24, 25, 77, 108, 12, 59, 18, -70, -68, 95, 50, -77, -66, -99, 23, 13, 77, 47, 26, 72, -73, -84, -9, 26, 67, 1, -105, -12, -8, 76, -69, 106, -68, 51, -31, 115, 30, -122, -5, 46, -79, 99, 117, -123, -36, -126, 108, 40, -15, -29, -112, 99, -99, 61, 72, -118, -116, 71, -30, 16, 11, -17, -111, -108, -80, 108, 76, -128, 118, 3, -31, -74, -112, -121, -39, -82, -12, -114, -32, -97, -25, 58, 44, 47, 33, -44, 70, -70, -107, 112, -87, 91, 32, 42, -6, 82, 62, -99, -39, -17, 40, -59, -47, 96, -119, 104, 110, 127, -41, -98, -119, 76, -21, 77, -46, -58, -12, 45, 2, 93, -38, -34, 51, -2, -63, 126, -34, 79, 31, -101, 110, 111, 15, 102, 113, 25, -23, 67, 60, -125, 10, 15, 40, 33, -56, 56, -45, 78, 72, -33, -44, -103, -75, -58, -115, -44, -63, 105, 88, 121, -126, 50, -126, -44, -122, -30, 4, 8, 99, -121, -16, 42, -10, -20, 62, 81, 15, -38, -76, 103, 25, 94, 22, 2, -97, -15, 25, 12, 62, -72, 4, 73, 7, 83, 2, 3, 1, 0, 1};
    private static final String WINDOWS_ROOT = "Windows-ROOT";

    @Override
    public void openUrl(String string) throws IOException {
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
    }

    @Override
    public void initSystemShortcuts() {
        Shortcut.registerSystemShortcut("system:duplicate", I18n.tr("reserved", new Object[0]), 68, 128);
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-01", I18n.tr("reserved", new Object[0]), 154, 576).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-02", I18n.tr("reserved", new Object[0]), 144, 576).setAutomatic();
        Shortcut.registerSystemShortcut("system:copy", I18n.tr("reserved", new Object[0]), 67, 128);
        Shortcut.registerSystemShortcut("system:cut", I18n.tr("reserved", new Object[0]), 88, 128);
        Shortcut.registerSystemShortcut("system:paste", I18n.tr("reserved", new Object[0]), 86, 128);
        Shortcut.registerSystemShortcut("system:undo", I18n.tr("reserved", new Object[0]), 90, 128);
        Shortcut.registerSystemShortcut("system:redo", I18n.tr("reserved", new Object[0]), 89, 128);
        Shortcut.registerSystemShortcut("system:movefocusright", I18n.tr("reserved", new Object[0]), 39, 128);
        Shortcut.registerSystemShortcut("system:movefocusleft", I18n.tr("reserved", new Object[0]), 37, 128);
        Shortcut.registerSystemShortcut("system:movefocusdown", I18n.tr("reserved", new Object[0]), 40, 128);
        Shortcut.registerSystemShortcut("system:movefocusup", I18n.tr("reserved", new Object[0]), 38, 128);
        Shortcut.registerSystemShortcut("system:selectall", I18n.tr("reserved", new Object[0]), 65, 128);
        Shortcut.registerSystemShortcut("microsoft-reserved-31", I18n.tr("reserved", new Object[0]), 10, 512).setAutomatic();
        Shortcut.registerSystemShortcut("system:exit", I18n.tr("reserved", new Object[0]), 115, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-33", I18n.tr("reserved", new Object[0]), 32, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-35", I18n.tr("reserved", new Object[0]), 9, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-36", I18n.tr("reserved", new Object[0]), 9, 640).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-39", I18n.tr("reserved", new Object[0]), 27, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-42", I18n.tr("reserved", new Object[0]), 121, 64);
        Shortcut.registerSystemShortcut("microsoft-reserved-43", I18n.tr("reserved", new Object[0]), 27, 128).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-50", I18n.tr("reserved", new Object[0]), 27, 192).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-51", I18n.tr("reserved", new Object[0]), 16, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-52", I18n.tr("reserved", new Object[0]), 16, 128).setAutomatic();
    }

    @Override
    public String getDefaultStyle() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    }

    @Override
    public boolean rename(File file, File file2) {
        if (file2.exists()) {
            file2.delete();
        }
        return file.renameTo(file2);
    }

    @Override
    public String getOSDescription() {
        return Utils.strip(System.getProperty("os.name")) + " " + (System.getenv("ProgramFiles(x86)") == null ? "32" : "64") + "-Bit";
    }

    public static KeyStore getRootKeystore() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(WINDOWS_ROOT);
        keyStore.load(null, null);
        return keyStore;
    }

    public static void removeInsecureCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        CharSequence charSequence;
        PublicKey publicKey = null;
        try {
            publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(INSECURE_PUBLIC_KEY));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            Main.error(generalSecurityException);
            return;
        }
        KeyStore keyStore = PlatformHookWindows.getRootKeystore();
        Enumeration<String> enumeration = keyStore.aliases();
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        while (enumeration.hasMoreElements()) {
            charSequence = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)charSequence)) continue;
            try {
                keyStore.getCertificate((String)charSequence).verify(publicKey);
                arrayList.add(charSequence);
            }
            catch (InvalidKeyException | NoSuchProviderException | SignatureException generalSecurityException) {
                Main.trace((String)charSequence + " --> " + generalSecurityException.getClass().getName());
            }
        }
        if (!arrayList.isEmpty()) {
            charSequence = new StringBuilder("<html>");
            ((StringBuilder)charSequence).append(I18n.tr("A previous version of JOSM has installed a custom certificate in order to provide HTTPS support for Remote Control:", new Object[0]));
            ((StringBuilder)charSequence).append("<br><ul>");
            for (String string : arrayList) {
                ((StringBuilder)charSequence).append("<li>");
                ((StringBuilder)charSequence).append(string);
                ((StringBuilder)charSequence).append("</li>");
            }
            ((StringBuilder)charSequence).append("</ul>");
            ((StringBuilder)charSequence).append(I18n.tr("It appears it could be an important <b>security risk</b>.<br><br>You are now going to be prompted by Windows to remove this insecure certificate.<br>For your own safety, <b>please click Yes</b> in next dialog.", new Object[0]));
            ((StringBuilder)charSequence).append("</html>");
            JOptionPane.showMessageDialog(Main.parent, ((StringBuilder)charSequence).toString(), I18n.tr("Warning", new Object[0]), 2);
            for (String string : arrayList) {
                Main.warn(I18n.tr("Removing insecure certificate from {0} keystore: {1}", WINDOWS_ROOT, string));
                try {
                    keyStore.deleteEntry(string);
                }
                catch (KeyStoreException keyStoreException) {
                    Main.error(I18n.tr("Unable to remove insecure certificate from keystore: {0}", keyStoreException.getMessage()));
                }
            }
        }
    }

    @Override
    public boolean setupHttpsCertificate(String string, KeyStore.TrustedCertificateEntry trustedCertificateEntry) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = PlatformHookWindows.getRootKeystore();
        String string2 = keyStore.getCertificateAlias(trustedCertificateEntry.getTrustedCertificate());
        if (string2 != null) {
            Main.debug(I18n.tr("JOSM localhost certificate found in {0} keystore: {1}", WINDOWS_ROOT, string2));
            return false;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            stringBuilder.append(I18n.tr("Remote Control is configured to provide HTTPS support.<br>This requires to add a custom certificate generated by JOSM to the Windows Root CA store.<br><br>You are now going to be prompted by Windows to confirm this operation.<br>To enable proper HTTPS support, <b>please click Yes</b> in next dialog.<br><br>If unsure, you can also click No then disable HTTPS support in Remote Control preferences.", new Object[0]));
            stringBuilder.append("</html>");
            JOptionPane.showMessageDialog(Main.parent, stringBuilder.toString(), I18n.tr("HTTPS support in Remote Control", new Object[0]), 1);
        }
        Main.info(I18n.tr("Adding JOSM localhost certificate to {0} keystore", WINDOWS_ROOT));
        keyStore.setEntry(string, trustedCertificateEntry, null);
        return true;
    }
}

