/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

class ImageResource {
    private Map<Dimension, Image> imgCache = new HashMap<Dimension, Image>();
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);

    public ImageResource(Image image) {
        CheckParameterUtil.ensureParameterNotNull(image);
        this.imgCache.put(DEFAULT_DIMENSION, image);
    }

    public ImageResource(SVGDiagram sVGDiagram) {
        CheckParameterUtil.ensureParameterNotNull(sVGDiagram);
        this.svg = sVGDiagram;
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION);
    }

    public ImageIcon getImageIcon(Dimension dimension) {
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException();
        }
        Image image = this.imgCache.get(dimension);
        if (image != null) {
            return new ImageIcon(image);
        }
        if (this.svg != null) {
            image = ImageProvider.createImageFromSvg(this.svg, dimension);
            if (image == null) {
                return null;
            }
            this.imgCache.put(dimension, image);
            return new ImageIcon(image);
        }
        Image image2 = this.imgCache.get(DEFAULT_DIMENSION);
        if (image2 == null) {
            throw new AssertionError();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        ImageIcon imageIcon = new ImageIcon(image2);
        if (n == -1) {
            n = Math.max(1, imageIcon.getIconWidth() * n2 / imageIcon.getIconHeight());
        } else if (n2 == -1) {
            n2 = Math.max(1, imageIcon.getIconHeight() * n / imageIcon.getIconWidth());
        }
        Image image3 = imageIcon.getImage().getScaledInstance(n, n2, 4);
        image = new BufferedImage(n, n2, 2);
        image.getGraphics().drawImage(image3, 0, 0, null);
        this.imgCache.put(dimension, image);
        return new ImageIcon(image);
    }

    public ImageIcon getImageIconBounded(Dimension dimension) {
        float f;
        float f2;
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException();
        }
        if (this.svg != null) {
            f2 = this.svg.getWidth();
            f = this.svg.getHeight();
        } else {
            Image image = this.imgCache.get(DEFAULT_DIMENSION);
            if (image == null) {
                throw new AssertionError();
            }
            ImageIcon imageIcon = new ImageIcon(image);
            f2 = imageIcon.getIconWidth();
            f = imageIcon.getIconHeight();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        if (f2 <= (float)n) {
            n = -1;
        }
        if (f <= (float)n2) {
            n2 = -1;
        }
        if (n == -1 && n2 == -1) {
            return this.getImageIcon(DEFAULT_DIMENSION);
        }
        if (n == -1) {
            return this.getImageIcon(new Dimension(-1, n2));
        }
        if (n2 == -1) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        if (f2 / (float)n > f / (float)n2) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        return this.getImageIcon(new Dimension(-1, n2));
    }
}

