/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerObjectReader
extends OsmServerReader {
    private PrimitiveId id;
    private boolean full;
    private int version;

    public OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl) throws IllegalArgumentException {
        this(l, osmPrimitiveType, bl, -1);
    }

    public OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, int n) throws IllegalArgumentException {
        this(l, osmPrimitiveType, false, n);
    }

    protected OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl, int n) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value > 0 for parameter ''{0}'', got {1}", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        this.id = new SimplePrimitiveId(l, osmPrimitiveType);
        this.full = bl;
        this.version = n;
    }

    public OsmServerObjectReader(PrimitiveId primitiveId, boolean bl) {
        this(primitiveId, bl, -1);
    }

    public OsmServerObjectReader(PrimitiveId primitiveId, int n) {
        this(primitiveId, false, n);
    }

    protected OsmServerObjectReader(PrimitiveId primitiveId, boolean bl, int n) {
        CheckParameterUtil.ensureValidPrimitiveId(primitiveId, "id");
        this.id = primitiveId;
        this.full = bl;
        this.version = n;
    }

    /*
     * Loose catch block
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        progressMonitor.beginTask("", 1);
        try {
            DataSet dataSet;
            Throwable throwable;
            InputStream inputStream;
            block33: {
                block34: {
                    block30: {
                        DataSet dataSet2;
                        block31: {
                            block32: {
                                progressMonitor.indeterminateSubTask(I18n.tr("Downloading OSM data...", new Object[0]));
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(this.id.getType().getAPIName());
                                stringBuilder.append("/");
                                stringBuilder.append(this.id.getUniqueId());
                                if (this.full && !this.id.getType().equals((Object)OsmPrimitiveType.NODE)) {
                                    stringBuilder.append("/full");
                                } else if (this.version > 0) {
                                    stringBuilder.append("/").append(this.version);
                                }
                                inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                                throwable = null;
                                if (inputStream != null) break block30;
                                dataSet2 = null;
                                if (inputStream == null) break block31;
                                if (throwable == null) break block32;
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block31;
                            }
                            inputStream.close();
                        }
                        return dataSet2;
                    }
                    dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(-1, false));
                    if (inputStream == null) break block33;
                    if (throwable == null) break block34;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block33;
                }
                inputStream.close();
            }
            return dataSet;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (OsmTransferException osmTransferException) {
                    if (this.cancel) {
                        inputStream = null;
                        return inputStream;
                    }
                    throw osmTransferException;
                }
                catch (Exception exception) {
                    if (this.cancel) {
                        inputStream = null;
                        return inputStream;
                    }
                    throw new OsmTransferException(exception);
                }
            }
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

