/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.User;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NoteReader {
    private InputSource inputSource;
    private List<Note> parsedNotes;

    public NoteReader(InputStream inputStream) throws IOException {
        this.inputSource = new InputSource(inputStream);
    }

    public List<Note> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.newSAXParser().parse(this.inputSource, (DefaultHandler)parser);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Main.error(parserConfigurationException);
            throw new SAXException(parserConfigurationException);
        }
        return this.parsedNotes;
    }

    private class Parser
    extends DefaultHandler {
        private final SimpleDateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.ENGLISH);
        private final SimpleDateFormat NOTE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ENGLISH);
        private NoteParseMode parseMode;
        private StringBuffer buffer = new StringBuffer();
        private Note thisNote;
        private long commentUid;
        private String commentUsername;
        private NoteComment.Action noteAction;
        private Date commentCreateDate;
        private Boolean commentIsNew;
        private List<Note> notes;
        String commentText;

        private Parser() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.buffer.setLength(0);
            switch (string3) {
                case "osm": {
                    this.parseMode = NoteParseMode.API;
                    this.notes = new ArrayList<Note>(100);
                    return;
                }
                case "osm-notes": {
                    this.parseMode = NoteParseMode.DUMP;
                    this.notes = new ArrayList<Note>(10000);
                    return;
                }
            }
            if (this.parseMode == NoteParseMode.API) {
                if ("note".equals(string3)) {
                    double d = Double.parseDouble(attributes.getValue("lat"));
                    double d2 = Double.parseDouble(attributes.getValue("lon"));
                    LatLon latLon = new LatLon(d, d2);
                    this.thisNote = new Note(latLon);
                }
                return;
            }
            switch (string3) {
                case "note": {
                    double d = Double.parseDouble(attributes.getValue("lat"));
                    double d3 = Double.parseDouble(attributes.getValue("lon"));
                    LatLon latLon = new LatLon(d, d3);
                    this.thisNote = new Note(latLon);
                    this.thisNote.setId(Long.parseLong(attributes.getValue("id")));
                    String string4 = attributes.getValue("closed_at");
                    if (string4 == null) {
                        this.thisNote.setState(Note.State.open);
                    } else {
                        this.thisNote.setState(Note.State.closed);
                        this.thisNote.setClosedAt(this.parseDate(this.ISO8601_FORMAT, string4));
                    }
                    this.thisNote.setCreatedAt(this.parseDate(this.ISO8601_FORMAT, attributes.getValue("created_at")));
                    break;
                }
                case "comment": {
                    String string5 = attributes.getValue("uid");
                    this.commentUid = string5 == null ? 0L : Long.parseLong(string5);
                    this.commentUsername = attributes.getValue("user");
                    this.noteAction = NoteComment.Action.valueOf(attributes.getValue("action"));
                    this.commentCreateDate = this.parseDate(this.ISO8601_FORMAT, attributes.getValue("timestamp"));
                    String string6 = attributes.getValue("is_new");
                    this.commentIsNew = string6 == null ? Boolean.valueOf(false) : Boolean.valueOf(string6);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if ("note".equals(string3)) {
                this.notes.add(this.thisNote);
            }
            if ("comment".equals(string3)) {
                Object object = User.createOsmUser(this.commentUid, this.commentUsername);
                if (this.parseMode == NoteParseMode.API) {
                    this.commentIsNew = false;
                }
                if (this.parseMode == NoteParseMode.DUMP) {
                    this.commentText = this.buffer.toString();
                }
                this.thisNote.addComment(new NoteComment(this.commentCreateDate, (User)object, this.commentText, this.noteAction, this.commentIsNew));
                this.commentUid = 0L;
                this.commentUsername = null;
                this.commentCreateDate = null;
                this.commentIsNew = null;
                this.commentText = null;
            }
            if (this.parseMode == NoteParseMode.DUMP) {
                return;
            }
            switch (string3) {
                case "id": {
                    this.thisNote.setId(Long.parseLong(this.buffer.toString()));
                    break;
                }
                case "status": {
                    this.thisNote.setState(Note.State.valueOf(this.buffer.toString()));
                    break;
                }
                case "date_created": {
                    this.thisNote.setCreatedAt(this.parseDate(this.NOTE_DATE_FORMAT, this.buffer.toString()));
                    break;
                }
                case "date": {
                    this.commentCreateDate = this.parseDate(this.NOTE_DATE_FORMAT, this.buffer.toString());
                    break;
                }
                case "user": {
                    this.commentUsername = this.buffer.toString();
                    break;
                }
                case "uid": {
                    this.commentUid = Long.parseLong(this.buffer.toString());
                    break;
                }
                case "text": {
                    this.commentText = this.buffer.toString();
                    this.buffer.setLength(0);
                    break;
                }
                case "action": {
                    this.noteAction = NoteComment.Action.valueOf(this.buffer.toString());
                    break;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            Main.info("parsed notes: " + this.notes.size());
            NoteReader.this.parsedNotes = this.notes;
        }

        private Date parseDate(SimpleDateFormat simpleDateFormat, String string) {
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                Main.error("error parsing date in note parser");
                return null;
            }
        }
    }

    private static enum NoteParseMode {
        API,
        DUMP;

    }
}

