/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IWithAttributes;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;

public class GpxWriter
extends XmlWriter
implements GpxConstants {
    private GpxData data;
    private String indent = "";
    private static final int WAY_POINT = 0;
    private static final int ROUTE_POINT = 1;
    private static final int TRACK_POINT = 2;

    public GpxWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    public GpxWriter(OutputStream outputStream) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8))));
    }

    public void write(GpxData gpxData) {
        this.data = gpxData;
        boolean bl = gpxData.fromServer;
        if (!bl) {
            for (WayPoint wayPoint : gpxData.waypoints) {
                Extensions extensions = (Extensions)wayPoint.get("meta.extensions");
                if (extensions == null || extensions.isEmpty()) continue;
                bl = true;
                break;
            }
        }
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.println("<gpx version=\"1.1\" creator=\"JOSM GPX export\" xmlns=\"http://www.topografix.com/GPX/1/1\"\n" + (bl ? String.format("    xmlns:josm=\"%s\"%n", JOSM_EXTENSIONS_NAMESPACE_URI) : "") + "    xmlns:xsi=\"" + "http://www.w3.org/2001/XMLSchema-instance" + "\" \n" + "    xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">");
        this.indent = "  ";
        this.writeMetaData();
        this.writeWayPoints();
        this.writeRoutes();
        this.writeTracks();
        this.out.print("</gpx>");
        this.out.flush();
    }

    private void writeAttr(IWithAttributes iWithAttributes, List<String> list) {
        for (String string : list) {
            Object object;
            if (string.equals("meta.links")) {
                object = iWithAttributes.getCollection(string);
                if (object == null) continue;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    GpxLink gpxLink = (GpxLink)iterator.next();
                    this.gpxLink(gpxLink);
                }
                continue;
            }
            if (string.equals("meta.extensions")) {
                object = (Extensions)iWithAttributes.get(string);
                if (object == null) continue;
                this.gpxExtensions((Extensions)object);
                continue;
            }
            object = iWithAttributes.getString(string);
            if (object == null) continue;
            this.simpleTag(string, (String)object);
        }
    }

    private void writeMetaData() {
        Object object;
        Object object2;
        Map map = this.data.attr;
        this.openln("metadata");
        if (map.containsKey("meta.desc")) {
            this.simpleTag("desc", this.data.getString("meta.desc"));
        }
        if (map.containsKey("meta.author.name") || map.containsKey("meta.author.email")) {
            this.openln("author");
            this.simpleTag("name", this.data.getString("meta.author.name"));
            if (map.containsKey("meta.author.email") && ((String[])(object2 = this.data.getString("meta.author.email").split("@"))).length == 2) {
                this.inline("email", "id=\"" + (String)object2[0] + "\" domain=\"" + (String)object2[1] + "\"");
            }
            this.gpxLink((GpxLink)this.data.get("meta.author.link"));
            this.closeln("author");
        }
        if (map.containsKey("meta.copyright.license") || map.containsKey("meta.copyright.year")) {
            this.openAtt("copyright", "author=\"" + this.data.get("meta.copyright.author") + "\"");
            if (map.containsKey("meta.copyright.year")) {
                this.simpleTag("year", (String)this.data.get("meta.copyright.year"));
            }
            if (map.containsKey("meta.copyright.license")) {
                this.simpleTag("license", GpxWriter.encode((String)this.data.get("meta.copyright.license")));
            }
            this.closeln("copyright");
        }
        if (map.containsKey("meta.links")) {
            object2 = this.data.getCollection("meta.links").iterator();
            while (object2.hasNext()) {
                object = (GpxLink)object2.next();
                this.gpxLink((GpxLink)object);
            }
        }
        if (map.containsKey("meta.keywords")) {
            this.simpleTag("keywords", this.data.getString("meta.keywords"));
        }
        if ((object2 = this.data.recalculateBounds()) != null) {
            object = "minlat=\"" + ((Bounds)object2).getMinLat() + "\" minlon=\"" + ((Bounds)object2).getMinLon() + "\" maxlat=\"" + ((Bounds)object2).getMaxLat() + "\" maxlon=\"" + ((Bounds)object2).getMaxLon() + "\"";
            this.inline("bounds", (String)object);
        }
        if (this.data.fromServer) {
            this.openln("extensions");
            this.simpleTag("josm:from-server", "true");
            this.closeln("extensions");
        }
        this.closeln("metadata");
    }

    private void writeWayPoints() {
        for (WayPoint wayPoint : this.data.waypoints) {
            this.wayPoint(wayPoint, 0);
        }
    }

    private void writeRoutes() {
        for (GpxRoute gpxRoute : this.data.routes) {
            this.openln("rte");
            this.writeAttr(gpxRoute, RTE_TRK_KEYS);
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                this.wayPoint(wayPoint, 1);
            }
            this.closeln("rte");
        }
    }

    private void writeTracks() {
        for (GpxTrack gpxTrack : this.data.tracks) {
            this.openln("trk");
            this.writeAttr(gpxTrack, RTE_TRK_KEYS);
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                this.openln("trkseg");
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    this.wayPoint(wayPoint, 2);
                }
                this.closeln("trkseg");
            }
            this.closeln("trk");
        }
    }

    private void openln(String string) {
        this.open(string);
        this.out.println();
    }

    private void open(String string) {
        this.out.print(this.indent + "<" + string + ">");
        this.indent = this.indent + "  ";
    }

    private void openAtt(String string, String string2) {
        this.out.println(this.indent + "<" + string + " " + string2 + ">");
        this.indent = this.indent + "  ";
    }

    private void inline(String string, String string2) {
        this.out.println(this.indent + "<" + string + " " + string2 + "/>");
    }

    private void close(String string) {
        this.indent = this.indent.substring(2);
        this.out.print(this.indent + "</" + string + ">");
    }

    private void closeln(String string) {
        this.close(string);
        this.out.println();
    }

    private void simpleTag(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            this.open(string);
            this.out.print(GpxWriter.encode(string2));
            this.out.println("</" + string + ">");
            this.indent = this.indent.substring(2);
        }
    }

    private void gpxLink(GpxLink gpxLink) {
        if (gpxLink != null) {
            this.openAtt("link", "href=\"" + gpxLink.uri + "\"");
            this.simpleTag("text", gpxLink.text);
            this.simpleTag("type", gpxLink.type);
            this.closeln("link");
        }
    }

    private void wayPoint(WayPoint wayPoint, int n) {
        String string;
        switch (n) {
            case 0: {
                string = "wpt";
                break;
            }
            case 1: {
                string = "rtept";
                break;
            }
            case 2: {
                string = "trkpt";
                break;
            }
            default: {
                throw new RuntimeException(I18n.tr("Unknown mode {0}.", n));
            }
        }
        if (wayPoint != null) {
            LatLon latLon = wayPoint.getCoor();
            String string2 = "lat=\"" + latLon.lat() + "\" lon=\"" + latLon.lon() + "\"";
            if (wayPoint.attr.isEmpty()) {
                this.inline(string, string2);
            } else {
                this.openAtt(string, string2);
                this.writeAttr(wayPoint, WPT_KEYS);
                this.closeln(string);
            }
        }
    }

    private void gpxExtensions(Extensions extensions) {
        if (extensions != null && !extensions.isEmpty()) {
            this.openln("extensions");
            for (Map.Entry entry : extensions.entrySet()) {
                this.simpleTag("josm:" + (String)entry.getKey(), (String)entry.getValue());
            }
            this.closeln("extensions");
        }
    }
}

