/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.NativeFileChooser;
import org.openstreetmap.josm.gui.widgets.SwingFileChooser;

public class FileChooserManager {
    public static final BooleanProperty PROP_USE_NATIVE_FILE_DIALOG = new BooleanProperty("use.native.file.dialog", Main.isPlatformOsx());
    private final boolean open;
    private final String lastDirProperty;
    private final String curDir;
    private AbstractFileChooser fc;

    public FileChooserManager(boolean bl) {
        this(bl, null);
    }

    public FileChooserManager(boolean bl, String string) {
        this(bl, string, null);
    }

    public FileChooserManager(boolean bl, String string, String string2) {
        this.open = bl;
        String string3 = this.lastDirProperty = string == null || string.isEmpty() ? "lastDirectory" : string;
        this.curDir = Main.pref.get(this.lastDirProperty).isEmpty() ? (string2 == null || string2.isEmpty() ? "." : string2) : Main.pref.get(this.lastDirProperty);
    }

    public final AbstractFileChooser getFileChooser() {
        return this.fc;
    }

    public final String getInitialDirectory() {
        return this.curDir;
    }

    public final FileChooserManager createFileChooser() {
        return this.doCreateFileChooser(false, null, null, null, null, 0, false);
    }

    public final FileChooserManager createFileChooser(boolean bl, String string, FileFilter fileFilter, int n) {
        this.doCreateFileChooser(bl, string, Collections.singleton(fileFilter), fileFilter, null, n, false);
        this.getFileChooser().setAcceptAllFileFilterUsed(false);
        return this;
    }

    public final FileChooserManager createFileChooser(boolean bl, String string, Collection<? extends FileFilter> collection, FileFilter fileFilter, int n) {
        return this.doCreateFileChooser(bl, string, collection, fileFilter, null, n, false);
    }

    public final FileChooserManager createFileChooser(boolean bl, String string, String string2, boolean bl2, int n) {
        return this.doCreateFileChooser(bl, string, null, null, string2, n, bl2);
    }

    private final FileChooserManager doCreateFileChooser(boolean bl, String string, Collection<? extends FileFilter> collection, FileFilter fileFilter, String string2, int n, boolean bl2) {
        File file = new File(this.curDir);
        this.fc = PROP_USE_NATIVE_FILE_DIALOG.get() != false && NativeFileChooser.supportsSelectionMode(n) ? new NativeFileChooser(file) : new SwingFileChooser(file);
        if (string != null) {
            this.fc.setDialogTitle(string);
        }
        this.fc.setFileSelectionMode(n);
        this.fc.setMultiSelectionEnabled(bl);
        this.fc.setAcceptAllFileFilterUsed(false);
        if (collection != null) {
            for (FileFilter fileFilter2 : collection) {
                this.fc.addChoosableFileFilter(fileFilter2);
            }
            if (fileFilter != null) {
                this.fc.setFileFilter(fileFilter);
            }
        } else if (this.open) {
            ExtensionFileFilter.applyChoosableImportFileFilters(this.fc, string2, bl2);
        } else {
            ExtensionFileFilter.applyChoosableExportFileFilters(this.fc, string2, bl2);
        }
        return this;
    }

    public final AbstractFileChooser openFileChooser() {
        return this.openFileChooser(null);
    }

    public AbstractFileChooser openFileChooser(Component component) {
        if (this.fc != null) {
            File file;
            int n;
            if (component == null) {
                component = Main.parent;
            }
            int n2 = n = this.open ? this.fc.showOpenDialog(component) : this.fc.showSaveDialog(component);
            if (n != 0) {
                return null;
            }
            if (!this.fc.getCurrentDirectory().getAbsolutePath().equals(this.curDir)) {
                Main.pref.put(this.lastDirProperty, this.fc.getCurrentDirectory().getAbsolutePath());
            }
            if (!this.open && !SaveActionBase.confirmOverwrite(file = this.fc.getSelectedFile())) {
                return null;
            }
        }
        return this.fc;
    }
}

