/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public final class TaggingPresetReader {
    public static final String PRESET_MIME_TYPES = "application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    private static File zipIcons = null;

    private TaggingPresetReader() {
    }

    public static Set<String> getPresetSources() {
        return new TaggingPresetPreference.PresetPrefHelper().getActiveUrls();
    }

    public static List<TaggingPreset> readAll(Reader reader, boolean bl) throws SAXException {
        XmlObjectParser xmlObjectParser = new XmlObjectParser();
        xmlObjectParser.mapOnStart("item", TaggingPreset.class);
        xmlObjectParser.mapOnStart("separator", TaggingPresetSeparator.class);
        xmlObjectParser.mapBoth("group", TaggingPresetMenu.class);
        xmlObjectParser.map("text", TaggingPresetItems.Text.class);
        xmlObjectParser.map("link", TaggingPresetItems.Link.class);
        xmlObjectParser.map("preset_link", TaggingPresetItems.PresetLink.class);
        xmlObjectParser.mapOnStart("optional", TaggingPresetItems.Optional.class);
        xmlObjectParser.mapOnStart("roles", TaggingPresetItems.Roles.class);
        xmlObjectParser.map("role", TaggingPresetItems.Role.class);
        xmlObjectParser.map("checkgroup", TaggingPresetItems.CheckGroup.class);
        xmlObjectParser.map("check", TaggingPresetItems.Check.class);
        xmlObjectParser.map("combo", TaggingPresetItems.Combo.class);
        xmlObjectParser.map("multiselect", TaggingPresetItems.MultiSelect.class);
        xmlObjectParser.map("label", TaggingPresetItems.Label.class);
        xmlObjectParser.map("space", TaggingPresetItems.Space.class);
        xmlObjectParser.map("key", TaggingPresetItems.Key.class);
        xmlObjectParser.map("list_entry", TaggingPresetItems.PresetListEntry.class);
        xmlObjectParser.map("item_separator", TaggingPresetItems.ItemSeparator.class);
        xmlObjectParser.mapBoth("chunk", Chunk.class);
        xmlObjectParser.map("reference", Reference.class);
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        Object object = null;
        TaggingPresetItems.Roles roles = null;
        LinkedList<TaggingPresetItems.Check> linkedList2 = new LinkedList<TaggingPresetItems.Check>();
        LinkedList<TaggingPresetItems.PresetListEntry> linkedList3 = new LinkedList<TaggingPresetItems.PresetListEntry>();
        HashMap hashMap = new HashMap();
        Stack<String> stack = new Stack<String>();
        Stack stack2 = new Stack();
        if (bl) {
            xmlObjectParser.startWithValidation(reader, Main.getXMLBase() + "/tagging-preset-1.0", "resource://data/tagging-preset.xsd");
        } else {
            xmlObjectParser.start(reader);
        }
        while (xmlObjectParser.hasNext() || !stack2.isEmpty()) {
            Object object2;
            Object object3;
            if (!stack2.isEmpty()) {
                object3 = ((Iterator)stack2.peek()).next();
                if (!((Iterator)stack2.peek()).hasNext()) {
                    stack2.pop();
                }
            } else {
                object3 = xmlObjectParser.next();
            }
            if (object3 instanceof Chunk) {
                if (!stack.isEmpty() && ((Chunk)object3).id.equals(stack.peek())) {
                    stack.pop();
                    ((Chunk)object3).id = null;
                    continue;
                }
                object2 = ((Chunk)object3).id;
                stack.push((String)object2);
                hashMap.put((String)object2, new ArrayList());
                continue;
            }
            if (!stack.isEmpty()) {
                ((List)hashMap.get(stack.peek())).add(object3);
                continue;
            }
            if (object3 instanceof Reference) {
                object2 = ((Reference)object3).ref;
                if (hashMap.get(object2) == null) {
                    throw new SAXException(I18n.tr("Reference {0} is being used before it was defined", object2));
                }
                Iterator iterator = ((List)hashMap.get(object2)).iterator();
                if (iterator.hasNext()) {
                    stack2.push(iterator);
                    continue;
                }
                Main.warn("Ignoring reference '" + (String)object2 + "' denoting an empty chunk");
                continue;
            }
            if (!(object3 instanceof TaggingPresetItem) && !linkedList2.isEmpty()) {
                linkedList.getLast().data.addAll(linkedList2);
                linkedList2.clear();
            }
            if (object3 instanceof TaggingPresetMenu) {
                object2 = (TaggingPresetMenu)object3;
                if (object2 == object) {
                    object = ((TaggingPresetMenu)object2).group;
                } else {
                    ((TaggingPresetMenu)object2).group = object;
                    ((TaggingPresetMenu)object2).setDisplayName();
                    object = object2;
                    linkedList.add((TaggingPreset)object2);
                }
                roles = null;
                continue;
            }
            if (object3 instanceof TaggingPresetSeparator) {
                object2 = (TaggingPresetSeparator)object3;
                ((TaggingPresetSeparator)object2).group = object;
                linkedList.add((TaggingPreset)object2);
                roles = null;
                continue;
            }
            if (object3 instanceof TaggingPreset) {
                object2 = (TaggingPreset)object3;
                ((TaggingPreset)object2).group = object;
                ((TaggingPreset)object2).setDisplayName();
                linkedList.add((TaggingPreset)object2);
                roles = null;
                continue;
            }
            if (!linkedList.isEmpty()) {
                if (object3 instanceof TaggingPresetItems.Roles) {
                    linkedList.getLast().data.add((TaggingPresetItem)object3);
                    if (linkedList.getLast().roles != null) {
                        throw new SAXException(I18n.tr("Roles cannot appear more than once", new Object[0]));
                    }
                    linkedList.getLast().roles = (TaggingPresetItems.Roles)object3;
                    roles = (TaggingPresetItems.Roles)object3;
                    continue;
                }
                if (object3 instanceof TaggingPresetItems.Role) {
                    if (roles == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent", new Object[0]));
                    }
                    roles.roles.add((TaggingPresetItems.Role)object3);
                    continue;
                }
                if (object3 instanceof TaggingPresetItems.Check) {
                    linkedList2.add((TaggingPresetItems.Check)object3);
                    continue;
                }
                if (object3 instanceof TaggingPresetItems.PresetListEntry) {
                    linkedList3.add((TaggingPresetItems.PresetListEntry)object3);
                    continue;
                }
                if (object3 instanceof TaggingPresetItems.CheckGroup) {
                    linkedList.getLast().data.add((TaggingPresetItem)object3);
                    ((TaggingPresetItems.CheckGroup)object3).checks.addAll(linkedList2);
                    linkedList2.clear();
                    continue;
                }
                if (!linkedList2.isEmpty()) {
                    linkedList.getLast().data.addAll(linkedList2);
                    linkedList2.clear();
                }
                linkedList.getLast().data.add((TaggingPresetItem)object3);
                if (object3 instanceof TaggingPresetItems.ComboMultiSelect) {
                    ((TaggingPresetItems.ComboMultiSelect)object3).addListEntries(linkedList3);
                } else if (object3 instanceof TaggingPresetItems.Key && ((TaggingPresetItems.Key)object3).value == null) {
                    ((TaggingPresetItems.Key)object3).value = "";
                }
                linkedList3 = new LinkedList();
                roles = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent", new Object[0]));
        }
        if (!linkedList.isEmpty() && !linkedList2.isEmpty()) {
            linkedList.getLast().data.addAll(linkedList2);
            linkedList2.clear();
        }
        return linkedList;
    }

    public static Collection<TaggingPreset> readAll(String string, boolean bl) throws SAXException, IOException {
        List<TaggingPreset> list;
        CachedFile cachedFile = new CachedFile(string).setHttpAccept(PRESET_MIME_TYPES);
        try (InputStream inputStream = cachedFile.findZipEntryInputStream("xml", "preset");){
            if (inputStream != null) {
                zipIcons = cachedFile.getFile();
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream == null ? cachedFile.getInputStream() : inputStream, StandardCharsets.UTF_8);){
                list = TaggingPresetReader.readAll(new BufferedReader(inputStreamReader), bl);
            }
        }
        return list;
    }

    public static Collection<TaggingPreset> readAll(Collection<String> collection, boolean bl) {
        return TaggingPresetReader.readAll(collection, bl, true);
    }

    public static Collection<TaggingPreset> readAll(Collection<String> collection, boolean bl, boolean bl2) {
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        for (String string : collection) {
            try {
                linkedList.addAll(TaggingPresetReader.readAll(string, bl));
            }
            catch (IOException iOException) {
                Main.error(iOException, false);
                Main.error(string);
                if (string.startsWith("http")) {
                    Main.addNetworkError(string, (Throwable)iOException);
                }
                if (!bl2) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", string), I18n.tr("Error", new Object[0]), 0);
            }
            catch (SAXException sAXException) {
                Main.error(sAXException);
                Main.error(string);
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("Error parsing {0}: ", string) + "<br><br><table width=600>" + sAXException.getMessage() + "</table></html>", I18n.tr("Error", new Object[0]), 0);
            }
        }
        return linkedList;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean bl, boolean bl2) {
        return TaggingPresetReader.readAll(TaggingPresetReader.getPresetSources(), bl, bl2);
    }

    public static File getZipIcons() {
        return zipIcons;
    }

    public static class Reference {
        public String ref;
    }

    public static class Chunk {
        public String id;
    }
}

