/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayerTree {
    private final MutableTreeNode treeRootNode = new DefaultMutableTreeNode();
    private final DefaultTreeModel treeData = new DefaultTreeModel(this.treeRootNode);
    private final JTree layerTree = new JTree(this.treeData);
    private final List<WMSImagery.LayerDetails> selectedLayers = new LinkedList<WMSImagery.LayerDetails>();
    private boolean previouslyShownUnsupportedCrsError = false;

    public MutableTreeNode getTreeRootNode() {
        return this.treeRootNode;
    }

    public JTree getLayerTree() {
        return this.layerTree;
    }

    public List<WMSImagery.LayerDetails> getSelectedLayers() {
        return this.selectedLayers;
    }

    public WMSLayerTree() {
        this.layerTree.setCellRenderer(new LayerTreeCellRenderer());
        this.layerTree.addTreeSelectionListener(new WMSTreeSelectionListener());
    }

    void addLayersToTreeData(MutableTreeNode mutableTreeNode, List<WMSImagery.LayerDetails> list) {
        for (WMSImagery.LayerDetails layerDetails : list) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(layerDetails);
            this.addLayersToTreeData(defaultMutableTreeNode, layerDetails.children);
            this.treeData.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, 0);
        }
    }

    public void updateTree(WMSImagery wMSImagery) {
        this.treeRootNode.setUserObject(wMSImagery.getServiceUrl().getHost());
        this.updateTreeList(wMSImagery.getLayers());
    }

    public void updateTreeList(List<WMSImagery.LayerDetails> list) {
        this.addLayersToTreeData(this.getTreeRootNode(), list);
        this.getLayerTree().expandRow(0);
        this.getLayerTree().expandRow(1);
    }

    private class WMSTreeSelectionListener
    implements TreeSelectionListener {
        private WMSTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = WMSLayerTree.this.layerTree.getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            WMSLayerTree.this.selectedLayers.clear();
            for (TreePath treePath : treePathArray) {
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (!(object instanceof WMSImagery.LayerDetails)) continue;
                WMSImagery.LayerDetails layerDetails = (WMSImagery.LayerDetails)object;
                if (!layerDetails.isSupported()) {
                    WMSLayerTree.this.layerTree.removeSelectionPath(treePath);
                    if (WMSLayerTree.this.previouslyShownUnsupportedCrsError) continue;
                    JOptionPane.showMessageDialog(null, I18n.tr("That layer does not support any of JOSM''s projections,\nso you can not use it. This message will not show again.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
                    WMSLayerTree.this.previouslyShownUnsupportedCrsError = true;
                    continue;
                }
                if (layerDetails.ident == null) continue;
                WMSLayerTree.this.selectedLayers.add(layerDetails);
            }
            WMSLayerTree.this.layerTree.firePropertyChange("selectedLayers", false, true);
        }
    }

    private static class LayerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private LayerTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof WMSImagery.LayerDetails) {
                WMSImagery.LayerDetails layerDetails = (WMSImagery.LayerDetails)object2;
                this.setEnabled(layerDetails.isSupported());
            }
            return this;
        }
    }
}

