/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CustomizeDrawingAction
extends AbstractAction
implements Layer.LayerAction,
Layer.MultiLayerAction {
    List<Layer> layers;

    public CustomizeDrawingAction(List<Layer> list) {
        this();
        this.layers = list;
    }

    public CustomizeDrawingAction(Layer layer) {
        this();
        this.layers = new LinkedList<Layer>();
        this.layers.add(layer);
    }

    private CustomizeDrawingAction() {
        super(I18n.tr("Customize track drawing", new Object[0]), ImageProvider.get("mapmode/addsegment"));
        this.putValue("help", HelpUtil.ht("/Action/GPXLayerCustomizeLineDrawing"));
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        for (Layer layer : list) {
            if (layer instanceof GpxLayer) continue;
            return false;
        }
        return true;
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public Action getMultiLayerAction(List<Layer> list) {
        return new CustomizeDrawingAction(list);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (Layer object2 : this.layers) {
            if (!(object2 instanceof GpxLayer)) continue;
            if (((GpxLayer)object2).isLocalFile()) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        GPXSettingsPanel gPXSettingsPanel = new GPXSettingsPanel(this.layers.get(0).getName(), bl, bl2);
        JScrollPane jScrollPane = GuiHelper.embedInVerticalScrollPane(gPXSettingsPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (n2 < 700) {
            jScrollPane.setPreferredSize(new Dimension(gPXSettingsPanel.getPreferredSize().width, Math.min(gPXSettingsPanel.getPreferredSize().height, 450)));
        }
        if ((n = JOptionPane.showConfirmDialog(Main.parent, jScrollPane, I18n.tr("Customize track drawing", new Object[0]), 2, 3)) == 2 || n == -1) {
            return;
        }
        for (Layer layer : this.layers) {
            boolean bl3 = false;
            if (layer instanceof GpxLayer) {
                bl3 = ((GpxLayer)layer).isLocalFile();
            }
            gPXSettingsPanel.savePreferences(layer.getName(), bl3);
        }
        Main.map.repaint();
    }
}

