/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_DIFFERENCE = new Color(255, 197, 197);

    public TagTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void renderName(String string, HistoryBrowserModel.TagTableModel tagTableModel, boolean bl) {
        String string2 = string;
        Color color = UIManager.getColor("Table.background");
        Color color2 = UIManager.getColor("Table.foreground");
        Font font = UIManager.getFont("Table.font");
        if (!tagTableModel.hasTag(string)) {
            string2 = I18n.tr("not present", new Object[0]);
            color = BGCOLOR_DIFFERENCE;
            font = font.deriveFont(2);
        } else if (!tagTableModel.oppositeHasTag(string)) {
            color = BGCOLOR_DIFFERENCE;
        }
        if (bl) {
            color = UIManager.getColor("Table.backgroundSelected");
            color2 = UIManager.getColor("Table.foregroundSelected");
        }
        this.setText(string2);
        this.setToolTipText(string2);
        this.setBackground(color);
        this.setForeground(color2);
        this.setFont(font);
    }

    protected void renderValue(String string, HistoryBrowserModel.TagTableModel tagTableModel, boolean bl) {
        String string2 = "";
        Color color = UIManager.getColor("Table.background");
        Color color2 = UIManager.getColor("Table.foreground");
        Font font = UIManager.getFont("Table.font");
        if (!tagTableModel.hasTag(string)) {
            string2 = I18n.tr("not present", new Object[0]);
            color = BGCOLOR_DIFFERENCE;
            font = font.deriveFont(2);
        } else {
            string2 = tagTableModel.getValue(string);
            if (!tagTableModel.hasSameValueAsOpposite(string)) {
                color = BGCOLOR_DIFFERENCE;
            }
        }
        if (bl) {
            color = UIManager.getColor("Table.backgroundSelected");
            color2 = UIManager.getColor("Table.foregroundSelected");
        }
        this.setText(string2);
        this.setToolTipText(string2);
        this.setBackground(color);
        this.setForeground(color2);
        this.setFont(font);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        String string = (String)object;
        HistoryBrowserModel.TagTableModel tagTableModel = this.getTagTableModel(jTable);
        switch (n2) {
            case 0: {
                this.renderName(string, tagTableModel, bl);
                break;
            }
            case 1: {
                this.renderValue(string, tagTableModel, bl);
            }
        }
        return this;
    }

    protected HistoryBrowserModel.TagTableModel getTagTableModel(JTable jTable) {
        return (HistoryBrowserModel.TagTableModel)jTable.getModel();
    }
}

