/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TigerUtils;

public final class TagConflictResolutionUtil {
    private TagConflictResolutionUtil() {
    }

    public static void normalizeTagCollectionBeforeEditing(TagCollection tagCollection, Collection<? extends OsmPrimitive> collection) {
        for (String iterator : OsmPrimitive.getDiscardableKeys()) {
            tagCollection.removeByKey(iterator);
        }
        ArrayList arrayList = new ArrayList();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.isTagged()) continue;
            arrayList.add(osmPrimitive);
        }
        if (arrayList.size() <= 1) {
            return;
        }
        for (String string : tagCollection.getKeys()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)iterator.next();
                if (osmPrimitive.get(string) != null) continue;
                tagCollection.add(new Tag(string, ""));
            }
        }
    }

    public static void combineTigerTags(TagCollection tagCollection) {
        for (String string : tagCollection.getKeys()) {
            if (!TigerUtils.isTigerTag(string)) continue;
            tagCollection.setUniqueForKey(string, TigerUtils.combineTags(string, tagCollection.getValues(string)));
        }
    }

    public static void completeTagCollectionForEditing(TagCollection tagCollection) {
        for (String string : tagCollection.getKeys()) {
            tagCollection.add(new Tag(string, ""));
        }
    }
}

