/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class CombinePrimitiveResolverDialog
extends JDialog {
    private static CombinePrimitiveResolverDialog instance;
    private AutoAdjustingSplitPane spTagConflictTypes;
    private TagConflictResolver pnlTagConflictResolver;
    private RelationMemberConflictResolver pnlRelationMemberConflictResolver;
    private boolean canceled;
    private JPanel pnlButtons;
    private OsmPrimitive targetPrimitive;
    private ContextSensitiveHelpAction helpAction;
    private SideButton btnApply;

    @Deprecated
    public static CombinePrimitiveResolverDialog getInstance() {
        if (instance == null) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    instance = new CombinePrimitiveResolverDialog(Main.parent);
                }
            });
        }
        return instance;
    }

    public OsmPrimitive getTargetPrimitmive() {
        return this.targetPrimitive;
    }

    public void setTargetPrimitive(final OsmPrimitive osmPrimitive) {
        this.targetPrimitive = osmPrimitive;
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                CombinePrimitiveResolverDialog.this.updateTitle();
                if (osmPrimitive instanceof Way) {
                    CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.initForWayCombining();
                } else if (osmPrimitive instanceof Node) {
                    CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.initForNodeMerging();
                }
            }
        });
    }

    protected void updateTitle() {
        if (this.targetPrimitive == null) {
            this.setTitle(I18n.tr("Conflicts when combining primitives", new Object[0]));
            return;
        }
        if (this.targetPrimitive instanceof Way) {
            this.setTitle(I18n.tr("Conflicts when combining ways - combined way is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
        } else if (this.targetPrimitive instanceof Node) {
            this.setTitle(I18n.tr("Conflicts when merging nodes - target node is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
        }
    }

    protected final void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTitle();
        this.spTagConflictTypes = new AutoAdjustingSplitPane(0);
        this.spTagConflictTypes.setTopComponent(this.buildTagConflictResolverPanel());
        this.spTagConflictTypes.setBottomComponent(this.buildRelationMemberConflictResolverPanel());
        this.pnlButtons = this.buildButtonPanel();
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.addWindowListener(new AdjustDividerLocationAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/"));
    }

    protected JPanel buildTagConflictResolverPanel() {
        this.pnlTagConflictResolver = new TagConflictResolver();
        return this.pnlTagConflictResolver;
    }

    protected JPanel buildRelationMemberConflictResolverPanel() {
        this.pnlRelationMemberConflictResolver = new RelationMemberConflictResolver();
        return this.pnlRelationMemberConflictResolver;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        ApplyAction applyAction = new ApplyAction();
        this.pnlTagConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.pnlRelationMemberConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.btnApply = new SideButton(applyAction);
        this.btnApply.setFocusable(true);
        jPanel.add(this.btnApply);
        CancelAction cancelAction = new CancelAction();
        jPanel.add(new SideButton(cancelAction));
        this.helpAction = new ContextSensitiveHelpAction();
        jPanel.add(new SideButton(this.helpAction));
        return jPanel;
    }

    public CombinePrimitiveResolverDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public TagConflictResolverModel getTagConflictResolverModel() {
        return this.pnlTagConflictResolver.getModel();
    }

    public RelationMemberConflictResolverModel getRelationMemberConflictResolverModel() {
        return this.pnlRelationMemberConflictResolver.getModel();
    }

    public boolean isResolvedCompletely() {
        return this.getTagConflictResolverModel().isResolvedCompletely() && this.getRelationMemberConflictResolverModel().isResolvedCompletely();
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive osmPrimitive, TagCollection tagCollection) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (String string : tagCollection.getKeys()) {
            if (tagCollection.hasUniqueEmptyValue(string)) {
                if (osmPrimitive.get(string) == null) continue;
                linkedList.add(new ChangePropertyCommand(osmPrimitive, string, null));
                continue;
            }
            String string2 = tagCollection.getJoinedValues(string);
            if (string2.equals(osmPrimitive.get(string))) continue;
            linkedList.add(new ChangePropertyCommand(osmPrimitive, string, string2));
        }
        return linkedList;
    }

    public List<Command> buildResolutionCommands() {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        TagCollection tagCollection = this.getTagConflictResolverModel().getAllResolutions();
        if (!tagCollection.isEmpty()) {
            linkedList.addAll(this.buildTagChangeCommand(this.targetPrimitive, tagCollection));
        }
        Object object = OsmPrimitive.getDiscardableKeys().iterator();
        while (object.hasNext()) {
            String string = object.next();
            if (this.targetPrimitive.get(string) == null) continue;
            linkedList.add(new ChangePropertyCommand(this.targetPrimitive, string, null));
        }
        if (this.getRelationMemberConflictResolverModel().getNumDecisions() > 0) {
            linkedList.addAll(this.getRelationMemberConflictResolverModel().buildResolutionCommands(this.targetPrimitive));
        }
        if ((object = this.pnlRelationMemberConflictResolver.buildTagApplyCommands(this.getRelationMemberConflictResolverModel().getModifiedRelations(this.targetPrimitive))) != null) {
            linkedList.add((Command)object);
        }
        return linkedList;
    }

    protected void prepareDefaultTagDecisions() {
        TagConflictResolverModel tagConflictResolverModel = this.getTagConflictResolverModel();
        tagConflictResolverModel.prepareDefaultTagDecisions();
        tagConflictResolverModel.rebuild();
    }

    protected void prepareDefaultRelationDecisions() {
        RelationMemberConflictResolverModel relationMemberConflictResolverModel = this.getRelationMemberConflictResolverModel();
        HashMap<Relation, Integer> hashMap = new HashMap<Relation, Integer>();
        MultiMap<OsmPrimitive, Relation> multiMap = new MultiMap<OsmPrimitive, Relation>();
        for (int i = 0; i < relationMemberConflictResolverModel.getNumDecisions(); ++i) {
            RelationMemberConflictDecision relationMemberConflictDecision = relationMemberConflictResolverModel.getDecision(i);
            Relation relation = relationMemberConflictDecision.getRelation();
            OsmPrimitive osmPrimitive = relationMemberConflictDecision.getOriginalPrimitive();
            if (!hashMap.containsKey(relation)) {
                relationMemberConflictDecision.decide(RelationMemberConflictDecisionType.KEEP);
                hashMap.put(relation, 1);
                multiMap.put(osmPrimitive, relation);
                continue;
            }
            Integer n = (Integer)hashMap.get(relation);
            Collection collection = Utils.firstNonNull(multiMap.get(osmPrimitive), Collections.emptyList());
            if (n <= Utils.filter(collection, Predicates.equalTo(relation)).size()) {
                relationMemberConflictDecision.decide(RelationMemberConflictDecisionType.KEEP);
                hashMap.put(relation, n + 1);
                multiMap.put(osmPrimitive, relation);
                continue;
            }
            relationMemberConflictDecision.decide(RelationMemberConflictDecisionType.REMOVE);
            multiMap.put(osmPrimitive, relation);
        }
        relationMemberConflictResolverModel.refresh();
    }

    public void prepareDefaultDecisions() {
        this.prepareDefaultTagDecisions();
        this.prepareDefaultRelationDecisions();
    }

    protected JPanel buildEmptyConflictsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(new JLabel(I18n.tr("No conflicts to resolve", new Object[0])));
        return jPanel;
    }

    protected void prepareGUIBeforeConflictResolutionStarts() {
        RelationMemberConflictResolverModel relationMemberConflictResolverModel = this.getRelationMemberConflictResolverModel();
        TagConflictResolverModel tagConflictResolverModel = this.getTagConflictResolverModel();
        this.getContentPane().removeAll();
        if (relationMemberConflictResolverModel.getNumDecisions() > 0 && tagConflictResolverModel.getNumDecisions() > 0) {
            this.spTagConflictTypes.setTopComponent(this.pnlTagConflictResolver);
            this.spTagConflictTypes.setBottomComponent(this.pnlRelationMemberConflictResolver);
            this.getContentPane().add((Component)this.spTagConflictTypes, "Center");
        } else if (relationMemberConflictResolverModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlRelationMemberConflictResolver, "Center");
        } else if (tagConflictResolverModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlTagConflictResolver, "Center");
        } else {
            this.getContentPane().add((Component)this.buildEmptyConflictsPanel(), "Center");
        }
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.validate();
        int n = this.getTagConflictResolverModel().getNumDecisions();
        int n2 = this.getRelationMemberConflictResolverModel().getNumDecisions();
        if (n > 0 && n2 > 0) {
            this.spTagConflictTypes.setDividerLocation(0.5);
        }
        this.pnlRelationMemberConflictResolver.prepareForEditing();
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.prepareGUIBeforeConflictResolutionStarts();
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(600, 400))).applySafe(this);
            this.setCanceled(false);
            this.btnApply.requestFocusInWindow();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public static List<Command> launchIfNecessary(TagCollection tagCollection, Collection<? extends OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) throws UserCancelException {
        CheckParameterUtil.ensureParameterNotNull(tagCollection, "tagsOfPrimitives");
        CheckParameterUtil.ensureParameterNotNull(collection, "primitives");
        CheckParameterUtil.ensureParameterNotNull(collection2, "targetPrimitives");
        TagCollection tagCollection2 = new TagCollection(tagCollection);
        TagConflictResolutionUtil.combineTigerTags(tagCollection2);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(tagCollection2, collection);
        TagCollection tagCollection3 = new TagCollection(tagCollection2);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagCollection3);
        Set<Relation> set = OsmPrimitive.getParentRelations(collection);
        if (!ExpertToggleAction.isExpert()) {
            if (!tagCollection2.isApplicableToPrimitive()) {
                CombinePrimitiveResolverDialog.informAboutTagConflicts(collection, tagCollection2);
            }
            if (!set.isEmpty()) {
                CombinePrimitiveResolverDialog.informAboutRelationMembershipConflicts(collection, set);
            }
        }
        CombinePrimitiveResolverDialog combinePrimitiveResolverDialog = CombinePrimitiveResolverDialog.getInstance();
        combinePrimitiveResolverDialog.getTagConflictResolverModel().populate(tagCollection3, tagCollection2.getKeysWithMultipleValues());
        combinePrimitiveResolverDialog.getRelationMemberConflictResolverModel().populate(set, collection);
        combinePrimitiveResolverDialog.prepareDefaultDecisions();
        if (collection2.size() == 1) {
            combinePrimitiveResolverDialog.setTargetPrimitive(collection2.iterator().next());
        } else {
            combinePrimitiveResolverDialog.setTargetPrimitive(null);
        }
        if (!combinePrimitiveResolverDialog.isResolvedCompletely()) {
            combinePrimitiveResolverDialog.setVisible(true);
            if (combinePrimitiveResolverDialog.isCanceled()) {
                throw new UserCancelException();
            }
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (OsmPrimitive osmPrimitive : collection2) {
            combinePrimitiveResolverDialog.setTargetPrimitive(osmPrimitive);
            linkedList.addAll(combinePrimitiveResolverDialog.buildResolutionCommands());
        }
        return linkedList;
    }

    protected static void informAboutRelationMembershipConflicts(Collection<? extends OsmPrimitive> collection, Set<Relation> set) throws UserCancelException {
        String string = I18n.trn("You are about to combine {1} object, which is part of {0} relation:<br/>{2}Combining these objects may break this relation. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relation.<br/><br/>Do you want to continue?", "You are about to combine {1} objects, which are part of {0} relations:<br/>{2}Combining these objects may break these relations. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relations.<br/><br/>Do you want to continue?", set.size(), set.size(), collection.size(), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(set));
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_tags", Main.parent, "<html>" + string + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    protected static void informAboutTagConflicts(Collection<? extends OsmPrimitive> collection, final TagCollection tagCollection) throws UserCancelException {
        String string = Utils.joinAsHtmlUnorderedList(Utils.transform(tagCollection.getKeysWithMultipleValues(), new Utils.Function<String, String>(){

            @Override
            public String apply(String string) {
                return I18n.tr("{0} ({1})", string, Utils.join(I18n.tr(", ", new Object[0]), Utils.transform(tagCollection.getValues(string), new Utils.Function<String, String>(){

                    @Override
                    public String apply(String string) {
                        return string == null || string.isEmpty() ? I18n.tr("<i>missing</i>", new Object[0]) : string;
                    }
                })));
            }
        }));
        String string2 = I18n.trn("You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", "You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", collection.size(), collection.size(), string);
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_tags", Main.parent, "<html>" + string2 + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    static class AutoAdjustingSplitPane
    extends JSplitPane
    implements PropertyChangeListener,
    HierarchyBoundsListener {
        private double dividerLocation;

        public AutoAdjustingSplitPane(int n) {
            super(n);
            this.addPropertyChangeListener("dividerLocation", this);
            this.addHierarchyBoundsListener(this);
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            this.setDividerLocation((int)(this.dividerLocation * (double)this.getHeight()));
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                if (this.getHeight() != 0) {
                    this.dividerLocation = (double)n / (double)this.getHeight();
                }
            }
        }
    }

    class AdjustDividerLocationAction
    extends WindowAdapter {
        AdjustDividerLocationAction() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            int n = CombinePrimitiveResolverDialog.this.getTagConflictResolverModel().getNumDecisions();
            int n2 = CombinePrimitiveResolverDialog.this.getRelationMemberConflictResolverModel().getNumDecisions();
            if (n > 0 && n2 > 0) {
                CombinePrimitiveResolverDialog.this.spTagConflictTypes.setDividerLocation(0.5);
            }
        }
    }

    class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts", new Object[0]));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CombinePrimitiveResolverDialog.this.setVisible(false);
            CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.rememberPreferences();
        }

        protected final void updateEnabledState() {
            this.setEnabled(CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.getModel().getNumConflicts() == 0 && CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.getModel().getNumConflicts() == 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
            if (propertyChangeEvent.getPropertyName().equals(RelationMemberConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CombinePrimitiveResolverDialog.this.setCanceled(true);
            CombinePrimitiveResolverDialog.this.setVisible(false);
        }
    }
}

