/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.actionsupport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class DeleteFromRelationConfirmationDialog
extends JDialog
implements TableModelListener {
    private static DeleteFromRelationConfirmationDialog instance;
    private RelationMemberTableModel model;
    private HtmlPanel htmlPanel;
    private boolean canceled;
    private SideButton btnOK;

    public static DeleteFromRelationConfirmationDialog getInstance() {
        if (instance == null) {
            instance = new DeleteFromRelationConfirmationDialog();
        }
        return instance;
    }

    protected JPanel buildRelationMemberTablePanel() {
        JTable jTable = new JTable(this.model, new RelationMemberTableColumnModel());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(new JScrollPane(jTable));
        return jPanel;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.btnOK = new SideButton(new OKAction());
        jPanel.add(this.btnOK);
        this.btnOK.setFocusable(true);
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Delete#DeleteFromRelations"))));
        return jPanel;
    }

    protected final void build() {
        this.model = new RelationMemberTableModel();
        this.model.addTableModelListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.htmlPanel = new HtmlPanel();
        this.getContentPane().add((Component)this.htmlPanel, "North");
        this.getContentPane().add((Component)this.buildRelationMemberTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Delete#DeleteFromRelations"));
        this.addWindowListener(new WindowEventHandler());
    }

    protected void updateMessage() {
        int n = this.model.getNumObjectsToDelete();
        int n2 = this.model.getNumParentRelations();
        String string = n == 1 && n2 == 1 ? I18n.tr("<html>Please confirm to remove <strong>1 object</strong> from <strong>1 relation</strong>.</html>", new Object[0]) : (n == 1 && n2 > 1 ? I18n.tr("<html>Please confirm to remove <strong>1 object</strong> from <strong>{0} relations</strong>.</html>", n2) : (n > 1 && n2 == 1 ? I18n.tr("<html>Please confirm to remove <strong>1 object</strong> from <strong>{0} relations</strong>.</html>", n2) : I18n.tr("<html>Please confirm to remove <strong>{0} objects</strong> from <strong>{1} relations</strong>.</html>", n, n2)));
        this.htmlPanel.getEditorPane().setText(string);
        this.invalidate();
    }

    protected void updateTitle() {
        int n = this.model.getNumObjectsToDelete();
        if (n > 0) {
            this.setTitle(I18n.trn("Deleting {0} object", "Deleting {0} objects", n, n));
        } else {
            this.setTitle(I18n.tr("Delete objects", new Object[0]));
        }
    }

    public DeleteFromRelationConfirmationDialog() {
        super((Window)JOptionPane.getFrameForComponent(Main.parent), "", Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public RelationMemberTableModel getModel() {
        return this.model;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(400, 200))).applySafe(this);
            this.setCanceled(false);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateMessage();
        this.updateTitle();
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            DeleteFromRelationConfirmationDialog.this.btnOK.requestFocusInWindow();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort deleting the objects", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and remove the object from the relations", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(false);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    private static class RelationMemberTableColumnModel
    extends DefaultTableColumnModel {
        protected final void createColumns() {
            TableColumn tableColumn = null;
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("To delete", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(100);
            tableColumn.setPreferredWidth(100);
            tableColumn.setCellRenderer(new OsmPrimitivRenderer());
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("From Relation", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(100);
            tableColumn.setPreferredWidth(100);
            tableColumn.setCellRenderer(new OsmPrimitivRenderer());
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(2);
            tableColumn.setHeaderValue(I18n.tr("Pos.", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(30);
            tableColumn.setPreferredWidth(30);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(3);
            tableColumn.setHeaderValue(I18n.tr("Role", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(50);
            tableColumn.setPreferredWidth(50);
            this.addColumn(tableColumn);
        }

        public RelationMemberTableColumnModel() {
            this.createColumns();
        }
    }

    public static class RelationMemberTableModel
    extends DefaultTableModel {
        private List<RelationToChildReference> data = new ArrayList<RelationToChildReference>();

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<RelationToChildReference>(){
                private NameFormatter nf = DefaultNameFormatter.getInstance();

                @Override
                public int compare(RelationToChildReference relationToChildReference, RelationToChildReference relationToChildReference2) {
                    int n = relationToChildReference.getChild().getDisplayName(this.nf).compareTo(relationToChildReference2.getChild().getDisplayName(this.nf));
                    if (n != 0) {
                        return n;
                    }
                    n = relationToChildReference.getParent().getDisplayName(this.nf).compareTo(relationToChildReference2.getParent().getDisplayName(this.nf));
                    if (n != 0) {
                        return n;
                    }
                    return Integer.valueOf(relationToChildReference.getPosition()).compareTo(relationToChildReference2.getPosition());
                }
            });
        }

        public void populate(Collection<RelationToChildReference> collection) {
            this.data.clear();
            if (collection != null) {
                this.data.addAll(collection);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public Set<OsmPrimitive> getObjectsToDelete() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (RelationToChildReference relationToChildReference : this.data) {
                hashSet.add(relationToChildReference.getChild());
            }
            return hashSet;
        }

        public int getNumObjectsToDelete() {
            return this.getObjectsToDelete().size();
        }

        public Set<OsmPrimitive> getParentRelations() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (RelationToChildReference relationToChildReference : this.data) {
                hashSet.add(relationToChildReference.getParent());
            }
            return hashSet;
        }

        public int getNumParentRelations() {
            return this.getParentRelations().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.data == null) {
                return null;
            }
            RelationToChildReference relationToChildReference = this.data.get(n);
            switch (n2) {
                case 0: {
                    return relationToChildReference.getChild();
                }
                case 1: {
                    return relationToChildReference.getParent();
                }
                case 2: {
                    return relationToChildReference.getPosition() + 1;
                }
                case 3: {
                    return relationToChildReference.getRole();
                }
            }
            assert (false) : "Illegal column index";
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

