/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SelectByInternalPointAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class SelectionManager
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final SelectionEnded selectionEndedListener;
    private Point mousePosStart;
    private Point mousePos;
    private final NavigatableComponent nc;
    private boolean aspectRatio;
    private boolean lassoMode;
    private Polygon lasso = new Polygon();

    public SelectionManager(SelectionEnded selectionEnded, boolean bl, NavigatableComponent navigatableComponent) {
        this.selectionEndedListener = selectionEnded;
        this.aspectRatio = bl;
        this.nc = navigatableComponent;
    }

    public void register(NavigatableComponent navigatableComponent, boolean bl) {
        this.lassoMode = bl;
        navigatableComponent.addMouseListener(this);
        navigatableComponent.addMouseMotionListener(this);
        this.selectionEndedListener.addPropertyChangeListener(this);
        navigatableComponent.addPropertyChangeListener("scale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (SelectionManager.this.mousePosStart != null) {
                    SelectionManager.this.paintRect();
                    SelectionManager.this.mousePos = (SelectionManager.this.mousePosStart = null);
                }
            }
        });
    }

    public void unregister(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        this.selectionEndedListener.removePropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1) {
            SelectByInternalPointAction.performSelection(Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY()), (mouseEvent.getModifiersEx() & 0x40) > 0, (mouseEvent.getModifiersEx() & 0x80) > 0);
        } else if (mouseEvent.getButton() == 1) {
            this.mousePosStart = this.mousePos = mouseEvent.getPoint();
            this.lasso.reset();
            this.lasso.addPoint(this.mousePosStart.x, this.mousePosStart.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx() & 0x1400;
        if (n != 0) {
            if (this.mousePosStart == null) {
                this.mousePosStart = this.mousePos = mouseEvent.getPoint();
            }
            if (!this.lassoMode) {
                this.paintRect();
            }
        }
        if (n == 1024) {
            this.mousePos = mouseEvent.getPoint();
            if (this.lassoMode) {
                this.paintLasso();
            } else {
                this.paintRect();
            }
        } else if (n == 5120) {
            this.mousePosStart.x += mouseEvent.getX() - this.mousePos.x;
            this.mousePosStart.y += mouseEvent.getY() - this.mousePos.y;
            this.mousePos = mouseEvent.getPoint();
            this.paintRect();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this.mousePos == null || this.mousePosStart == null) {
            return;
        }
        if (!this.lassoMode) {
            this.nc.requestClearRect();
            rectangle = this.getSelectionRectangle();
            this.lasso = this.rectToPolygon(rectangle);
        } else {
            this.nc.requestClearPoly();
            this.lasso.addPoint(this.mousePos.x, this.mousePos.y);
            rectangle = this.lasso.getBounds();
        }
        this.mousePosStart = null;
        this.mousePos = null;
        if ((mouseEvent.getModifiersEx() & 0x1000) == 0) {
            this.selectionEndedListener.selectionEnded(rectangle, mouseEvent);
        }
    }

    private void paintRect() {
        if (this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart) {
            return;
        }
        this.nc.requestPaintRect(this.getSelectionRectangle());
    }

    private void paintLasso() {
        if (this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart) {
            return;
        }
        this.lasso.addPoint(this.mousePos.x, this.mousePos.y);
        this.nc.requestPaintPoly(this.lasso);
    }

    private Rectangle getSelectionRectangle() {
        int n = this.mousePosStart.x;
        int n2 = this.mousePosStart.y;
        int n3 = this.mousePos.x - this.mousePosStart.x;
        int n4 = this.mousePos.y - this.mousePosStart.y;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (this.aspectRatio) {
            double d = (double)this.nc.getWidth() / (double)this.nc.getHeight();
            if ((double)n3 / (double)n4 < d) {
                int n5 = (int)((double)n4 * d);
                if (this.mousePos.x < this.mousePosStart.x) {
                    n += n3 - n5;
                }
                n3 = n5;
            } else {
                int n6 = (int)((double)n3 / d);
                if (this.mousePos.y < this.mousePosStart.y) {
                    n2 += n4 - n6;
                }
                n4 = n6;
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("active".equals(propertyChangeEvent.getPropertyName()) && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && this.mousePosStart != null) {
            this.paintRect();
            this.mousePosStart = null;
            this.mousePos = null;
        }
    }

    public Collection<OsmPrimitive> getSelectedObjects(boolean bl) {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        boolean bl2 = false;
        Rectangle rectangle = this.lasso.getBounds();
        if (rectangle.height <= 2 && rectangle.width <= 2) {
            bl2 = true;
        }
        if (bl2) {
            Point point = new Point(this.lasso.xpoints[0], this.lasso.ypoints[0]);
            OsmPrimitive osmPrimitive = this.nc.getNearestNodeOrWay(point, OsmPrimitive.isSelectablePredicate, false);
            if (osmPrimitive != null) {
                linkedList.add(osmPrimitive);
            }
        } else {
            for (Node osmPrimitive : this.nc.getCurrentDataSet().getNodes()) {
                if (!osmPrimitive.isSelectable() || !this.lasso.contains(this.nc.getPoint2D(osmPrimitive))) continue;
                linkedList.add(osmPrimitive);
            }
            block1: for (Way way : this.nc.getCurrentDataSet().getWays()) {
                if (!way.isSelectable() || way.getNodesCount() == 0) continue;
                if (bl) {
                    for (Node node : way.getNodes()) {
                        if (node.isIncomplete() || !this.lasso.contains(this.nc.getPoint2D(node))) continue;
                        linkedList.add(way);
                        continue block1;
                    }
                    continue;
                }
                boolean bl3 = true;
                for (Node node : way.getNodes()) {
                    if (node.isIncomplete() || this.lasso.contains(this.nc.getPoint(node))) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                linkedList.add(way);
            }
        }
        return linkedList;
    }

    private Polygon rectToPolygon(Rectangle rectangle) {
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
        return polygon;
    }

    public void setLassoMode(boolean bl) {
        this.lassoMode = bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static interface SelectionEnded {
        public void selectionEnded(Rectangle var1, MouseEvent var2);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

