/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ImageLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapStatus
extends JPanel
implements Helpful,
Destroyable,
Preferences.PreferenceChangedListener {
    private static final DecimalFormat ONE_DECIMAL_PLACE = new DecimalFormat("0.0");
    public static final ColorProperty PROP_BACKGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar background"), Color.decode("#b8cfe5"));
    public static final ColorProperty PROP_ACTIVE_BACKGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar background: active"), Color.decode("#aaff5e"));
    public static final ColorProperty PROP_FOREGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar foreground"), Color.black);
    public static final ColorProperty PROP_ACTIVE_FOREGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar foreground: active"), Color.black);
    final MapView mv;
    final Collector collector;
    final ImageLabel latText = new ImageLabel("lat", I18n.tr("The geographic latitude at the mouse pointer.", new Object[0]), 11, PROP_BACKGROUND_COLOR.get());
    final ImageLabel lonText = new ImageLabel("lon", I18n.tr("The geographic longitude at the mouse pointer.", new Object[0]), 11, PROP_BACKGROUND_COLOR.get());
    final ImageLabel headingText = new ImageLabel("heading", I18n.tr("The (compass) heading of the line segment being drawn.", new Object[0]), 6, PROP_BACKGROUND_COLOR.get());
    final ImageLabel angleText = new ImageLabel("angle", I18n.tr("The angle between the previous and the current way segment.", new Object[0]), 6, PROP_BACKGROUND_COLOR.get());
    final ImageLabel distText = new ImageLabel("dist", I18n.tr("The length of the new way segment being drawn.", new Object[0]), 10, PROP_BACKGROUND_COLOR.get());
    final ImageLabel nameText = new ImageLabel("name", I18n.tr("The name of the object at the mouse pointer.", new Object[0]), 20, PROP_BACKGROUND_COLOR.get());
    final JosmTextField helpText = new JosmTextField();
    final JProgressBar progressBar = new JProgressBar();
    public final BackgroundProgressMonitor progressMonitor = new BackgroundProgressMonitor();
    private final NavigatableComponent.SoMChangeListener somListener;
    private double distValue;
    private boolean angleEnabled = false;
    private Thread thread;
    private final List<StatusTextHistory> statusText = new ArrayList<StatusTextHistory>();
    MouseState mouseState = new MouseState();
    private AWTEventListener awtListener = new AWTEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof InputEvent && ((InputEvent)aWTEvent).getComponent() == MapStatus.this.mv) {
                Collector collector = MapStatus.this.collector;
                synchronized (collector) {
                    MapStatus.this.mouseState.modifiers = ((InputEvent)aWTEvent).getModifiersEx();
                    if (aWTEvent instanceof MouseEvent) {
                        MapStatus.this.mouseState.mousePos = ((MouseEvent)aWTEvent).getPoint();
                    }
                    MapStatus.this.collector.notify();
                }
            }
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.mouseState.modifiers = mouseEvent.getModifiersEx();
                MapStatus.this.mouseState.mousePos = mouseEvent.getPoint();
                MapStatus.this.collector.notify();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.mouseState.modifiers = keyEvent.getModifiersEx();
                MapStatus.this.collector.notify();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.keyPressed(keyEvent);
        }
    };

    private void registerListeners() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 56L);
        }
        catch (SecurityException securityException) {
            this.mv.addMouseMotionListener(this.mouseMotionListener);
            this.mv.addKeyListener(this.keyAdapter);
        }
    }

    private void unregisterListeners() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.mv.removeMouseMotionListener(this.mouseMotionListener);
        this.mv.removeKeyListener(this.keyAdapter);
    }

    public MapStatus(MapFrame mapFrame) {
        this.mv = mapFrame.mapView;
        this.collector = new Collector(mapFrame);
        this.setComponentPopupMenu(new MapStatusPopupMenu());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    Main.main.menu.jumpToAct.showJumpToDialog();
                }
            }
        };
        this.mv.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (MapStatus.this.mv.center == null) {
                    return;
                }
                if ((mouseEvent.getModifiersEx() & 0x80) == 0) {
                    CoordinateFormat coordinateFormat = CoordinateFormat.getDefaultFormat();
                    LatLon latLon = MapStatus.this.mv.getLatLon(mouseEvent.getX(), mouseEvent.getY());
                    MapStatus.this.latText.setText(latLon.latToString(coordinateFormat));
                    MapStatus.this.lonText.setText(latLon.lonToString(coordinateFormat));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.latText.setInheritsPopupMenu(true);
        this.lonText.setInheritsPopupMenu(true);
        this.headingText.setInheritsPopupMenu(true);
        this.distText.setInheritsPopupMenu(true);
        this.nameText.setInheritsPopupMenu(true);
        this.add((Component)this.latText, GBC.std());
        this.add((Component)this.lonText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.headingText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.angleText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.distText, GBC.std().insets(3, 0, 0, 0));
        if (Main.pref.getBoolean("statusbar.change-system-of-measurement-on-click", true)) {
            this.distText.addMouseListener(new MouseAdapter(){
                private final List<String> soms = new ArrayList<String>(new TreeSet<String>(SystemOfMeasurement.ALL_SYSTEMS.keySet()));

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger() && mouseEvent.getButton() == 1) {
                        String string = ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get();
                        String string2 = this.soms.get((this.soms.indexOf(string) + 1) % this.soms.size());
                        MapStatus.this.updateSystemOfMeasurement(string2);
                    }
                }
            });
        }
        this.somListener = new NavigatableComponent.SoMChangeListener(){

            @Override
            public void systemOfMeasurementChanged(String string, String string2) {
                MapStatus.this.setDist(MapStatus.this.distValue);
            }
        };
        NavigatableComponent.addSoMChangeListener(this.somListener);
        this.latText.addMouseListener(mouseAdapter);
        this.lonText.addMouseListener(mouseAdapter);
        this.helpText.setEditable(false);
        this.add((Component)this.nameText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.helpText, GBC.std().insets(3, 0, 0, 0).fill(2));
        this.progressBar.setMaximum(10000);
        this.progressBar.setVisible(false);
        GBC gBC = GBC.eol();
        gBC.ipadx = 100;
        this.add((Component)this.progressBar, gBC);
        this.progressBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PleaseWaitProgressMonitor pleaseWaitProgressMonitor = Main.currentProgressMonitor;
                if (pleaseWaitProgressMonitor != null) {
                    pleaseWaitProgressMonitor.showForegroundDialog();
                }
            }
        });
        Main.pref.addPreferenceChangeListener(this);
        this.thread = new Thread((Runnable)this.collector, "Map Status Collector");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void updateSystemOfMeasurement(String string) {
        NavigatableComponent.setSystemOfMeasurement(string);
        if (Main.pref.getBoolean("statusbar.notify.change-system-of-measurement", true)) {
            new Notification(I18n.tr("System of measurement changed to {0}", string)).setDuration(Notification.TIME_SHORT).show();
        }
    }

    public JPanel getAnglePanel() {
        return this.angleText;
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/Statusline");
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.lonText.addMouseListener(mouseListener);
        this.latText.addMouseListener(mouseListener);
    }

    public void setHelpText(String string) {
        this.setHelpText(null, string);
    }

    public void setHelpText(Object object, final String string) {
        StatusTextHistory statusTextHistory = new StatusTextHistory(object, string);
        this.statusText.remove(statusTextHistory);
        this.statusText.add(statusTextHistory);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                MapStatus.this.helpText.setText(string);
                MapStatus.this.helpText.setToolTipText(string);
            }
        });
    }

    public void resetHelpText(Object object) {
        if (this.statusText.isEmpty()) {
            return;
        }
        StatusTextHistory statusTextHistory = new StatusTextHistory(object, null);
        if (this.statusText.get(this.statusText.size() - 1).equals(statusTextHistory)) {
            if (this.statusText.size() == 1) {
                this.setHelpText("");
            } else {
                StatusTextHistory statusTextHistory2 = this.statusText.get(this.statusText.size() - 2);
                this.setHelpText(statusTextHistory2.id, statusTextHistory2.text);
            }
        }
        this.statusText.remove(statusTextHistory);
    }

    public void setAngle(double d) {
        this.angleText.setText(d < 0.0 ? "--" : ONE_DECIMAL_PLACE.format(d) + " \u00b0");
    }

    public void setHeading(double d) {
        this.headingText.setText(d < 0.0 ? "--" : ONE_DECIMAL_PLACE.format(d) + " \u00b0");
    }

    public void setDist(double d) {
        this.distValue = d;
        this.distText.setText(d < 0.0 ? "--" : NavigatableComponent.getDistText(d, ONE_DECIMAL_PLACE, 0.01));
    }

    public void setDist(Collection<Way> collection) {
        double d = -1.0;
        int n = Math.max(1, Main.pref.getInteger("selection.max-ways-for-statusline", 250));
        if (!collection.isEmpty() && collection.size() <= n) {
            d = 0.0;
            for (Way way : collection) {
                d += way.getLength();
            }
        }
        this.setDist(d);
    }

    public void activateAnglePanel(boolean bl) {
        this.angleEnabled = bl;
        this.refreshAnglePanel();
    }

    private void refreshAnglePanel() {
        this.angleText.setBackground(this.angleEnabled ? PROP_ACTIVE_BACKGROUND_COLOR.get() : PROP_BACKGROUND_COLOR.get());
        this.angleText.setForeground(this.angleEnabled ? PROP_ACTIVE_FOREGROUND_COLOR.get() : PROP_FOREGROUND_COLOR.get());
    }

    @Override
    public void destroy() {
        NavigatableComponent.removeSoMChangeListener(this.somListener);
        Main.pref.removePreferenceChangeListener(this);
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception exception) {
                Main.error(exception);
            }
        }
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        String string = preferenceChangeEvent.getKey();
        if (string.startsWith("color.")) {
            string = string.substring("color.".length());
            if (PROP_BACKGROUND_COLOR.getKey().equals(string) || PROP_FOREGROUND_COLOR.getKey().equals(string)) {
                for (ImageLabel imageLabel : new ImageLabel[]{this.latText, this.lonText, this.headingText, this.distText, this.nameText}) {
                    imageLabel.setBackground(PROP_BACKGROUND_COLOR.get());
                    imageLabel.setForeground(PROP_FOREGROUND_COLOR.get());
                }
                this.refreshAnglePanel();
            } else if (PROP_ACTIVE_BACKGROUND_COLOR.getKey().equals(string) || PROP_ACTIVE_FOREGROUND_COLOR.getKey().equals(string)) {
                this.refreshAnglePanel();
            }
        }
    }

    public static void getColors() {
        PROP_BACKGROUND_COLOR.get();
        PROP_FOREGROUND_COLOR.get();
        PROP_ACTIVE_BACKGROUND_COLOR.get();
        PROP_ACTIVE_FOREGROUND_COLOR.get();
    }

    private class MapStatusPopupMenu
    extends JPopupMenu {
        private final JMenuItem jumpButton;
        private final Collection<JCheckBoxMenuItem> somItems;
        private final JSeparator separator;
        private final JMenuItem doNotHide;

        public MapStatusPopupMenu() {
            this.jumpButton = this.add(Main.main.menu.jumpToAct);
            this.somItems = new ArrayList<JCheckBoxMenuItem>();
            this.separator = new JSeparator();
            this.doNotHide = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Do not hide status bar", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                    Main.pref.put("statusbar.always-visible", bl);
                }
            });
            for (final String string : new TreeSet<String>(SystemOfMeasurement.ALL_SYSTEMS.keySet())) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction(string){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MapStatus.this.updateSystemOfMeasurement(string);
                    }
                });
                this.somItems.add(jCheckBoxMenuItem);
                this.add(jCheckBoxMenuItem);
            }
            this.add(this.separator);
            this.add(this.doNotHide);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    Component component = ((JPopupMenu)popupMenuEvent.getSource()).getInvoker();
                    MapStatusPopupMenu.this.jumpButton.setVisible(MapStatus.this.latText.equals(component) || MapStatus.this.lonText.equals(component));
                    String string = ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get();
                    for (JMenuItem jMenuItem : MapStatusPopupMenu.this.somItems) {
                        jMenuItem.setSelected(jMenuItem.getText().equals(string));
                        jMenuItem.setVisible(MapStatus.this.distText.equals(component));
                    }
                    MapStatusPopupMenu.this.separator.setVisible(MapStatus.this.distText.equals(component));
                    MapStatusPopupMenu.this.doNotHide.setSelected(Main.pref.getBoolean("statusbar.always-visible", true));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    static class MouseState {
        Point mousePos;
        int modifiers;

        MouseState() {
        }
    }

    private final class Collector
    implements Runnable {
        private Point oldMousePos;
        private List<JLabel> popupLabels = null;
        private Popup popup;
        private MapFrame parent;

        public Collector(MapFrame mapFrame) {
            this.parent = mapFrame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MapStatus.this.registerListeners();
            try {
                while (true) {
                    final MouseState mouseState = new MouseState();
                    Collector collector = this;
                    synchronized (collector) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Main.trace("InterruptedException in " + MapStatus.class.getSimpleName());
                        }
                        mouseState.modifiers = MapStatus.this.mouseState.modifiers;
                        mouseState.mousePos = MapStatus.this.mouseState.mousePos;
                    }
                    if (this.parent != Main.map) {
                        return;
                    }
                    if (mouseState.mousePos == null || MapStatus.this.mv.center == null) continue;
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if ((mouseState.modifiers & 0x80) != 0) {
                                    Collector.this.popupUpdateLabels();
                                    return;
                                }
                                DataSet dataSet = null;
                                boolean bl = Collector.this.oldMousePos != null && Collector.this.oldMousePos.equals(mouseState.mousePos);
                                boolean bl2 = bl && Collector.this.popup != null;
                                boolean bl3 = (mouseState.modifiers & 0x800) != 0;
                                try {
                                    dataSet = MapStatus.this.mv.getCurrentDataSet();
                                    if (dataSet != null) {
                                        if (bl2 && bl3) {
                                            dataSet.beginUpdate();
                                        } else {
                                            dataSet.getReadLock().lock();
                                        }
                                    }
                                    if (!bl) {
                                        Collector.this.statusBarElementUpdate(mouseState);
                                    }
                                    if (bl3 || bl2) {
                                        List<OsmPrimitive> list = MapStatus.this.mv.getAllNearest(mouseState.mousePos, OsmPrimitive.isUsablePredicate);
                                        JPanel jPanel = new JPanel(new GridBagLayout());
                                        JLabel jLabel = new JLabel("<html>" + I18n.tr("Middle click again to cycle through.<br>Hold CTRL to select directly from this list with the mouse.<hr>", new Object[0]) + "</html>", null, 0);
                                        jLabel.setHorizontalAlignment(2);
                                        jPanel.add((Component)jLabel, GBC.eol().insets(2, 0, 2, 0));
                                        if (bl2 && bl3) {
                                            Collector.this.popupCycleSelection(list, mouseState.modifiers);
                                        }
                                        ArrayList<JLabel> arrayList = new ArrayList<JLabel>(list.size());
                                        for (OsmPrimitive osmPrimitive : list) {
                                            JLabel jLabel2 = Collector.this.popupBuildPrimitiveLabels(osmPrimitive);
                                            arrayList.add(jLabel2);
                                            jPanel.add((Component)jLabel2, GBC.eol().fill(2).insets(2, 0, 2, 2));
                                        }
                                        Collector.this.popupShowPopup(Collector.this.popupCreatePopup(jPanel, mouseState), arrayList);
                                    } else {
                                        Collector.this.popupHidePopup();
                                    }
                                    Collector.this.oldMousePos = mouseState.mousePos;
                                }
                                catch (ConcurrentModificationException concurrentModificationException) {
                                    Main.warn(concurrentModificationException);
                                }
                                finally {
                                    if (dataSet != null) {
                                        if (bl2 && bl3) {
                                            dataSet.endUpdate();
                                        } else {
                                            dataSet.getReadLock().unlock();
                                        }
                                    }
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        Main.trace("InterruptedException in " + MapStatus.class.getSimpleName());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Main.warn(invocationTargetException);
                    }
                }
            }
            finally {
                MapStatus.this.unregisterListeners();
            }
        }

        private Popup popupCreatePopup(Component component, MouseState mouseState) {
            int n;
            Point point = MapStatus.this.mv.getLocationOnScreen();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            JScrollPane jScrollPane = GuiHelper.embedInVerticalScrollPane(component);
            jScrollPane.setBorder(BorderFactory.createRaisedBevelBorder());
            Dimension dimension2 = jScrollPane.getPreferredSize();
            int n2 = Math.min(dimension2.width, Math.min(800, dimension.width / 2 - 16));
            int n3 = Math.min(dimension2.height, dimension.height - 10);
            jScrollPane.setPreferredSize(new Dimension(n2, n3));
            int n4 = point.x + mouseState.mousePos.x + 16;
            if (n4 + n2 > dimension.width && n4 > dimension.width / 2) {
                n4 = point.x + mouseState.mousePos.x - 4 - n2;
            }
            if ((n = point.y + mouseState.mousePos.y + 16) + n3 > dimension.height - 5) {
                n = Math.max(5, dimension.height - n3 - 5);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            return popupFactory.getPopup(MapStatus.this.mv, jScrollPane, n4, n);
        }

        private void statusBarElementUpdate(MouseState mouseState) {
            OsmPrimitive osmPrimitive = MapStatus.this.mv.getNearestNodeOrWay(mouseState.mousePos, OsmPrimitive.isUsablePredicate, false);
            if (osmPrimitive != null) {
                MapStatus.this.nameText.setText(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                MapStatus.this.nameText.setText(I18n.tr("(no object)", new Object[0]));
            }
        }

        private void popupCycleSelection(Collection<OsmPrimitive> collection, int n) {
            DataSet dataSet = Main.main.getCurrentDataSet();
            OsmPrimitive osmPrimitive = null;
            OsmPrimitive osmPrimitive2 = null;
            OsmPrimitive osmPrimitive3 = null;
            for (OsmPrimitive osmPrimitive4 : collection) {
                if (osmPrimitive == null) {
                    osmPrimitive = osmPrimitive4;
                }
                if (osmPrimitive2 != null && osmPrimitive3 == null) {
                    osmPrimitive3 = osmPrimitive4;
                }
                if (osmPrimitive2 != null || !dataSet.isSelected(osmPrimitive4)) continue;
                osmPrimitive2 = osmPrimitive4;
            }
            if ((n & 0x40) == 0) {
                dataSet.clearSelection();
            }
            if (osmPrimitive2 == null) {
                dataSet.addSelected(osmPrimitive);
            } else {
                dataSet.clearSelection(osmPrimitive2);
                if (osmPrimitive3 != null) {
                    dataSet.addSelected(osmPrimitive3);
                }
            }
        }

        private void popupHidePopup() {
            this.popupLabels = null;
            if (this.popup == null) {
                return;
            }
            final Popup popup = this.popup;
            this.popup = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popup.hide();
                }
            });
        }

        private void popupShowPopup(Popup popup, List<JLabel> list) {
            final Popup popup2 = popup;
            if (this.popup != null) {
                final Popup popup3 = this.popup;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        popup2.show();
                        popup3.hide();
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        popup2.show();
                    }
                });
            }
            this.popupLabels = list;
            this.popup = popup;
        }

        private void popupUpdateLabels() {
            if (this.popup == null || this.popupLabels == null) {
                return;
            }
            for (JLabel jLabel : this.popupLabels) {
                jLabel.validate();
            }
        }

        private void popupSetLabelColors(JLabel jLabel, OsmPrimitive osmPrimitive) {
            DataSet dataSet = Main.main.getCurrentDataSet();
            if (dataSet.isSelected(osmPrimitive)) {
                jLabel.setBackground(SystemColor.textHighlight);
                jLabel.setForeground(SystemColor.textHighlightText);
            } else {
                jLabel.setBackground(SystemColor.control);
                jLabel.setForeground(SystemColor.controlText);
            }
        }

        private JLabel popupBuildPrimitiveLabels(final OsmPrimitive osmPrimitive) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance());
            if (osmPrimitive.isNewOrUndeleted() || osmPrimitive.isModified()) {
                string = "<i><b>" + string + "*</b></i>";
            }
            stringBuilder.append(string);
            boolean bl = Main.pref.getBoolean("osm-primitives.showid");
            if (!osmPrimitive.isNew() && !bl) {
                stringBuilder.append(" [id=" + osmPrimitive.getId() + "]");
            }
            if (osmPrimitive.getUser() != null) {
                stringBuilder.append(" [" + I18n.tr("User:", new Object[0]) + " " + osmPrimitive.getUser().getName() + "]");
            }
            for (String string2 : osmPrimitive.keySet()) {
                stringBuilder.append("<br>" + string2 + "=" + osmPrimitive.get(string2));
            }
            final JLabel jLabel = new JLabel("<html>" + stringBuilder.toString() + "</html>", ImageProvider.get(osmPrimitive.getDisplayType()), 0){

                @Override
                public void validate() {
                    super.validate();
                    Collector.this.popupSetLabelColors(this, osmPrimitive);
                }
            };
            jLabel.setOpaque(true);
            this.popupSetLabelColors(jLabel, osmPrimitive);
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jLabel.setVerticalTextPosition(1);
            jLabel.setHorizontalAlignment(2);
            jLabel.setCursor(Cursor.getPredefinedCursor(12));
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setBackground(SystemColor.info);
                    jLabel.setForeground(SystemColor.infoText);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    Collector.this.popupSetLabelColors(jLabel, osmPrimitive);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    dataSet.toggleSelected(osmPrimitive);
                    jLabel.validate();
                }
            });
            jLabel.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    jLabel.setBackground(SystemColor.info);
                    jLabel.setForeground(SystemColor.infoText);
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    jLabel.setBackground(SystemColor.info);
                    jLabel.setForeground(SystemColor.infoText);
                }
            });
            return jLabel;
        }
    }

    private static class StatusTextHistory {
        final Object id;
        final String text;

        public StatusTextHistory(Object object, String string) {
            this.id = object;
            this.text = string;
        }

        public boolean equals(Object object) {
            return object instanceof StatusTextHistory && ((StatusTextHistory)object).id == this.id;
        }

        public int hashCode() {
            return System.identityHashCode(this.id);
        }
    }

    public class BackgroundProgressMonitor
    implements PleaseWaitProgressMonitor.ProgressMonitorDialog {
        private String title;
        private String customText;

        private void updateText() {
            if (this.customText != null && !this.customText.isEmpty()) {
                MapStatus.this.progressBar.setToolTipText(I18n.tr("{0} ({1})", this.title, this.customText));
            } else {
                MapStatus.this.progressBar.setToolTipText(this.title);
            }
        }

        @Override
        public void setVisible(boolean bl) {
            MapStatus.this.progressBar.setVisible(bl);
        }

        @Override
        public void updateProgress(int n) {
            MapStatus.this.progressBar.setValue(n);
            MapStatus.this.progressBar.repaint();
            MapStatus.this.doLayout();
        }

        @Override
        public void setCustomText(String string) {
            this.customText = string;
            this.updateText();
        }

        @Override
        public void setCurrentAction(String string) {
            this.title = string;
            this.updateText();
        }

        @Override
        public void setIndeterminate(boolean bl) {
            UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
            MapStatus.this.progressBar.setIndeterminate(bl);
        }

        @Override
        public void appendLogMessage(String string) {
            if (string != null && !string.isEmpty()) {
                Main.info("appendLogMessage not implemented for background tasks. Message was: " + string);
            }
        }
    }
}

