/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.Map;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedNode
extends Test {
    protected static final int UNTAGGED_NODE_BLANK = 201;
    protected static final int UNTAGGED_NODE_FIXME = 202;
    protected static final int UNTAGGED_NODE_NOTE = 203;
    protected static final int UNTAGGED_NODE_CREATED_BY = 204;
    protected static final int UNTAGGED_NODE_WATCH = 205;
    protected static final int UNTAGGED_NODE_SOURCE = 206;
    protected static final int UNTAGGED_NODE_OTHER = 207;

    public UntaggedNode() {
        super(I18n.tr("Untagged and unconnected nodes", new Object[0]), I18n.tr("This test checks for untagged nodes that are not part of any way.", new Object[0]));
    }

    @Override
    public void visit(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.isUsable() || !(osmPrimitive instanceof Node)) continue;
            osmPrimitive.accept(this);
        }
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable() && !node.isTagged() && node.getReferrers().isEmpty()) {
            String string = I18n.tr("Unconnected nodes without physical tags", new Object[0]);
            if (!node.hasKeys()) {
                String string2 = I18n.marktr("No tags");
                this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr(string2, new Object[0]), string2, 201, node));
                return;
            }
            for (Map.Entry<String, String> entry : node.getKeys().entrySet()) {
                String string3;
                String string4 = entry.getKey();
                if (this.contains(entry, "fixme") || this.contains(entry, "FIXME")) {
                    string3 = I18n.marktr("Has tag containing ''fixme'' or ''FIXME''");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr(string3, new Object[0]), string3, 202, node));
                    return;
                }
                string3 = null;
                int n = 0;
                if (string4.startsWith("note") || string4.startsWith("comment") || string4.startsWith("description")) {
                    string3 = I18n.marktr("Has key ''note'' or ''comment'' or ''description''");
                    n = 203;
                } else if (string4.startsWith("created_by") || string4.startsWith("converted_by")) {
                    string3 = I18n.marktr("Has key ''created_by'' or ''converted_by''");
                    n = 204;
                } else if (string4.startsWith("watch")) {
                    string3 = I18n.marktr("Has key ''watch''");
                    n = 205;
                } else if (string4.startsWith("source")) {
                    string3 = I18n.marktr("Has key ''source''");
                    n = 206;
                }
                if (string3 == null) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr(string3, new Object[0]), string3, n, node));
                return;
            }
            this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr("Other", new Object[0]), "Other", 207, node));
        }
    }

    private boolean contains(Map.Entry<String, String> entry, String string) {
        return entry.getKey().indexOf(string) != -1 || entry.getValue().indexOf(string) != -1;
    }

    @Override
    public Command fixError(TestError testError) {
        return this.deletePrimitivesIfNeeded(testError.getPrimitives());
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedNode) {
            int n = testError.getCode();
            switch (n) {
                case 201: 
                case 204: 
                case 205: 
                case 206: {
                    return true;
                }
            }
        }
        return false;
    }
}

