/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.RegexValidator;

public class DomainValidator
extends AbstractValidator {
    private static final String DOMAIN_LABEL_REGEX = "\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*";
    private static final String TOP_LABEL_REGEX = "\\p{Alpha}{2,}";
    private static final String DOMAIN_NAME_REGEX = "^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alpha}{2,})$";
    private final boolean allowLocal;
    private static final DomainValidator DOMAIN_VALIDATOR = new DomainValidator(false);
    private static final DomainValidator DOMAIN_VALIDATOR_WITH_LOCAL = new DomainValidator(true);
    private final RegexValidator domainRegex = new RegexValidator("^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alpha}{2,})$");
    private final RegexValidator hostnameRegex = new RegexValidator("\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*");
    private static final String[] INFRASTRUCTURE_TLDS = new String[]{"arpa", "root"};
    private static final String[] GENERIC_TLDS = new String[]{"aero", "asia", "biz", "cat", "com", "coop", "info", "jobs", "mobi", "museum", "name", "net", "org", "pro", "tel", "travel", "gov", "edu", "mil", "int"};
    private static final String[] COUNTRY_CODE_TLDS = new String[]{"ac", "ad", "ae", "af", "ag", "ai", "al", "am", "an", "ao", "aq", "ar", "as", "at", "au", "aw", "ax", "az", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bm", "bn", "bo", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cu", "cv", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "er", "es", "et", "eu", "fi", "fj", "fk", "fm", "fo", "fr", "ga", "gb", "gd", "ge", "gf", "gg", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "im", "in", "io", "iq", "ir", "is", "it", "je", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "me", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "rs", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "st", "su", "sv", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tl", "tm", "tn", "to", "tp", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "uk", "um", "us", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "ye", "yt", "yu", "za", "zm", "zw"};
    private static final String[] LOCAL_TLDS = new String[]{"localhost", "localdomain"};
    private static final List<String> INFRASTRUCTURE_TLD_LIST = Arrays.asList(INFRASTRUCTURE_TLDS);
    private static final List<String> GENERIC_TLD_LIST = Arrays.asList(GENERIC_TLDS);
    private static final List<String> COUNTRY_CODE_TLD_LIST = Arrays.asList(COUNTRY_CODE_TLDS);
    private static final List<String> LOCAL_TLD_LIST = Arrays.asList(LOCAL_TLDS);

    public static DomainValidator getInstance() {
        return DOMAIN_VALIDATOR;
    }

    public static DomainValidator getInstance(boolean bl) {
        if (bl) {
            return DOMAIN_VALIDATOR_WITH_LOCAL;
        }
        return DOMAIN_VALIDATOR;
    }

    private DomainValidator(boolean bl) {
        this.allowLocal = bl;
    }

    @Override
    public boolean isValid(String string) {
        String[] stringArray = this.domainRegex.match(string);
        if (stringArray != null && stringArray.length > 0) {
            return this.isValidTld(stringArray[0]);
        }
        return this.allowLocal && this.hostnameRegex.isValid(string);
    }

    public boolean isValidTld(String string) {
        if (this.allowLocal && this.isValidLocalTld(string)) {
            return true;
        }
        return this.isValidInfrastructureTld(string) || this.isValidGenericTld(string) || this.isValidCountryCodeTld(string);
    }

    public boolean isValidInfrastructureTld(String string) {
        return INFRASTRUCTURE_TLD_LIST.contains(this.chompLeadingDot(string.toLowerCase()));
    }

    public boolean isValidGenericTld(String string) {
        return GENERIC_TLD_LIST.contains(this.chompLeadingDot(string.toLowerCase()));
    }

    public boolean isValidCountryCodeTld(String string) {
        return COUNTRY_CODE_TLD_LIST.contains(this.chompLeadingDot(string.toLowerCase()));
    }

    public boolean isValidLocalTld(String string) {
        return LOCAL_TLD_LIST.contains(this.chompLeadingDot(string.toLowerCase()));
    }

    private String chompLeadingDot(String string) {
        if (string.startsWith(".")) {
            return string.substring(1);
        }
        return string;
    }
}

