/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.RepeatImageElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.CompositeList;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class StyledMapRenderer
extends AbstractMapRenderer {
    private static final Pair<Integer, ExecutorService> THREAD_POOL = Utils.newThreadPool("mappaint.StyledMapRenderer.style_creation.numberOfThreads");
    private static Boolean IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG = null;
    private double circum;
    private MapPaintSettings paintSettings;
    private Color highlightColorTransparent;
    private static final int FLAG_NORMAL = 0;
    private static final int FLAG_DISABLED = 1;
    private static final int FLAG_MEMBER_OF_SELECTED = 2;
    private static final int FLAG_SELECTED = 4;
    private static final int FLAG_OUTERMEMBER_OF_SELECTED = 8;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);
    private Collection<WaySegment> highlightWaySegments;
    private int highlightLineWidth;
    private int highlightPointRadius;
    private int widerHighlight;
    private int highlightStep;
    private boolean useWiderHighlight;
    private boolean useStrokes;
    private boolean showNames;
    private boolean showIcons;
    private boolean isOutlineOnly;
    private Font orderFont;
    private boolean leftHandTraffic;

    public static boolean isGlyphVectorDoubleTranslationBug() {
        if (IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG != null) {
            return IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG;
        }
        String string = Main.pref.get("glyph-bug", "false");
        if ("auto".equals(string)) {
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            Font font = new Font("Dialog", 0, 12);
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, "x");
            glyphVector.setGlyphTransform(0, AffineTransform.getTranslateInstance(1000.0, 1000.0));
            Shape shape = glyphVector.getGlyphOutline(0);
            Main.trace("#10446: shape: " + shape.getBounds());
            int n = shape.getBounds().x;
            IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG = n > 1500;
            return IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG;
        }
        boolean bl = Boolean.parseBoolean(string);
        IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG = bl;
        return IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG;
    }

    public StyledMapRenderer(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl) {
        super(graphics2D, navigatableComponent, bl);
        if (navigatableComponent != null) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            this.useWiderHighlight = !(component instanceof AbstractButton) && component != navigatableComponent;
        }
    }

    private Polygon buildPolygon(Point point, int n, int n2) {
        return this.buildPolygon(point, n, n2, 0.0);
    }

    private Polygon buildPolygon(Point point, int n, int n2, double d) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < n2; ++i) {
            double d2 = Math.PI * 2 / (double)n2 * (double)i - d;
            int n3 = (int)Math.round((double)point.x + (double)n * Math.cos(d2));
            int n4 = (int)Math.round((double)point.y + (double)n * Math.sin(d2));
            polygon.addPoint(n3, n4);
        }
        return polygon;
    }

    private void displaySegments(GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, GeneralPath generalPath4, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2) {
        this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
        if (this.useStrokes) {
            this.g.setStroke(basicStroke);
        }
        this.g.draw(generalPath);
        if (!this.isInactiveMode && this.useStrokes && basicStroke2 != null) {
            this.g.setColor(color2);
            this.g.setStroke(basicStroke2);
            this.g.draw(generalPath);
        }
        if (generalPath2 != null) {
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
            this.g.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.draw(generalPath2);
        }
        if (generalPath3 != null) {
            this.g.setStroke(new BasicStroke(1.0f, basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.fill(generalPath4);
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : this.backgroundColor);
            this.g.fill(generalPath3);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    private void displayText(GlyphVector glyphVector, String string, int n, int n2, boolean bl, TextElement textElement) {
        if (this.isInactiveMode || bl) {
            this.g.setColor(this.inactiveColor);
            if (glyphVector != null) {
                this.g.drawGlyphVector(glyphVector, n, n2);
            } else {
                this.g.setFont(textElement.font);
                this.g.drawString(string, n, n2);
            }
        } else if (textElement.haloRadius != null) {
            Object object;
            this.g.setStroke(new BasicStroke(2.0f * textElement.haloRadius.floatValue(), 0, 1));
            this.g.setColor(textElement.haloColor);
            if (glyphVector == null) {
                object = this.g.getFontRenderContext();
                glyphVector = textElement.font.createGlyphVector((FontRenderContext)object, string);
            }
            object = glyphVector.getOutline(n, n2);
            this.g.draw((Shape)object);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(textElement.color);
            this.g.fill((Shape)object);
        } else {
            this.g.setColor(textElement.color);
            if (glyphVector != null) {
                this.g.drawGlyphVector(glyphVector, n, n2);
            } else {
                this.g.setFont(textElement.font);
                this.g.drawString(string, n, n2);
            }
        }
    }

    protected void drawArea(OsmPrimitive osmPrimitive, Path2D.Double double_, Color color, MapImage mapImage, TextElement textElement) {
        Shape shape = double_.createTransformedShape(this.nc.getAffineTransform());
        if (!this.isOutlineOnly) {
            if (mapImage == null) {
                if (this.isInactiveMode) {
                    this.g.setComposite(AlphaComposite.getInstance(3, 0.33f));
                }
                this.g.setColor(color);
                this.g.fill(shape);
            } else {
                TexturePaint texturePaint = new TexturePaint(mapImage.getImage(), new Rectangle(0, 0, mapImage.getWidth(), mapImage.getHeight()));
                this.g.setPaint(texturePaint);
                Float f = Utils.color_int2float(mapImage.alpha);
                if (f.floatValue() != 1.0f) {
                    this.g.setComposite(AlphaComposite.getInstance(3, f.floatValue()));
                }
                this.g.fill(shape);
                this.g.setPaintMode();
            }
        }
        this.drawAreaText(osmPrimitive, textElement, shape);
    }

    private void drawAreaText(OsmPrimitive osmPrimitive, TextElement textElement, Shape shape) {
        if (textElement != null && this.isShowNames()) {
            if (textElement.labelCompositionStrategy == null) {
                return;
            }
            String string = textElement.labelCompositionStrategy.compose(osmPrimitive);
            if (string == null) {
                return;
            }
            Rectangle rectangle = shape.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.g);
            if ((double)rectangle.width >= rectangle2D.getWidth() && (double)rectangle.height >= rectangle2D.getHeight()) {
                int n;
                int n2;
                int n3;
                int n4;
                double d;
                int n5;
                double d2 = (double)rectangle.width - rectangle2D.getWidth();
                int n6 = rectangle.x + (int)(d2 / 2.0);
                Rectangle rectangle2 = new Rectangle(n6, n5 = rectangle.y + (int)((d = (double)rectangle.height - rectangle2D.getHeight()) / 2.0), n4 = (int)rectangle2D.getWidth(), n3 = (int)rectangle2D.getHeight());
                boolean bl = shape.contains(rectangle2);
                if (!bl) {
                    int n7 = rectangle.x + (int)(d2 / 4.0);
                    n2 = rectangle.x + (int)(3.0 * d2 / 4.0);
                    n = rectangle.y + (int)(d / 4.0);
                    int n8 = rectangle.y + (int)(3.0 * d / 4.0);
                    Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n6, n, n4, n3), new Rectangle(n2, n5, n4, n3), new Rectangle(n6, n8, n4, n3), new Rectangle(n7, n5, n4, n3), new Rectangle(n7, n, n4, n3), new Rectangle(n2, n, n4, n3), new Rectangle(n2, n8, n4, n3), new Rectangle(n7, n8, n4, n3)};
                    for (int i = 0; i < rectangleArray.length && !bl; ++i) {
                        rectangle2 = rectangleArray[i];
                        bl = shape.contains(rectangle2);
                    }
                }
                if (bl) {
                    Font font = this.g.getFont();
                    n2 = (int)(rectangle2.getMinX() - rectangle2D.getMinX());
                    n = (int)(rectangle2.getMinY() - rectangle2D.getMinY());
                    this.displayText(null, string, n2, n, osmPrimitive.isDisabled(), textElement);
                    this.g.setFont(font);
                } else if (Main.isDebugEnabled()) {
                    Main.debug("Couldn't find a correct label placement for " + osmPrimitive + " / " + string);
                }
            }
        }
    }

    public void drawArea(Relation relation, Color color, MapImage mapImage, TextElement textElement) {
        Multipolygon multipolygon = MultipolygonCache.getInstance().get(this.nc, relation);
        if (!relation.isDisabled() && !multipolygon.getOuterWays().isEmpty()) {
            for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                Path2D.Double double_ = polyData.get();
                if (!this.isAreaVisible(double_)) continue;
                this.drawArea(relation, double_, polyData.selected ? this.paintSettings.getRelationSelectedColor(color.getAlpha()) : color, mapImage, textElement);
            }
        }
    }

    public void drawArea(Way way, Color color, MapImage mapImage, TextElement textElement) {
        this.drawArea(way, this.getPath(way), color, mapImage, textElement);
    }

    public void drawBoxText(Node node, BoxTextElemStyle boxTextElemStyle) {
        Object object;
        FontRenderContext fontRenderContext;
        if (!this.isShowNames() || boxTextElemStyle == null) {
            return;
        }
        Point point = this.nc.getPoint(node);
        TextElement textElement = boxTextElemStyle.text;
        String string = textElement.labelCompositionStrategy.compose(node);
        if (string == null) {
            return;
        }
        Font font = this.g.getFont();
        this.g.setFont(textElement.font);
        int n = point.x + textElement.xOffset;
        int n2 = point.y + textElement.yOffset;
        Rectangle rectangle = boxTextElemStyle.getBox();
        if (boxTextElemStyle.hAlign == BoxTextElemStyle.HorizontalTextAlignment.RIGHT) {
            n += rectangle.x + rectangle.width + 2;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = textElement.font.getStringBounds(string, fontRenderContext);
            int n3 = (int)((RectangularShape)object).getWidth();
            if (boxTextElemStyle.hAlign == BoxTextElemStyle.HorizontalTextAlignment.CENTER) {
                n -= n3 / 2;
            } else if (boxTextElemStyle.hAlign == BoxTextElemStyle.HorizontalTextAlignment.LEFT) {
                n -= -rectangle.x + 4 + n3;
            } else {
                throw new AssertionError();
            }
        }
        if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.BOTTOM) {
            n2 += rectangle.y + rectangle.height;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = textElement.font.getLineMetrics(string, fontRenderContext);
            if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.ABOVE) {
                n2 = (int)((float)n2 - ((float)(-rectangle.y) + ((LineMetrics)object).getDescent()));
            } else if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.TOP) {
                n2 = (int)((float)n2 - ((float)(-rectangle.y) - ((LineMetrics)object).getAscent()));
            } else if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.CENTER) {
                n2 = (int)((float)n2 + (((LineMetrics)object).getAscent() - ((LineMetrics)object).getDescent()) / 2.0f);
            } else if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.BELOW) {
                n2 = (int)((float)n2 + ((float)(rectangle.y + rectangle.height) + ((LineMetrics)object).getAscent() + 2.0f));
            } else {
                throw new AssertionError();
            }
        }
        this.displayText(null, string, n, n2, node.isDisabled(), textElement);
        this.g.setFont(font);
    }

    public void drawRepeatImage(Way way, Image image, float f, float f2, float f3, RepeatImageElemStyle.LineImageAlignment lineImageAlignment) {
        int n;
        int n2;
        int n3 = image.getWidth(null);
        double d = (float)n3 + f2;
        int n4 = image.getHeight(null);
        Point point = null;
        double d2 = (double)f3 % d;
        if (d2 < 0.0) {
            d2 += d;
        }
        switch (lineImageAlignment) {
            case TOP: {
                n2 = 0;
                n = n4;
                break;
            }
            case CENTER: {
                n2 = -n4 / 2;
                n = n4 + n2;
                break;
            }
            case BOTTOM: {
                n2 = -n4;
                n = 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OffsetIterator offsetIterator = new OffsetIterator(way.getNodes(), f);
        while (offsetIterator.hasNext()) {
            Point point2 = offsetIterator.next();
            if (point != null) {
                double d3 = point2.distance(point);
                double d4 = point2.x - point.x;
                double d5 = point2.y - point.y;
                double d6 = d - d2 % d;
                AffineTransform affineTransform = this.g.getTransform();
                this.g.translate(point.x, point.y);
                this.g.rotate(Math.atan2(d5, d4));
                if (d6 > (double)f2) {
                    if (d6 > d3 + (double)f2) {
                        this.g.drawImage(image, 0, n2, (int)d3, n, (int)(d - d6), 0, (int)(d - d6 + d3), n4, null);
                    } else {
                        this.g.drawImage(image, 0, n2, (int)(d6 - (double)f2), n, (int)(d - d6), 0, n3, n4, null);
                    }
                }
                while (d6 < d3) {
                    if (d6 + (double)n3 > d3) {
                        this.g.drawImage(image, (int)d6, n2, (int)d3, n, 0, 0, (int)d3 - (int)d6, n4, null);
                    } else {
                        this.g.drawImage(image, (int)d6, n2, this.nc);
                    }
                    d6 += d;
                }
                this.g.setTransform(affineTransform);
                d2 += d3;
            }
            point = point2;
        }
    }

    @Override
    public void drawNode(Node node, Color color, int n, boolean bl) {
        if (n <= 0 && !node.isHighlighted()) {
            return;
        }
        Point point = this.nc.getPoint(node);
        if (node.isHighlighted()) {
            this.drawPointHighlight(point, n);
        }
        if (n > 1) {
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            int n2 = n / 2;
            if (this.isInactiveMode || node.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            if (bl) {
                this.g.fillRect(point.x - n2 - 1, point.y - n2 - 1, n + 1, n + 1);
            } else {
                this.g.drawRect(point.x - n2 - 1, point.y - n2 - 1, n, n);
            }
        }
    }

    public void drawNodeIcon(Node node, Image image, float f, boolean bl, boolean bl2) {
        Point point = this.nc.getPoint(node);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (node.isHighlighted()) {
            this.drawPointHighlight(point, Math.max(n, n2));
        }
        if (f != 1.0f) {
            this.g.setComposite(AlphaComposite.getInstance(3, f));
        }
        this.g.drawImage(image, point.x - n / 2, point.y - n2 / 2, this.nc);
        this.g.setPaintMode();
        if (bl || bl2) {
            Color color = this.isInactiveMode || node.isDisabled() ? this.inactiveColor : (bl ? this.selectedColor : this.relationSelectedColor);
            this.g.setColor(color);
            this.g.drawRect(point.x - n / 2 - 2, point.y - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    public void drawNodeSymbol(Node node, NodeElemStyle.Symbol symbol, Color color, Color color2) {
        Point point = this.nc.getPoint(node);
        int n = symbol.size / 2;
        if (node.isHighlighted()) {
            this.drawPointHighlight(point, symbol.size);
        }
        if (color != null) {
            this.g.setColor(color);
            switch (symbol.symbol) {
                case SQUARE: {
                    this.g.fillRect(point.x - n, point.y - n, symbol.size, symbol.size);
                    break;
                }
                case CIRCLE: {
                    this.g.fillOval(point.x - n, point.y - n, symbol.size, symbol.size);
                    break;
                }
                case TRIANGLE: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (symbol.stroke != null) {
            this.g.setStroke(symbol.stroke);
            this.g.setColor(color2);
            switch (symbol.symbol) {
                case SQUARE: {
                    this.g.drawRect(point.x - n, point.y - n, symbol.size - 1, symbol.size - 1);
                    break;
                }
                case CIRCLE: {
                    this.g.drawOval(point.x - n, point.y - n, symbol.size - 1, symbol.size - 1);
                    break;
                }
                case TRIANGLE: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.g.setStroke(new BasicStroke());
        }
    }

    public void drawOrderNumber(Node node, Node node2, int n, Color color) {
        Point point = this.nc.getPoint(node);
        Point point2 = this.nc.getPoint(node2);
        this.drawOrderNumber(point, point2, n, color);
    }

    private void drawPathHighlight(GeneralPath generalPath, BasicStroke basicStroke) {
        if (generalPath == null) {
            return;
        }
        this.g.setColor(this.highlightColorTransparent);
        float f = basicStroke.getLineWidth() + (float)this.highlightLineWidth;
        if (this.useWiderHighlight) {
            f += (float)this.widerHighlight;
        }
        while (f >= basicStroke.getLineWidth()) {
            this.g.setStroke(new BasicStroke(f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit()));
            this.g.draw(generalPath);
            f -= (float)this.highlightStep;
        }
    }

    private void drawPointHighlight(Point point, int n) {
        this.g.setColor(this.highlightColorTransparent);
        int n2 = n + this.highlightPointRadius;
        if (this.useWiderHighlight) {
            n2 += this.widerHighlight;
        }
        while (n2 >= n) {
            int n3 = (int)Math.floor(n2 / 2);
            this.g.fillRoundRect(point.x - n3, point.y - n3, n2, n2, n3, n3);
            n2 -= this.highlightStep;
        }
    }

    public void drawRestriction(Image image, Point point, double d, double d2, double d3, double d4, double d5, boolean bl) {
        Image image2 = ImageProvider.createRotatedImage(image, d5, new Dimension(16, 16));
        int n = image2.getWidth(null);
        int n2 = image2.getHeight(null);
        this.g.drawImage(image2, (int)((double)point.x + d + d2) - n / 2, (int)((double)point.y + d3 + d4) - n2 / 2, this.nc);
        if (bl) {
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : this.relationSelectedColor);
            this.g.drawRect((int)((double)point.x + d + d2) - n / 2 - 2, (int)((double)point.y + d3 + d4) - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawRestriction(Relation relation, MapImage mapImage) {
        void var7_12;
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        for (RelationMember primitiveId2 : relation.getMembers()) {
            if (primitiveId2.getMember().isIncomplete()) {
                return;
            }
            if (primitiveId2.isWay()) {
                object3 = primitiveId2.getWay();
                if (((Way)object3).getNodesCount() < 2) continue;
                switch (primitiveId2.getRole()) {
                    case "from": {
                        if (object4 != null) break;
                        object4 = object3;
                        break;
                    }
                    case "to": {
                        if (object5 != null) break;
                        object5 = object3;
                        break;
                    }
                    case "via": {
                        if (object6 != null) break;
                        object6 = object3;
                    }
                }
                continue;
            }
            if (!primitiveId2.isNode()) continue;
            object3 = primitiveId2.getNode();
            if (!"via".equals(primitiveId2.getRole()) || object6 != null) continue;
            object6 = object3;
        }
        if (object4 == null || object5 == null || object6 == null) {
            return;
        }
        if (object6 instanceof Node) {
            object2 = (Node)object6;
            if (!((Way)object4).isFirstLastNode((Node)object2)) {
                return;
            }
        } else {
            Way way = (Way)object6;
            object3 = way.firstNode();
            object = way.lastNode();
            Boolean bl = false;
            String string = way.get("oneway");
            if (string != null) {
                if ("-1".equals(string)) {
                    bl = true;
                    Object object7 = object3;
                    object3 = object;
                    object = object7;
                } else {
                    bl = OsmUtils.getOsmBoolean(string);
                    if (bl == null) {
                        bl = false;
                    }
                }
            }
            if (((Way)object4).isFirstLastNode((Node)object3)) {
                object2 = object3;
            } else if (!bl.booleanValue() && ((Way)object4).isFirstLastNode((Node)object)) {
                object2 = object;
            } else {
                return;
            }
        }
        if (((Way)object4).firstNode() == object6) {
            Node node = ((Way)object4).getNode(1);
        } else {
            Node node = ((Way)object4).getNode(((Way)object4).getNodesCount() - 2);
        }
        object3 = this.nc.getPoint((Node)var7_12);
        object = this.nc.getPoint((Node)object2);
        double d = 14.0;
        double d2 = ((Point)object3).x >= ((Point)object).x ? (double)(((Point)object3).x - ((Point)object).x) : (double)(((Point)object).x - ((Point)object3).x);
        double d3 = ((Point)object3).y >= ((Point)object).y ? (double)(((Point)object3).y - ((Point)object).y) : (double)(((Point)object).y - ((Point)object3).y);
        double d4 = d2 == 0.0 ? 1.5707963267948966 : Math.atan(d3 / d2);
        double d5 = Math.toDegrees(d4);
        double d6 = d * Math.cos(d4);
        double d7 = d * Math.sin(d4);
        if (((Point)object3).x < ((Point)object).x) {
            d6 = -d6;
        }
        if (((Point)object3).y < ((Point)object).y) {
            d7 = -d7;
        }
        double d8 = 10.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            }
            d11 = 270.0 + d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            }
            d11 = 90.0 - d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            }
            d11 = 90.0 + d5;
        }
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            }
            d11 = 270.0 - d5;
        }
        this.drawRestriction(this.isInactiveMode || relation.isDisabled() ? mapImage.getDisabled() : mapImage.getImage(), (Point)object, d6, d9, d7, d10, d11, relation.isSelected());
    }

    public void drawTextOnPath(Way way, TextElement textElement) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (way == null || textElement == null) {
            return;
        }
        String string = textElement.getString(way);
        if (string == null || string.isEmpty()) {
            return;
        }
        FontMetrics fontMetrics = this.g.getFontMetrics(textElement.font);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.g);
        Rectangle rectangle = this.g.getClipBounds();
        Polygon polygon = new Polygon();
        Point point = null;
        Iterator<Node> iterator = way.getNodes().iterator();
        double d6 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Point point2 = this.nc.getPoint(node);
            polygon.addPoint(point2.x, point2.y);
            if (point != null) {
                long l = point2.x - point.x;
                long l2 = point2.y - point.y;
                d5 = Math.sqrt(l * l + l2 * l2);
                if (d5 > 2.0 * (rectangle2D.getWidth() + 4.0)) {
                    Point point3 = new Point((point.x + point2.x) / 2, (point.y + point2.y) / 2);
                    double d7 = 0.0;
                    if (rectangle != null) {
                        if (rectangle.contains(point) && rectangle.contains(point3)) {
                            d7 = 2.0;
                        } else if (rectangle.contains(point) || rectangle.contains(point3)) {
                            d7 = 1.0;
                        }
                    }
                    arrayList.add(d6);
                    arrayList2.add(d6 + d5 / 2.0);
                    arrayList3.add(d7);
                    d7 = 0.0;
                    if (rectangle != null) {
                        if (rectangle.contains(point3) && rectangle.contains(point2)) {
                            d7 = 2.0;
                        } else if (rectangle.contains(point3) || rectangle.contains(point2)) {
                            d7 = 1.0;
                        }
                    }
                    arrayList.add(d6 + d5 / 2.0);
                    arrayList2.add(d6 + d5);
                    arrayList3.add(d7);
                }
                d6 += d5;
            }
            point = point2;
        }
        if (rectangle2D.getWidth() > d6) {
            return;
        }
        if (!arrayList.isEmpty()) {
            if (way.getNodesCount() == 2) {
                arrayList3.set(0, (Double)arrayList3.get(0) + 0.5);
            }
            double d8 = Double.NaN;
            d4 = Double.NaN;
            d3 = Double.MAX_VALUE;
            d2 = -1.0;
            for (int i = 0; i < arrayList.size(); ++i) {
                double d9 = (Double)arrayList.get(i);
                double d10 = (Double)arrayList2.get(i);
                double d11 = Math.abs(0.5 * (d10 + d9) - 0.5 * d6);
                if (!((Double)arrayList3.get(i) > d2) && (!(d11 < d3) || (Double)arrayList3.get(i) != d2)) continue;
                d8 = d9;
                d4 = d10;
                d3 = d11;
                d2 = (Double)arrayList3.get(i);
            }
            double d12 = d4 - d8 - rectangle2D.getWidth();
            double d13 = Math.min(Math.max(0.2 * d12, 7.0), 0.5 * d12);
            if ((d4 + d8) / 2.0 < d6 / 2.0) {
                d5 = d4 - d13;
                d = d5 - rectangle2D.getWidth();
            } else {
                d = d8 + d13;
                d5 = d + rectangle2D.getWidth();
            }
        } else {
            d = d6 / 2.0 - rectangle2D.getWidth() / 2.0;
            d5 = d6 / 2.0 + rectangle2D.getWidth() / 2.0;
        }
        double[] dArray = this.pointAt(d /= d6, polygon, d6);
        double[] dArray2 = this.pointAt(d5 /= d6, polygon, d6);
        if (dArray == null || dArray2 == null) {
            return;
        }
        if (dArray[0] < dArray2[0] && dArray[2] < 1.5707963267948966 && dArray[2] > -1.5707963267948966) {
            d4 = 0.0;
            d3 = 1.0;
            d2 = d;
        } else {
            d4 = Math.PI;
            d3 = -1.0;
            d2 = d5;
        }
        FontRenderContext fontRenderContext = this.g.getFontRenderContext();
        GlyphVector glyphVector = textElement.font.createGlyphVector(fontRenderContext, string);
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            Rectangle2D rectangle2D2 = glyphVector.getGlyphLogicalBounds(i).getBounds2D();
            double d14 = d2 + d3 * (rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0) / d6;
            double[] dArray3 = this.pointAt(d14, polygon, d6);
            if (dArray3 == null) continue;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(dArray3[0] - rectangle2D2.getX(), dArray3[1]);
            affineTransform.rotate(dArray3[2] + d4);
            double d15 = -rectangle2D2.getY() - rectangle2D2.getHeight() / 2.0 + (double)textElement.yOffset;
            affineTransform.translate(-rectangle2D2.getWidth() / 2.0, d15);
            if (StyledMapRenderer.isGlyphVectorDoubleTranslationBug()) {
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-0.5 * affineTransform.getTranslateX(), -0.5 * affineTransform.getTranslateY());
                affineTransform2.concatenate(affineTransform);
                affineTransform = affineTransform2;
            }
            glyphVector.setGlyphTransform(i, affineTransform);
        }
        this.displayText(glyphVector, null, 0, 0, way.isDisabled(), textElement);
    }

    /*
     * WARNING - void declaration
     */
    public void drawWay(Way way, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Point point;
        Object object2;
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = bl ? new GeneralPath() : null;
        GeneralPath generalPath3 = bl3 ? new GeneralPath() : null;
        GeneralPath generalPath4 = bl3 ? new GeneralPath() : null;
        Rectangle rectangle = this.g.getClipBounds();
        if (rectangle != null) {
            rectangle.grow(100, 100);
        }
        double d = 0.0;
        Point point2 = null;
        boolean bl5 = true;
        List<Node> list = way.getNodes();
        if (list.size() < 2) {
            return;
        }
        if (!way.isHighlighted() && this.highlightWaySegments != null) {
            object2 = null;
            for (WaySegment object3 : this.highlightWaySegments) {
                if (object3.way != way || (float)object3.lowerIndex < f) continue;
                if (object2 == null) {
                    object2 = new GeneralPath();
                }
                point = this.nc.getPoint(object3.getFirstNode());
                object = this.nc.getPoint(object3.getSecondNode());
                ((Path2D.Float)object2).moveTo(point.x, point.y);
                ((Path2D.Float)object2).lineTo(((Point)object).x, ((Point)object).y);
            }
            this.drawPathHighlight((GeneralPath)object2, basicStroke);
        }
        object2 = new OffsetIterator(list, f);
        while (object2.hasNext()) {
            Point point3;
            Point point32 = (Point)object2.next();
            if (point2 != null && ((LineClip)(object = new LineClip(point3 = point2, point = point32, rectangle))).execute()) {
                double d2;
                double d3;
                void var23_26;
                double d4;
                if (!point3.equals(((LineClip)object).getP1())) {
                    Point point4 = ((LineClip)object).getP1();
                    generalPath.moveTo(point4.x, point4.y);
                } else if (bl5) {
                    bl5 = false;
                    generalPath.moveTo(point3.x, point3.y);
                }
                point = ((LineClip)object).getP2();
                generalPath.lineTo(point.x, point.y);
                if ((bl2 ? !object2.hasNext() : bl) && (d4 = var23_26.distance(point)) != 0.0) {
                    d3 = (10.0 + (double)basicStroke.getLineWidth()) / d4;
                    d2 = d3 * (double)(var23_26.x - point.x);
                    double d5 = d3 * (double)(var23_26.y - point.y);
                    generalPath2.moveTo((double)point.x + cosPHI * d2 - sinPHI * d5, (double)point.y + sinPHI * d2 + cosPHI * d5);
                    generalPath2.lineTo(point.x, point.y);
                    generalPath2.lineTo((double)point.x + cosPHI * d2 + sinPHI * d5, (double)point.y - sinPHI * d2 + cosPHI * d5);
                }
                if (bl3) {
                    d4 = var23_26.distance(point);
                    if (d4 != 0.0) {
                        d3 = (double)(point.x - var23_26.x) / d4;
                        d2 = (double)(point.y - var23_26.y) / d4;
                        for (double d6 = 60.0 - d % 60.0; d6 < d4; d6 += 60.0) {
                            for (int i = 0; i < 2; ++i) {
                                float f2 = i == 0 ? 3.0f : 2.0f;
                                GeneralPath generalPath5 = i == 0 ? generalPath4 : generalPath3;
                                double d7 = (double)((float)(-(bl4 ? -1 : 1)) * f2) * (1.0 + sinPHI) / (sinPHI * cosPHI);
                                double d8 = d3 * d7;
                                double d9 = d2 * d7;
                                double d10 = (double)var23_26.x + d3 * (d6 + (double)(bl4 ? -1 : 1) * ((double)f2 / sinPHI));
                                double d11 = (double)var23_26.y + d2 * (d6 + (double)(bl4 ? -1 : 1) * ((double)f2 / sinPHI));
                                generalPath5.moveTo(d10, d11);
                                generalPath5.lineTo(d10 + cosPHI * d8 - sinPHI * d9, d11 + sinPHI * d8 + cosPHI * d9);
                                generalPath5.lineTo(d10 + cosPHI * d8 + sinPHI * d9, d11 - sinPHI * d8 + cosPHI * d9);
                                generalPath5.lineTo(d10, d11);
                            }
                        }
                    }
                    d += d4;
                }
            }
            point2 = point32;
        }
        if (way.isHighlighted()) {
            this.drawPathHighlight(generalPath, basicStroke);
        }
        this.displaySegments(generalPath, generalPath2, generalPath3, generalPath4, color, basicStroke, basicStroke2, color2);
    }

    public double getCircum() {
        return this.circum;
    }

    @Override
    public void getColors() {
        super.getColors();
        this.highlightColorTransparent = new Color(this.highlightColor.getRed(), this.highlightColor.getGreen(), this.highlightColor.getBlue(), 100);
        this.backgroundColor = PaintColors.getBackgroundColor();
    }

    @Override
    public void getSettings(boolean bl) {
        super.getSettings(bl);
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.circum = this.nc.getDist100Pixel();
        this.leftHandTraffic = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.useStrokes = (double)this.paintSettings.getUseStrokesDistance() > this.circum;
        this.showNames = (double)this.paintSettings.getShowNamesDistance() > this.circum;
        this.showIcons = (double)this.paintSettings.getShowIconsDistance() > this.circum;
        this.isOutlineOnly = this.paintSettings.isOutlineOnly();
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Droid Sans"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", true) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.highlightLineWidth = Main.pref.getInteger("mappaint.highlight.width", 4);
        this.highlightPointRadius = Main.pref.getInteger("mappaint.highlight.radius", 7);
        this.widerHighlight = Main.pref.getInteger("mappaint.highlight.bigger-increment", 5);
        this.highlightStep = Main.pref.getInteger("mappaint.highlight.step", 4);
    }

    private Path2D.Double getPath(Way way) {
        Path2D.Double double_ = new Path2D.Double();
        boolean bl = true;
        for (Node node : way.getNodes()) {
            EastNorth eastNorth = node.getEastNorth();
            if (eastNorth == null) continue;
            if (bl) {
                double_.moveTo(eastNorth.getX(), eastNorth.getY());
                bl = false;
                continue;
            }
            double_.lineTo(eastNorth.getX(), eastNorth.getY());
        }
        return double_;
    }

    private boolean isAreaVisible(Path2D.Double double_) {
        Rectangle2D rectangle2D = double_.getBounds2D();
        if (rectangle2D.isEmpty()) {
            return false;
        }
        Point2D point2D = this.nc.getPoint2D(new EastNorth(rectangle2D.getX(), rectangle2D.getY()));
        if (point2D.getX() > (double)this.nc.getWidth()) {
            return false;
        }
        if (point2D.getY() < 0.0) {
            return false;
        }
        point2D = this.nc.getPoint2D(new EastNorth(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()));
        if (point2D.getX() < 0.0) {
            return false;
        }
        return !(point2D.getY() > (double)this.nc.getHeight());
    }

    public boolean isInactiveMode() {
        return this.isInactiveMode;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    private double[] pointAt(double d, Polygon polygon, double d2) {
        double d3 = d * d2;
        double d4 = 0.0;
        for (int i = 1; i < polygon.npoints; ++i) {
            long l = polygon.xpoints[i] - polygon.xpoints[i - 1];
            long l2 = polygon.ypoints[i] - polygon.ypoints[i - 1];
            double d5 = Math.sqrt(l * l + l2 * l2);
            if (d3 > d4 + d5) {
                d4 += d5;
                continue;
            }
            return new double[]{(double)polygon.xpoints[i - 1] + (d3 - d4) / d5 * (double)l, (double)polygon.ypoints[i - 1] + (d3 - d4) / d5 * (double)l2, Math.atan2(l2, l)};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = bounds.toBBox();
        this.getSettings(bl);
        dataSet.getReadLock().lock();
        try {
            this.highlightWaySegments = dataSet.getHighlightedWaySegments();
            long l = 0L;
            long l2 = 0L;
            if (Main.isTraceEnabled()) {
                l = System.currentTimeMillis();
                System.err.print("BENCHMARK: rendering ");
                Main.debug(null);
            }
            List<Node> list = dataSet.searchNodes(bBox);
            List<Way> list2 = dataSet.searchWays(bBox);
            List<Relation> list3 = dataSet.searchRelations(bBox);
            ArrayList<StyleRecord> arrayList = new ArrayList<StyleRecord>(list.size() + list2.size() + list3.size());
            ConcurrentTasksHelper concurrentTasksHelper = new ConcurrentTasksHelper(arrayList, dataSet);
            concurrentTasksHelper.process(list3);
            concurrentTasksHelper.process(new CompositeList<Way>(list, list2));
            if (Main.isTraceEnabled()) {
                l2 = System.currentTimeMillis();
                System.err.print("phase 1 (calculate styles): " + (l2 - l) + " ms");
            }
            Collections.sort(arrayList);
            for (StyleRecord styleRecord : arrayList) {
                styleRecord.style.paintPrimitive(styleRecord.osm, this.paintSettings, this, (styleRecord.flags & 4) != 0, (styleRecord.flags & 8) != 0, (styleRecord.flags & 2) != 0);
            }
            if (Main.isTraceEnabled()) {
                long l3 = System.currentTimeMillis();
                System.err.println("; phase 2 (draw): " + (l3 - l2) + " ms; total: " + (l3 - l) + " ms" + " (scale: " + this.circum + " zoom level: " + Selector.GeneralSelector.scale2level(this.circum) + ")");
            }
            this.drawVirtualNodes(dataSet, bBox);
        }
        finally {
            dataSet.getReadLock().unlock();
        }
    }

    private class ConcurrentTasksHelper {
        private final List<StyleRecord> allStyleElems;
        private final DataSet data;

        public ConcurrentTasksHelper(List<StyleRecord> list, DataSet dataSet) {
            this.allStyleElems = list;
            this.data = dataSet;
        }

        void process(List<? extends OsmPrimitive> list) {
            ArrayList<ComputeStyleListWorker> arrayList = new ArrayList<ComputeStyleListWorker>();
            int n = Math.max(100, list.size() / (Integer)THREAD_POOL.a / 3);
            int n2 = (list.size() + n - 1) / n;
            boolean bl = (Integer)THREAD_POOL.a == 1 || n2 == 1;
            for (int i = 0; i < n2; ++i) {
                int n3 = i * n;
                int n4 = Math.min((i + 1) * n, list.size());
                ArrayList<StyleRecord> arrayList2 = bl ? this.allStyleElems : new ArrayList<StyleRecord>(n4 - n3);
                arrayList.add(new ComputeStyleListWorker(list, n3, n4, arrayList2, this.data));
            }
            if (bl) {
                try {
                    for (ComputeStyleListWorker computeStyleListWorker : arrayList) {
                        computeStyleListWorker.call();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (!arrayList.isEmpty()) {
                try {
                    for (Future future : ((ExecutorService)THREAD_POOL.b).invokeAll(arrayList)) {
                        this.allStyleElems.addAll((Collection)future.get());
                    }
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    private class ComputeStyleListWorker
    implements Callable<List<StyleRecord>>,
    Visitor {
        private final List<? extends OsmPrimitive> input;
        private final int from;
        private final int to;
        private final List<StyleRecord> output;
        private final DataSet data;
        private final ElemStyles styles = MapPaintStyles.getStyles();
        private final boolean drawArea = StyledMapRenderer.access$000(StyledMapRenderer.this) <= (double)Main.pref.getInteger("mappaint.fillareas", 10000000);
        private final boolean drawMultipolygon = this.drawArea && Main.pref.getBoolean("mappaint.multipolygon", true);
        private final boolean drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);

        public ComputeStyleListWorker(List<? extends OsmPrimitive> list, int n, int n2, List<StyleRecord> list2, DataSet dataSet) {
            this.input = list;
            this.from = n;
            this.to = n2;
            this.output = list2;
            this.data = dataSet;
            this.styles.setDrawMultipolygon(this.drawMultipolygon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StyleRecord> call() throws Exception {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                for (int i = this.from; i < this.to; ++i) {
                    OsmPrimitive osmPrimitive = this.input.get(i);
                    if (!osmPrimitive.isDrawable()) continue;
                    osmPrimitive.accept(this);
                }
                List<StyleRecord> list = this.output;
                return list;
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
        }

        @Override
        public void visit(Node node) {
            if (node.isDisabled()) {
                this.add(node, 1);
            } else if (node.isSelected()) {
                this.add(node, 4);
            } else if (node.isMemberOfSelected()) {
                this.add(node, 2);
            } else {
                this.add(node, 0);
            }
        }

        @Override
        public void visit(Way way) {
            if (way.isDisabled()) {
                this.add(way, 1);
            } else if (way.isSelected()) {
                this.add(way, 4);
            } else if (way.isOuterMemberOfSelected()) {
                this.add(way, 8);
            } else if (way.isMemberOfSelected()) {
                this.add(way, 2);
            } else {
                this.add(way, 0);
            }
        }

        @Override
        public void visit(Relation relation) {
            if (relation.isDisabled()) {
                this.add(relation, 1);
            } else if (relation.isSelected()) {
                this.add(relation, 4);
            } else if (relation.isOuterMemberOfSelected()) {
                this.add(relation, 8);
            } else if (relation.isMemberOfSelected()) {
                this.add(relation, 2);
            } else {
                this.add(relation, 0);
            }
        }

        @Override
        public void visit(Changeset changeset) {
            throw new UnsupportedOperationException();
        }

        public void add(Node node, int n) {
            StyleCache.StyleList styleList = this.styles.get(node, StyledMapRenderer.this.circum, StyledMapRenderer.this.nc);
            for (ElemStyle elemStyle : styleList) {
                this.output.add(new StyleRecord(elemStyle, node, n));
            }
        }

        public void add(Relation relation, int n) {
            StyleCache.StyleList styleList = this.styles.get(relation, StyledMapRenderer.this.circum, StyledMapRenderer.this.nc);
            for (ElemStyle elemStyle : styleList) {
                if (this.drawMultipolygon && this.drawArea && elemStyle instanceof AreaElemStyle && (n & 1) == 0) {
                    this.output.add(new StyleRecord(elemStyle, relation, n));
                    continue;
                }
                if (!this.drawRestriction || !(elemStyle instanceof NodeElemStyle)) continue;
                this.output.add(new StyleRecord(elemStyle, relation, n));
            }
        }

        public void add(Way way, int n) {
            StyleCache.StyleList styleList = this.styles.get(way, StyledMapRenderer.this.circum, StyledMapRenderer.this.nc);
            for (ElemStyle elemStyle : styleList) {
                if ((!this.drawArea || (n & 1) != 0) && elemStyle instanceof AreaElemStyle) continue;
                this.output.add(new StyleRecord(elemStyle, way, n));
            }
        }
    }

    private static class StyleRecord
    implements Comparable<StyleRecord> {
        final ElemStyle style;
        final OsmPrimitive osm;
        final int flags;

        public StyleRecord(ElemStyle elemStyle, OsmPrimitive osmPrimitive, int n) {
            this.style = elemStyle;
            this.osm = osmPrimitive;
            this.flags = n;
        }

        @Override
        public int compareTo(StyleRecord styleRecord) {
            if ((this.flags & 1) != 0 && (styleRecord.flags & 1) == 0) {
                return -1;
            }
            if ((this.flags & 1) == 0 && (styleRecord.flags & 1) != 0) {
                return 1;
            }
            int n = Float.compare(this.style.major_z_index, styleRecord.style.major_z_index);
            if (n != 0) {
                return n;
            }
            if (this.flags > styleRecord.flags) {
                return 1;
            }
            if (this.flags < styleRecord.flags) {
                return -1;
            }
            int n2 = Float.compare(this.style.z_index, styleRecord.style.z_index);
            if (n2 != 0) {
                return n2;
            }
            if (this.style == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && styleRecord.style != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return 1;
            }
            if (this.style != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && styleRecord.style == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return -1;
            }
            long l = this.osm.getUniqueId() - styleRecord.osm.getUniqueId();
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return Float.compare(this.style.object_z_index, styleRecord.style.object_z_index);
        }
    }

    private class OffsetIterator
    implements Iterator<Point> {
        private List<Node> nodes;
        private float offset;
        private int idx;
        private Point prev = null;
        private int x_prev0;
        private int y_prev0;

        public OffsetIterator(List<Node> list, float f) {
            this.nodes = list;
            this.offset = f;
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.nodes.size();
        }

        @Override
        public Point next() {
            if (Math.abs(this.offset) < 0.1f) {
                return StyledMapRenderer.this.nc.getPoint(this.nodes.get(this.idx++));
            }
            Point point = StyledMapRenderer.this.nc.getPoint(this.nodes.get(this.idx));
            if (this.idx == this.nodes.size() - 1) {
                ++this.idx;
                if (this.prev != null) {
                    return new Point(this.x_prev0 + point.x - this.prev.x, this.y_prev0 + point.y - this.prev.y);
                }
                return point;
            }
            Point point2 = StyledMapRenderer.this.nc.getPoint(this.nodes.get(this.idx + 1));
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            double d = Math.sqrt(n * n + n2 * n2);
            if (d == 0.0) {
                d = 1.0;
            }
            int n3 = point.x + (int)Math.round((double)(this.offset * (float)n2) / d);
            int n4 = point.y - (int)Math.round((double)(this.offset * (float)n) / d);
            if (this.idx == 0) {
                ++this.idx;
                this.prev = point;
                this.x_prev0 = n3;
                this.y_prev0 = n4;
                return new Point(n3, n4);
            }
            int n5 = point.y - this.prev.y;
            int n6 = point.x - this.prev.x;
            int n7 = n * n5 - n6 * n2;
            if (n7 == 0) {
                ++this.idx;
                this.prev = point;
                this.x_prev0 = n3;
                this.y_prev0 = n4;
                return new Point(n3, n4);
            }
            int n8 = n * (n4 - this.y_prev0) - n2 * (n3 - this.x_prev0);
            int n9 = this.x_prev0 + Math.round((float)n8 * (float)n6 / (float)n7);
            int n10 = this.y_prev0 + Math.round((float)n8 * (float)n5 / (float)n7);
            ++this.idx;
            this.prev = point;
            this.x_prev0 = n3;
            this.y_prev0 = n4;
            return new Point(n9, n10);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

