/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;

public class NoteData {
    private long newNoteId = -1L;
    private final List<Note> noteList;
    private Note selectedNote = null;

    public NoteData() {
        this.noteList = new ArrayList<Note>();
    }

    public NoteData(List<Note> list) {
        this.noteList = list;
    }

    public List<Note> getNotes() {
        return this.noteList;
    }

    public Note getSelectedNote() {
        return this.selectedNote;
    }

    public void setSelectedNote(Note note) {
        this.selectedNote = note;
        Main.map.noteDialog.selectionChanged();
        Main.map.mapView.repaint();
    }

    public void addNotes(List<Note> list) {
        for (Note note : list) {
            if (!this.noteList.contains(note)) {
                this.noteList.add(note);
            }
            if (note.getId() > this.newNoteId) continue;
            this.newNoteId = note.getId() - 1L;
        }
        this.dataUpdated();
        Main.debug("notes in current set: " + this.noteList.size());
    }

    public void createNote(LatLon latLon, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Comment can not be blank when creating a note");
        }
        Note note = new Note(latLon);
        note.setCreatedAt(new Date());
        note.setState(Note.State.open);
        note.setId(this.newNoteId--);
        NoteComment noteComment = new NoteComment(new Date(), this.getCurrentUser(), string, NoteComment.Action.opened, true);
        note.addComment(noteComment);
        Main.debug("Created note {0} with comment: {1}", note.getId(), string);
        this.noteList.add(note);
        this.dataUpdated();
    }

    public void addCommentToNote(Note note, String string) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to modify must be in layer");
        }
        if (note.getState() == Note.State.closed) {
            throw new IllegalStateException("Cannot add a comment to a closed note");
        }
        Main.debug("Adding comment to note {0}: {1}", note.getId(), string);
        NoteComment noteComment = new NoteComment(new Date(), this.getCurrentUser(), string, NoteComment.Action.commented, true);
        note.addComment(noteComment);
        this.dataUpdated();
    }

    public void closeNote(Note note, String string) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to close must be in layer");
        }
        if (note.getState() != Note.State.open) {
            throw new IllegalStateException("Cannot close a note that isn't open");
        }
        Main.debug("closing note {0} with comment: {1}", note.getId(), string);
        NoteComment noteComment = new NoteComment(new Date(), this.getCurrentUser(), string, NoteComment.Action.closed, true);
        note.addComment(noteComment);
        note.setState(Note.State.closed);
        note.setClosedAt(new Date());
        this.dataUpdated();
    }

    public void reOpenNote(Note note, String string) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to reopen must be in layer");
        }
        if (note.getState() != Note.State.closed) {
            throw new IllegalStateException("Cannot reopen a note that isn't closed");
        }
        Main.debug("reopening note {0} with comment: {1}", note.getId(), string);
        NoteComment noteComment = new NoteComment(new Date(), this.getCurrentUser(), string, NoteComment.Action.reopened, true);
        note.addComment(noteComment);
        note.setState(Note.State.open);
        this.dataUpdated();
    }

    private void dataUpdated() {
        Main.map.noteDialog.setNoteList(this.noteList);
        Main.map.mapView.repaint();
    }

    private User getCurrentUser() {
        JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        return User.createOsmUser(josmUserIdentityManager.getUserId(), josmUserIdentityManager.getUserName());
    }
}

