/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class SystemOfMeasurement {
    public static final SystemOfMeasurement METRIC = new SystemOfMeasurement(1.0, "m", 1000.0, "km", 10000.0, "ha");
    public static final SystemOfMeasurement CHINESE = new SystemOfMeasurement(0.3333333333333333, "\u5e02\u5c3a", 500.0, "\u5e02\u91cc");
    public static final SystemOfMeasurement IMPERIAL = new SystemOfMeasurement(0.3048, "ft", 1609.344, "mi", 4046.86, "ac");
    public static final SystemOfMeasurement NAUTICAL_MILE = new SystemOfMeasurement(185.2, "kbl", 1852.0, "NM");
    public static final Map<String, SystemOfMeasurement> ALL_SYSTEMS = new LinkedHashMap<String, SystemOfMeasurement>();
    public final double aValue;
    public final double bValue;
    public final String aName;
    public final String bName;
    public final double areaCustomValue;
    public final String areaCustomName;

    public SystemOfMeasurement(double d, String string, double d2, String string2) {
        this(d, string, d2, string2, -1.0, null);
    }

    public SystemOfMeasurement(double d, String string, double d2, String string2, double d3, String string3) {
        this.aValue = d;
        this.aName = string;
        this.bValue = d2;
        this.bName = string2;
        this.areaCustomValue = d3;
        this.areaCustomName = string3;
    }

    public String getDistText(double d) {
        return this.getDistText(d, null, 0.01);
    }

    public String getDistText(double d, NumberFormat numberFormat, double d2) {
        double d3 = d / this.aValue;
        if (!Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false) && d3 > this.bValue / this.aValue) {
            return SystemOfMeasurement.formatText(d / this.bValue, this.bName, numberFormat);
        }
        if (d3 < d2) {
            return "< " + SystemOfMeasurement.formatText(d2, this.aName, numberFormat);
        }
        return SystemOfMeasurement.formatText(d3, this.aName, numberFormat);
    }

    public String getAreaText(double d) {
        return this.getAreaText(d, null, 0.01);
    }

    public String getAreaText(double d, NumberFormat numberFormat, double d2) {
        double d3 = d / (this.aValue * this.aValue);
        boolean bl = Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false);
        boolean bl2 = Main.pref.getBoolean("system_of_measurement.use_only_custom_area_unit", false);
        if (!bl && this.areaCustomValue > 0.0 && d3 > this.areaCustomValue / (this.aValue * this.aValue) && d3 < this.bValue * this.bValue / (this.aValue * this.aValue) || bl2) {
            return SystemOfMeasurement.formatText(d / this.areaCustomValue, this.areaCustomName, numberFormat);
        }
        if (!bl && d3 >= this.bValue * this.bValue / (this.aValue * this.aValue)) {
            return SystemOfMeasurement.formatText(d / (this.bValue * this.bValue), this.bName + "\u00b2", numberFormat);
        }
        if (d3 < d2) {
            return "< " + SystemOfMeasurement.formatText(d2, this.aName + "\u00b2", numberFormat);
        }
        return SystemOfMeasurement.formatText(d3, this.aName + "\u00b2", numberFormat);
    }

    private static String formatText(double d, String string, NumberFormat numberFormat) {
        if (numberFormat != null) {
            return numberFormat.format(d) + " " + string;
        }
        return String.format(Locale.US, "%." + (d < 9.999999 ? 2 : 1) + "f %s", d, string);
    }

    static {
        ALL_SYSTEMS.put(I18n.marktr("Metric"), METRIC);
        ALL_SYSTEMS.put(I18n.marktr("Chinese"), CHINESE);
        ALL_SYSTEMS.put(I18n.marktr("Imperial"), IMPERIAL);
        ALL_SYSTEMS.put(I18n.marktr("Nautical Mile"), NAUTICAL_MILE);
    }
}

