/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import org.openstreetmap.josm.data.coor.EastNorth;

public class ProjectionBounds {
    public double minEast;
    public double minNorth;
    public double maxEast;
    public double maxNorth;

    public ProjectionBounds(EastNorth eastNorth, EastNorth eastNorth2) {
        this.minEast = eastNorth.east();
        this.minNorth = eastNorth.north();
        this.maxEast = eastNorth2.east();
        this.maxNorth = eastNorth2.north();
    }

    public ProjectionBounds(EastNorth eastNorth) {
        this.minEast = this.maxEast = eastNorth.east();
        this.minNorth = this.maxNorth = eastNorth.north();
    }

    public ProjectionBounds(EastNorth eastNorth, double d, double d2) {
        this.minEast = eastNorth.east() - d / 2.0;
        this.minNorth = eastNorth.north() - d2 / 2.0;
        this.maxEast = eastNorth.east() + d / 2.0;
        this.maxNorth = eastNorth.north() + d2 / 2.0;
    }

    public ProjectionBounds(double d, double d2, double d3, double d4) {
        this.minEast = d;
        this.minNorth = d2;
        this.maxEast = d3;
        this.maxNorth = d4;
    }

    public void extend(EastNorth eastNorth) {
        if (eastNorth.east() < this.minEast) {
            this.minEast = eastNorth.east();
        }
        if (eastNorth.east() > this.maxEast) {
            this.maxEast = eastNorth.east();
        }
        if (eastNorth.north() < this.minNorth) {
            this.minNorth = eastNorth.north();
        }
        if (eastNorth.north() > this.maxNorth) {
            this.maxNorth = eastNorth.north();
        }
    }

    public EastNorth getCenter() {
        return new EastNorth((this.minEast + this.maxEast) / 2.0, (this.minNorth + this.maxNorth) / 2.0);
    }

    public String toString() {
        return "ProjectionBounds[" + this.minEast + "," + this.minNorth + "," + this.maxEast + "," + this.maxNorth + "]";
    }

    public boolean intersects(ProjectionBounds projectionBounds) {
        return projectionBounds.maxEast >= this.minEast && projectionBounds.maxNorth >= this.minNorth && projectionBounds.minEast <= this.maxEast && projectionBounds.minNorth <= this.maxNorth;
    }

    public EastNorth getMin() {
        return new EastNorth(this.minEast, this.minNorth);
    }

    public EastNorth getMax() {
        return new EastNorth(this.maxEast, this.maxNorth);
    }
}

