/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.PushbackReader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.date.DateUtils;

public class SearchCompiler {
    private boolean caseSensitive = false;
    private boolean regexSearch = false;
    private static String rxErrorMsg = I18n.marktr("The regex \"{0}\" had a parse error at offset {1}, full error:\n\n{2}");
    private static String rxErrorMsgNoPos = I18n.marktr("The regex \"{0}\" had a parse error, full error:\n\n{1}");
    private PushbackTokenizer tokenizer;
    private static Map<String, SimpleMatchFactory> simpleMatchFactoryMap = new HashMap<String, SimpleMatchFactory>();
    private static Map<String, UnaryMatchFactory> unaryMatchFactoryMap = new HashMap<String, UnaryMatchFactory>();
    private static Map<String, BinaryMatchFactory> binaryMatchFactoryMap = new HashMap<String, BinaryMatchFactory>();

    public SearchCompiler(boolean bl, boolean bl2, PushbackTokenizer pushbackTokenizer) {
        this.caseSensitive = bl;
        this.regexSearch = bl2;
        this.tokenizer = pushbackTokenizer;
        if (simpleMatchFactoryMap.isEmpty()) {
            SearchCompiler.addMatchFactory(new CoreSimpleMatchFactory());
        }
        if (unaryMatchFactoryMap.isEmpty()) {
            SearchCompiler.addMatchFactory(new CoreUnaryMatchFactory());
        }
    }

    public static void addMatchFactory(MatchFactory matchFactory) {
        for (String string : matchFactory.getKeywords()) {
            if (matchFactory instanceof SimpleMatchFactory) {
                simpleMatchFactoryMap.put(string, (SimpleMatchFactory)matchFactory);
                continue;
            }
            if (matchFactory instanceof UnaryMatchFactory) {
                unaryMatchFactoryMap.put(string, (UnaryMatchFactory)matchFactory);
                continue;
            }
            if (matchFactory instanceof BinaryMatchFactory) {
                binaryMatchFactoryMap.put(string, (BinaryMatchFactory)matchFactory);
                continue;
            }
            throw new AssertionError((Object)"Unknown match factory");
        }
    }

    public static Match compile(String string, boolean bl, boolean bl2) throws ParseError {
        return new SearchCompiler(bl, bl2, new PushbackTokenizer(new PushbackReader(new StringReader(string)))).parse();
    }

    public Match parse() throws ParseError {
        Match match = this.parseExpression();
        if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.EOF)) {
            throw new ParseError(I18n.tr("Unexpected token: {0}", new Object[]{this.tokenizer.nextToken()}));
        }
        if (match == null) {
            return new Always();
        }
        return match;
    }

    private Match parseExpression() throws ParseError {
        Match match = this.parseFactor();
        if (match == null) {
            return null;
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.OR)) {
            return new Or(match, this.parseExpression(I18n.tr("Missing parameter for OR", new Object[0])));
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.XOR)) {
            return new Xor(match, this.parseExpression(I18n.tr("Missing parameter for XOR", new Object[0])));
        }
        Match match2 = this.parseExpression();
        if (match2 == null) {
            return match;
        }
        return new And(match, match2);
    }

    private Match parseExpression(String string) throws ParseError {
        Match match = this.parseExpression();
        if (match == null) {
            throw new ParseError(string);
        }
        return match;
    }

    private Match parseFactor() throws ParseError {
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.LEFT_PARENT)) {
            Match match = this.parseExpression();
            if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.RIGHT_PARENT)) {
                throw new ParseError(PushbackTokenizer.Token.RIGHT_PARENT, this.tokenizer.nextToken());
            }
            return match;
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.NOT)) {
            return new Not(this.parseFactor(I18n.tr("Missing operator for NOT", new Object[0])));
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.KEY)) {
            String string = this.tokenizer.getText();
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.EQUALS)) {
                return new ExactKeyValue(this.regexSearch, string, this.tokenizer.readTextOrNumber());
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.LESS_THAN)) {
                return new ValueComparison(string, this.tokenizer.readTextOrNumber(), -1);
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.GREATER_THAN)) {
                return new ValueComparison(string, this.tokenizer.readTextOrNumber(), 1);
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.COLON)) {
                SimpleMatchFactory simpleMatchFactory = simpleMatchFactoryMap.get(string);
                if (simpleMatchFactory != null) {
                    return simpleMatchFactory.get(string, this.tokenizer);
                }
                UnaryMatchFactory unaryMatchFactory = unaryMatchFactoryMap.get(string);
                if (unaryMatchFactory != null) {
                    return unaryMatchFactory.get(string, this.parseFactor(), this.tokenizer);
                }
                return this.parseKV(string, this.tokenizer.readTextOrNumber());
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.QUESTION_MARK)) {
                return new BooleanMatch(string, false);
            }
            SimpleMatchFactory simpleMatchFactory = simpleMatchFactoryMap.get(string);
            if (simpleMatchFactory != null) {
                return simpleMatchFactory.get(string, null);
            }
            UnaryMatchFactory unaryMatchFactory = unaryMatchFactoryMap.get(string);
            if (unaryMatchFactory != null) {
                return unaryMatchFactory.get(string, this.parseFactor(), null);
            }
            return new Any(string, this.regexSearch, this.caseSensitive);
        }
        return null;
    }

    private Match parseFactor(String string) throws ParseError {
        Match match = this.parseFactor();
        if (match == null) {
            throw new ParseError(string);
        }
        return match;
    }

    private Match parseKV(String string, String string2) throws ParseError {
        if (string2 == null) {
            string2 = "";
        }
        switch (string) {
            case "type": {
                return new ExactType(string2);
            }
            case "user": {
                return new UserMatch(string2);
            }
            case "role": {
                return new RoleMatch(string2);
            }
        }
        return new KeyValue(string, string2, this.regexSearch, this.caseSensitive);
    }

    private static int regexFlags(boolean bl) {
        int n = 0;
        n |= 0x80;
        n |= 0x20;
        if (!bl) {
            n |= 0x42;
        }
        return n;
    }

    public static class ParseError
    extends Exception {
        public ParseError(String string) {
            super(string);
        }

        public ParseError(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ParseError(PushbackTokenizer.Token token, PushbackTokenizer.Token token2) {
            this(I18n.tr("Unexpected token. Expected {0}, found {1}", new Object[]{token, token2}));
        }
    }

    private static class InView
    extends InArea {
        public InView(boolean bl) {
            super(bl);
        }

        @Override
        protected Bounds getBounds() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.map.mapView.getRealBounds();
        }
    }

    private static class InDataSourceArea
    extends InArea {
        public InDataSourceArea(boolean bl) {
            super(bl);
        }

        @Override
        protected Bounds getBounds() {
            return new Bounds(Main.main.getCurrentDataSet().getDataSourceArea().getBounds2D());
        }
    }

    private static abstract class InArea
    extends Match {
        protected final boolean all;

        protected abstract Bounds getBounds();

        public InArea(boolean bl) {
            this.all = bl;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.isUsable()) {
                return false;
            }
            if (osmPrimitive instanceof Node) {
                Bounds bounds = this.getBounds();
                return bounds != null && bounds.contains(((Node)osmPrimitive).getCoor());
            }
            if (osmPrimitive instanceof Way) {
                List<Node> list = ((Way)osmPrimitive).getNodes();
                return this.all ? this.forallMatch(list) : this.existsMatch(list);
            }
            if (osmPrimitive instanceof Relation) {
                Set<OsmPrimitive> set = ((Relation)osmPrimitive).getMemberPrimitives();
                return this.all ? this.forallMatch(set) : this.existsMatch(set);
            }
            return false;
        }
    }

    private static class AreaSize
    extends RangeMatch {
        public AreaSize(PushbackTokenizer.Range range) {
            super(range);
        }

        public AreaSize(PushbackTokenizer pushbackTokenizer) throws ParseError {
            this(pushbackTokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osmPrimitive) {
            if (!(osmPrimitive instanceof Way) || !((Way)osmPrimitive).isClosed()) {
                return null;
            }
            Way way = (Way)osmPrimitive;
            return (long)Geometry.closedWayArea(way);
        }

        @Override
        protected String getString() {
            return "areasize";
        }
    }

    public static class Child
    extends UnaryMatch {
        public Child(Match match) {
            super(match);
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            boolean bl = false;
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                bl |= this.match.match(osmPrimitive2);
            }
            return bl;
        }

        public String toString() {
            return "child(" + this.match + ")";
        }
    }

    public static class Parent
    extends UnaryMatch {
        public Parent(Match match) {
            super(match);
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            boolean bl;
            block3: {
                block2: {
                    bl = false;
                    if (!(osmPrimitive instanceof Way)) break block2;
                    for (Node node : ((Way)osmPrimitive).getNodes()) {
                        bl |= this.match.match(node);
                    }
                    break block3;
                }
                if (!(osmPrimitive instanceof Relation)) break block3;
                for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                    bl |= this.match.match(relationMember.getMember());
                }
            }
            return bl;
        }

        public String toString() {
            return "parent(" + this.match + ")";
        }
    }

    private static class Closed
    extends Match {
        private Closed() {
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive instanceof Way && ((Way)osmPrimitive).isClosed();
        }

        public String toString() {
            return "closed";
        }
    }

    private static class Untagged
    extends Match {
        private Untagged() {
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return !osmPrimitive.isTagged() && !osmPrimitive.isIncomplete();
        }

        public String toString() {
            return "untagged";
        }
    }

    private static class Incomplete
    extends Match {
        private Incomplete() {
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isIncomplete();
        }

        public String toString() {
            return "incomplete";
        }
    }

    private static class Selected
    extends Match {
        private Selected() {
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return Main.main.getCurrentDataSet().isSelected(osmPrimitive);
        }

        public String toString() {
            return "selected";
        }
    }

    private static class Modified
    extends Match {
        private Modified() {
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isModified() || osmPrimitive.isNewOrUndeleted();
        }

        public String toString() {
            return "modified";
        }
    }

    private static class New
    extends Match {
        private New() {
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isNew();
        }

        public String toString() {
            return "new";
        }
    }

    private static class TimestampRange
    extends RangeMatch {
        public TimestampRange(long l, long l2) {
            super(l, l2);
        }

        @Override
        protected Long getNumber(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getTimestamp().getTime();
        }

        @Override
        protected String getString() {
            return "timestamp";
        }
    }

    private static class TagCountRange
    extends RangeMatch {
        public TagCountRange(PushbackTokenizer.Range range) {
            super(range);
        }

        public TagCountRange(PushbackTokenizer pushbackTokenizer) throws ParseError {
            this(pushbackTokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getKeys().size();
        }

        @Override
        protected String getString() {
            return "tags";
        }
    }

    private static class NodeCountRange
    extends RangeMatch {
        public NodeCountRange(PushbackTokenizer.Range range) {
            super(range);
        }

        public NodeCountRange(PushbackTokenizer pushbackTokenizer) throws ParseError {
            this(pushbackTokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osmPrimitive) {
            if (!(osmPrimitive instanceof Way)) {
                return null;
            }
            return ((Way)osmPrimitive).getRealNodesCount();
        }

        @Override
        protected String getString() {
            return "nodes";
        }
    }

    private static abstract class RangeMatch
    extends Match {
        private final long min;
        private final long max;

        public RangeMatch(long l, long l2) {
            this.min = Math.min(l, l2);
            this.max = Math.max(l, l2);
        }

        public RangeMatch(PushbackTokenizer.Range range) {
            this(range.getStart(), range.getEnd());
        }

        protected abstract Long getNumber(OsmPrimitive var1);

        protected abstract String getString();

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            Long l = this.getNumber(osmPrimitive);
            if (l == null) {
                return false;
            }
            return l >= this.min && l <= this.max;
        }

        public String toString() {
            return this.getString() + "=" + this.min + "-" + this.max;
        }
    }

    private static class Nth
    extends Match {
        private final int nth;
        private final boolean modulo;

        public Nth(PushbackTokenizer pushbackTokenizer, boolean bl) throws ParseError {
            this((int)pushbackTokenizer.readNumber(I18n.tr("Positive integer expected", new Object[0])), bl);
        }

        private Nth(int n, boolean bl) throws ParseError {
            if (n <= 0) {
                throw new ParseError(I18n.tr("Positive integer expected", new Object[0]));
            }
            this.nth = n;
            this.modulo = bl;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                OsmPrimitive osmPrimitive3;
                Integer n = null;
                if (osmPrimitive2 instanceof Way) {
                    osmPrimitive3 = (Way)osmPrimitive2;
                    n = ((Way)osmPrimitive3).getNodes().indexOf(osmPrimitive);
                } else if (osmPrimitive2 instanceof Relation) {
                    osmPrimitive3 = (Relation)osmPrimitive2;
                    n = ((Relation)osmPrimitive3).getMemberPrimitivesList().indexOf(osmPrimitive);
                }
                if (n == null || n != this.nth && (!this.modulo || n % this.nth != 0)) continue;
                return true;
            }
            return false;
        }
    }

    private static class RoleMatch
    extends Match {
        private String role;

        public RoleMatch(String string) {
            this.role = string == null ? "" : string;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || osmPrimitive2.isIncomplete() || osmPrimitive2.isDeleted()) continue;
                for (RelationMember relationMember : ((Relation)osmPrimitive2).getMembers()) {
                    String string;
                    if (relationMember.getMember() != osmPrimitive || !this.role.equals((string = relationMember.getRole()) == null ? "" : string)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "role=" + this.role;
        }
    }

    private static class UserMatch
    extends Match {
        private String user;

        public UserMatch(String string) {
            this.user = "anonymous".equals(string) ? null : string;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.getUser() == null) {
                return this.user == null;
            }
            return osmPrimitive.getUser().hasName(this.user);
        }

        public String toString() {
            return "user=" + (this.user == null ? "" : this.user);
        }
    }

    private static class ExactType
    extends Match {
        private final OsmPrimitiveType type;

        public ExactType(String string) throws ParseError {
            this.type = OsmPrimitiveType.from(string);
            if (this.type == null) {
                throw new ParseError(I18n.tr("Unknown primitive type: {0}. Allowed values are node, way or relation", string));
            }
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return this.type.equals((Object)osmPrimitive.getType());
        }

        public String toString() {
            return "type=" + (Object)((Object)this.type);
        }
    }

    private static class Any
    extends Match {
        private final String search;
        private final Pattern searchRegex;
        private final boolean caseSensitive;

        public Any(String string, boolean bl, boolean bl2) throws ParseError {
            string = Normalizer.normalize(string, Normalizer.Form.NFC);
            this.caseSensitive = bl2;
            if (bl) {
                try {
                    this.searchRegex = Pattern.compile(string, SearchCompiler.regexFlags(bl2));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()), patternSyntaxException);
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string, exception.getMessage()), exception);
                }
                this.search = string;
            } else if (bl2) {
                this.search = string;
                this.searchRegex = null;
            } else {
                this.search = string.toLowerCase();
                this.searchRegex = null;
            }
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.hasKeys() && osmPrimitive.getUser() == null) {
                return this.search.isEmpty();
            }
            for (String string : osmPrimitive.keySet()) {
                String string2 = osmPrimitive.get(string);
                if (this.searchRegex != null) {
                    string2 = Normalizer.normalize(string2, Normalizer.Form.NFC);
                    Matcher matcher = this.searchRegex.matcher(string);
                    Matcher matcher2 = this.searchRegex.matcher(string2);
                    boolean bl = matcher.find();
                    boolean bl2 = matcher2.find();
                    if (!bl && !bl2) continue;
                    return true;
                }
                if (!this.caseSensitive) {
                    string = string.toLowerCase();
                    string2 = string2.toLowerCase();
                }
                string2 = Normalizer.normalize(string2, Normalizer.Form.NFC);
                if (string.indexOf(this.search) == -1 && string2.indexOf(this.search) == -1) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.search;
        }
    }

    public static class ExactKeyValue
    extends Match {
        private final String key;
        private final String value;
        private final Pattern keyPattern;
        private final Pattern valuePattern;
        private final Mode mode;

        public ExactKeyValue(boolean bl, String string, String string2) throws ParseError {
            if ("".equals(string)) {
                throw new ParseError(I18n.tr("Key cannot be empty when tag operator is used. Sample use: key=value", new Object[0]));
            }
            this.key = string;
            String string3 = this.value = string2 == null ? "" : string2;
            this.mode = "".equals(this.value) && "*".equals(string) ? Mode.NONE : ("".equals(this.value) ? (bl ? Mode.MISSING_KEY_REGEXP : Mode.MISSING_KEY) : ("*".equals(string) && "*".equals(this.value) ? Mode.ANY : ("*".equals(string) ? (bl ? Mode.ANY_KEY_REGEXP : Mode.ANY_KEY) : ("*".equals(this.value) ? (bl ? Mode.ANY_VALUE_REGEXP : Mode.ANY_VALUE) : (bl ? Mode.EXACT_REGEXP : Mode.EXACT)))));
            if (bl && string.length() > 0 && !"*".equals(string)) {
                try {
                    this.keyPattern = Pattern.compile(string, SearchCompiler.regexFlags(false));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string, exception.getMessage()));
                }
            } else {
                this.keyPattern = null;
            }
            if (bl && this.value.length() > 0 && !"*".equals(this.value)) {
                try {
                    this.valuePattern = Pattern.compile(this.value, SearchCompiler.regexFlags(false));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string2, exception.getMessage()));
                }
            } else {
                this.valuePattern = null;
            }
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.hasKeys()) {
                return this.mode == Mode.NONE;
            }
            switch (this.mode) {
                case NONE: {
                    return false;
                }
                case MISSING_KEY: {
                    return osmPrimitive.get(this.key) == null;
                }
                case ANY: {
                    return true;
                }
                case ANY_VALUE: {
                    return osmPrimitive.get(this.key) != null;
                }
                case ANY_KEY: {
                    for (String string : osmPrimitive.getKeys().values()) {
                        if (!string.equals(this.value)) continue;
                        return true;
                    }
                    return false;
                }
                case EXACT: {
                    return this.value.equals(osmPrimitive.get(this.key));
                }
                case ANY_KEY_REGEXP: {
                    for (String string : osmPrimitive.getKeys().values()) {
                        if (!this.valuePattern.matcher(string).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case ANY_VALUE_REGEXP: 
                case EXACT_REGEXP: {
                    for (String string : osmPrimitive.keySet()) {
                        if (!this.keyPattern.matcher(string).matches() || this.mode != Mode.ANY_VALUE_REGEXP && !this.valuePattern.matcher(osmPrimitive.get(string)).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case MISSING_KEY_REGEXP: {
                    for (String string : osmPrimitive.keySet()) {
                        if (!this.keyPattern.matcher(string).matches()) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new AssertionError((Object)"Missed state");
        }

        public String toString() {
            return this.key + '=' + this.value;
        }

        private static enum Mode {
            ANY,
            ANY_KEY,
            ANY_VALUE,
            EXACT,
            NONE,
            MISSING_KEY,
            ANY_KEY_REGEXP,
            ANY_VALUE_REGEXP,
            EXACT_REGEXP,
            MISSING_KEY_REGEXP;

        }
    }

    public static class ValueComparison
    extends Match {
        private final String key;
        private final String referenceValue;
        private final int compareMode;

        public ValueComparison(String string, String string2, int n) {
            this.key = string;
            this.referenceValue = string2;
            this.compareMode = n;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            int n;
            String string = osmPrimitive.get(this.key);
            if (string == null) {
                return false;
            }
            try {
                n = Double.compare(Double.parseDouble(string), Double.parseDouble(this.referenceValue));
            }
            catch (NumberFormatException numberFormatException) {
                n = osmPrimitive.get(this.key).compareTo(this.referenceValue);
            }
            return this.compareMode < 0 ? n < 0 : (this.compareMode > 0 ? n > 0 : n == 0);
        }
    }

    private static class KeyValue
    extends Match {
        private final String key;
        private final Pattern keyPattern;
        private final String value;
        private final Pattern valuePattern;
        private final boolean caseSensitive;

        public KeyValue(String string, String string2, boolean bl, boolean bl2) throws ParseError {
            this.caseSensitive = bl2;
            if (bl) {
                int n = SearchCompiler.regexFlags(bl2);
                try {
                    this.keyPattern = Pattern.compile(string, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()), patternSyntaxException);
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string, exception.getMessage()), exception);
                }
                try {
                    this.valuePattern = Pattern.compile(string2, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()), patternSyntaxException);
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string2, exception.getMessage()), exception);
                }
                this.key = string;
                this.value = string2;
            } else if (bl2) {
                this.key = string;
                this.value = string2;
                this.keyPattern = null;
                this.valuePattern = null;
            } else {
                this.key = string.toLowerCase();
                this.value = string2;
                this.keyPattern = null;
                this.valuePattern = null;
            }
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            if (this.keyPattern != null) {
                if (!osmPrimitive.hasKeys()) {
                    return false;
                }
                for (String string : osmPrimitive.keySet()) {
                    Matcher matcher;
                    boolean bl;
                    String string2 = osmPrimitive.get(string);
                    Matcher matcher2 = this.keyPattern.matcher(string);
                    boolean bl2 = matcher2.find();
                    if (!bl2 || !(bl = (matcher = this.valuePattern.matcher(string2)).find())) continue;
                    return true;
                }
            } else {
                String string = null;
                string = "timestamp".equals(this.key) ? DateUtils.fromDate(osmPrimitive.getTimestamp()) : osmPrimitive.get(this.key);
                if (string == null) {
                    return false;
                }
                String string3 = this.caseSensitive ? string : string.toLowerCase();
                String string4 = this.caseSensitive ? this.value : this.value.toLowerCase();
                string3 = Normalizer.normalize(string3, Normalizer.Form.NFC);
                string4 = Normalizer.normalize(string4, Normalizer.Form.NFC);
                return string3.indexOf(string4) != -1;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class Version
    extends RangeMatch {
        public Version(PushbackTokenizer.Range range) {
            super(range);
        }

        public Version(PushbackTokenizer pushbackTokenizer) throws ParseError {
            this(pushbackTokenizer.readRange(I18n.tr("Range of versions expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getVersion();
        }

        @Override
        protected String getString() {
            return "version";
        }
    }

    private static class ChangesetId
    extends RangeMatch {
        public ChangesetId(PushbackTokenizer.Range range) {
            super(range);
        }

        public ChangesetId(PushbackTokenizer pushbackTokenizer) throws ParseError {
            this(pushbackTokenizer.readRange(I18n.tr("Range of changeset ids expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getChangesetId();
        }

        @Override
        protected String getString() {
            return "changeset";
        }
    }

    private static class Id
    extends RangeMatch {
        public Id(PushbackTokenizer.Range range) {
            super(range);
        }

        public Id(PushbackTokenizer pushbackTokenizer) throws ParseError {
            this(pushbackTokenizer.readRange(I18n.tr("Range of primitive ids expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isNew() ? 0L : osmPrimitive.getUniqueId();
        }

        @Override
        protected String getString() {
            return "id";
        }
    }

    public static class Xor
    extends BinaryMatch {
        public Xor(Match match, Match match2) {
            super(match, match2);
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return this.lhs.match(osmPrimitive) ^ this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " ^ " + this.rhs;
        }
    }

    public static class Or
    extends BinaryMatch {
        public Or(Match match, Match match2) {
            super(match, match2);
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return this.lhs.match(osmPrimitive) || this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " || " + this.rhs;
        }
    }

    public static class And
    extends BinaryMatch {
        public And(Match match, Match match2) {
            super(match, match2);
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return this.lhs.match(osmPrimitive) && this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " && " + this.rhs;
        }
    }

    private static class BooleanMatch
    extends Match {
        private final String key;
        private final boolean defaultValue;

        public BooleanMatch(String string, boolean bl) {
            this.key = string;
            this.defaultValue = bl;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            Boolean bl = OsmUtils.getOsmBoolean(osmPrimitive.get(this.key));
            if (bl == null) {
                return this.defaultValue;
            }
            return bl;
        }
    }

    public static class Not
    extends UnaryMatch {
        public Not(Match match) {
            super(match);
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return !this.match.match(osmPrimitive);
        }

        public String toString() {
            return "!" + this.match;
        }

        public Match getMatch() {
            return this.match;
        }
    }

    public static class Never
    extends Match {
        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return false;
        }
    }

    public static class Always
    extends Match {
        public static final Always INSTANCE = new Always();

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            return true;
        }
    }

    public static abstract class BinaryMatch
    extends Match {
        protected final Match lhs;
        protected final Match rhs;

        public BinaryMatch(Match match, Match match2) {
            this.lhs = match;
            this.rhs = match2;
        }

        public Match getLhs() {
            return this.lhs;
        }

        public Match getRhs() {
            return this.rhs;
        }
    }

    public static abstract class UnaryMatch
    extends Match {
        protected final Match match;

        public UnaryMatch(Match match) {
            this.match = match == null ? new Always() : match;
        }

        public Match getOperand() {
            return this.match;
        }
    }

    public static abstract class Match
    implements Predicate<OsmPrimitive> {
        public abstract boolean match(OsmPrimitive var1);

        protected boolean existsMatch(Collection<? extends OsmPrimitive> collection) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!this.match(osmPrimitive)) continue;
                return true;
            }
            return false;
        }

        protected boolean forallMatch(Collection<? extends OsmPrimitive> collection) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (this.match(osmPrimitive)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean evaluate(OsmPrimitive osmPrimitive) {
            return this.match(osmPrimitive);
        }
    }

    public static interface BinaryMatchFactory
    extends MatchFactory {
        public BinaryMatch get(String var1, Match var2, Match var3, PushbackTokenizer var4) throws ParseError;
    }

    public static interface UnaryMatchFactory
    extends MatchFactory {
        public UnaryMatch get(String var1, Match var2, PushbackTokenizer var3) throws ParseError;
    }

    public static interface SimpleMatchFactory
    extends MatchFactory {
        public Match get(String var1, PushbackTokenizer var2) throws ParseError;
    }

    private static interface MatchFactory {
        public Collection<String> getKeywords();
    }

    public static class CoreUnaryMatchFactory
    implements UnaryMatchFactory {
        private static Collection<String> keywords = Arrays.asList("parent", "child");

        @Override
        public UnaryMatch get(String string, Match match, PushbackTokenizer pushbackTokenizer) {
            if ("parent".equals(string)) {
                return new Parent(match);
            }
            if ("child".equals(string)) {
                return new Child(match);
            }
            return null;
        }

        @Override
        public Collection<String> getKeywords() {
            return keywords;
        }
    }

    public class CoreSimpleMatchFactory
    implements SimpleMatchFactory {
        private Collection<String> keywords = Arrays.asList("id", "version", "changeset", "nodes", "tags", "areasize", "modified", "selected", "incomplete", "untagged", "closed", "new", "indownloadedarea", "allindownloadedarea", "inview", "allinview", "timestamp", "nth", "nth%");

        @Override
        public Match get(String string, PushbackTokenizer pushbackTokenizer) throws ParseError {
            switch (string) {
                case "modified": {
                    return new Modified();
                }
                case "selected": {
                    return new Selected();
                }
                case "incomplete": {
                    return new Incomplete();
                }
                case "untagged": {
                    return new Untagged();
                }
                case "closed": {
                    return new Closed();
                }
                case "new": {
                    return new New();
                }
                case "indownloadedarea": {
                    return new InDataSourceArea(false);
                }
                case "allindownloadedarea": {
                    return new InDataSourceArea(true);
                }
                case "inview": {
                    return new InView(false);
                }
                case "allinview": {
                    return new InView(true);
                }
            }
            if (pushbackTokenizer != null) {
                switch (string) {
                    case "id": {
                        return new Id(pushbackTokenizer);
                    }
                    case "version": {
                        return new Version(pushbackTokenizer);
                    }
                    case "changeset": {
                        return new ChangesetId(pushbackTokenizer);
                    }
                    case "nodes": {
                        return new NodeCountRange(pushbackTokenizer);
                    }
                    case "tags": {
                        return new TagCountRange(pushbackTokenizer);
                    }
                    case "areasize": {
                        return new AreaSize(pushbackTokenizer);
                    }
                    case "nth": {
                        return new Nth(pushbackTokenizer, false);
                    }
                    case "nth%": {
                        return new Nth(pushbackTokenizer, true);
                    }
                    case "timestamp": {
                        String string2 = " " + pushbackTokenizer.readTextOrNumber() + " ";
                        String[] stringArray = string2.split("/");
                        if (stringArray.length == 1) {
                            return new KeyValue(string, string2.trim(), SearchCompiler.this.regexSearch, SearchCompiler.this.caseSensitive);
                        }
                        if (stringArray.length == 2) {
                            String string3 = stringArray[0].trim();
                            String string4 = stringArray[1].trim();
                            long l = DateUtils.fromString(string3.isEmpty() ? "1980" : string3).getTime();
                            long l2 = string4.isEmpty() ? System.currentTimeMillis() : DateUtils.fromString(string4).getTime();
                            return new TimestampRange(l, l2);
                        }
                        throw new ParseError(I18n.tr("Expecting <i>min</i>/<i>max</i> after ''timestamp''", new Object[0]));
                    }
                }
            }
            return null;
        }

        @Override
        public Collection<String> getKeywords() {
            return this.keywords;
        }
    }
}

