/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadNotesTask
extends AbstractDownloadTask {
    private static final String PATTERN_API_URL = "https?://.*/api/0.6/notes.*";
    private static final String PATTERN_DUMP_FILE = "https?://.*/(.*\\.osn(.bz2)?)";
    private DownloadTask downloadTask;

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadBoundingBoxTask(new BoundingBoxDownloader(bounds), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        this.downloadTask = string.endsWith(".bz2") ? new DownloadBzip2RawUrlTask(new OsmServerLocationReader(string), progressMonitor) : new DownloadRawUrlTask(new OsmServerLocationReader(string), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        return null;
    }

    @Override
    public String getTitle() {
        return "Download OSM Notes";
    }

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_API_URL, PATTERN_DUMP_FILE};
    }

    class DownloadBzip2RawUrlTask
    extends DownloadTask {
        public DownloadBzip2RawUrlTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(osmServerReader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseRawNotesBzip2(progressMonitor);
            }
            catch (Exception exception) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadNotesTask.this.rememberException(exception);
                }
                DownloadNotesTask.this.rememberException(new OsmTransferException(exception));
            }
        }
    }

    class DownloadRawUrlTask
    extends DownloadTask {
        public DownloadRawUrlTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(osmServerReader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseRawNotes(progressMonitor);
            }
            catch (Exception exception) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadNotesTask.this.rememberException(exception);
                }
                DownloadNotesTask.this.rememberException(new OsmTransferException(exception));
            }
        }
    }

    class DownloadBoundingBoxTask
    extends DownloadTask {
        public DownloadBoundingBoxTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(osmServerReader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseNotes(null, null, progressMonitor);
            }
            catch (Exception exception) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadNotesTask.this.rememberException(exception);
                }
                DownloadNotesTask.this.rememberException(new OsmTransferException(exception));
            }
        }
    }

    abstract class DownloadTask
    extends PleaseWaitRunnable {
        protected OsmServerReader reader;
        protected List<Note> notesData;

        public DownloadTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading Notes", new Object[0]), progressMonitor, false);
            this.reader = osmServerReader;
        }

        @Override
        protected void finish() {
            Main.debug("finish called in DownloadNotesTask");
            if (DownloadNotesTask.this.isCanceled() || DownloadNotesTask.this.isFailed()) {
                Main.debug("was cancelled or failed");
                return;
            }
            if (this.notesData == null) {
                return;
            }
            Main.debug("Notes downloaded: " + this.notesData.size());
            List<NoteLayer> list = null;
            if (Main.map != null) {
                list = Main.map.mapView.getLayersOfType(NoteLayer.class);
            }
            if (list != null && list.size() > 0) {
                NoteLayer noteLayer = list.get(0);
                noteLayer.getNoteData().addNotes(this.notesData);
            } else {
                NoteLayer noteLayer = new NoteLayer(this.notesData, "Notes");
                Main.main.addLayer(noteLayer);
            }
        }

        @Override
        protected void cancel() {
            DownloadNotesTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public abstract void realRun() throws IOException, SAXException, OsmTransferException;
    }
}

