/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RestartAction
extends JosmAction {
    private static final String RESTART_APPLE_SCRIPT = "tell application \"System Events\"\nrepeat until not (exists process \"JOSM\")\ndelay 0.2\nend repeat\nend tell\ntell application \"JOSM\" to activate";

    public RestartAction() {
        super(I18n.tr("Restart", new Object[0]), "restart", I18n.tr("Restart the application.", new Object[0]), Shortcut.registerShortcut("file:restart", I18n.tr("File: {0}", I18n.tr("Restart", new Object[0])), 74, 5010), false);
        this.putValue("help", HelpUtil.ht("/Action/Restart"));
        this.putValue("toolbar", "action/restart");
        Main.toolbar.register(this);
        this.setEnabled(RestartAction.isRestartSupported());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = System.getProperty("josm.restart");
        if ("true".equals(string)) {
            Main.exitJosm(true, 9);
        }
        try {
            RestartAction.restartJOSM();
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
    }

    public static boolean isRestartSupported() {
        return System.getProperty("sun.java.command") != null;
    }

    public static void restartJOSM() throws IOException {
        if (RestartAction.isRestartSupported() && !Main.exitJosm(false, 0)) {
            return;
        }
        try {
            final ArrayList<String> arrayList = new ArrayList<String>();
            if (Main.isPlatformOsx() && System.getProperty("java.library.path").contains("/JOSM.app/Contents/MacOS")) {
                arrayList.add("/usr/bin/osascript");
                for (String string : RESTART_APPLE_SCRIPT.split("\n")) {
                    arrayList.add("-e");
                    arrayList.add(string);
                }
            } else {
                String string3;
                String string2 = System.getProperty("java.home") + File.separator + "bin" + File.separator + (Main.isPlatformWindows() ? "java.exe" : "java");
                if (!new File(string2).isFile()) {
                    throw new IOException("Unable to find suitable java runtime at " + string2);
                }
                arrayList.add(string2);
                for (String string3 : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                    if (string3.contains("-agentlib")) continue;
                    arrayList.add(string3);
                }
                String[] stringArray = System.getProperty("sun.java.command").split(" ");
                string3 = stringArray[0];
                for (int i = 1; i < stringArray.length && !string3.endsWith(".jar"); ++i) {
                    string3 = string3 + " " + stringArray[i];
                }
                if (string3.endsWith(".jar")) {
                    arrayList.add("-jar");
                    arrayList.add(new File(string3).getPath());
                } else {
                    arrayList.add("-cp");
                    arrayList.add("\"" + System.getProperty("java.class.path") + "\"");
                    arrayList.add(stringArray[0]);
                }
                String string4 = System.getProperty("jnlp.application.href");
                if (string4 != null) {
                    arrayList.add(string4);
                }
                arrayList.addAll(Arrays.asList(Main.commandLineArgs));
            }
            Main.info("Restart " + arrayList);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]));
                    }
                    catch (IOException iOException) {
                        Main.error(iOException);
                    }
                }
            });
            System.exit(0);
        }
        catch (Exception exception) {
            throw new IOException("Error while trying to restart the application", exception);
        }
    }

    public static HelpAwareOptionPane.ButtonSpec getRestartButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Restart", new Object[0]), ImageProvider.get("restart"), I18n.tr("Restart the application.", new Object[0]), HelpUtil.ht("/Action/Restart"), RestartAction.isRestartSupported());
    }

    public static HelpAwareOptionPane.ButtonSpec getCancelButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to restart later.", new Object[0]), null);
    }

    public static HelpAwareOptionPane.ButtonSpec[] getButtonSpecs() {
        return new HelpAwareOptionPane.ButtonSpec[]{RestartAction.getRestartButtonSpec(), RestartAction.getCancelButtonSpec()};
    }
}

