/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class CopyCoordinatesAction
extends JosmAction {
    public CopyCoordinatesAction() {
        super(I18n.tr("Copy Coordinates", new Object[0]), null, I18n.tr("Copy coordinates of selected nodes to clipboard.", new Object[0]), Shortcut.registerShortcut("copy:coordinates", I18n.tr("Edit: {0}", I18n.tr("Copy Coordinates", new Object[0])), 67, 5009), false);
        this.putValue("toolbar", "copy/coordinates");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : this.getSelectedNodes()) {
            stringBuilder.append(node.getCoor().lat());
            stringBuilder.append(", ");
            stringBuilder.append(node.getCoor().lon());
            stringBuilder.append("\n");
        }
        Utils.copyToClipboard(stringBuilder.toString().trim());
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.getSelectedNodes().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.updateEnabledState();
    }

    private Collection<Node> getSelectedNodes() {
        if (CopyCoordinatesAction.getCurrentDataSet() == null || CopyCoordinatesAction.getCurrentDataSet().getSelected() == null) {
            return Collections.emptyList();
        }
        return Utils.filteredCollection(CopyCoordinatesAction.getCurrentDataSet().getSelected(), Node.class);
    }
}

