/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.pathcmd.BuildHistory;
import com.kitfox.svg.pathcmd.PathCommand;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class MissingGlyph
extends ShapeElement {
    public static final String TAG_NAME = "missingglyph";
    Shape path = null;
    int horizAdvX = -1;
    int vertOriginX = -1;
    int vertOriginY = -1;
    int vertAdvY = -1;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        super.loaderAddChild(sVGLoaderHelper, sVGElement);
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        String string = "";
        if (this.getPres(styleAttribute.setName("d"))) {
            string = styleAttribute.getStringValue();
        }
        if (string != null) {
            String string2 = this.getStyle(styleAttribute.setName("fill-rule")) ? styleAttribute.getStringValue() : "nonzero";
            PathCommand[] pathCommandArray = MissingGlyph.parsePathList(string);
            GeneralPath generalPath = new GeneralPath(string2.equals("evenodd") ? 0 : 1, pathCommandArray.length);
            BuildHistory buildHistory = new BuildHistory();
            for (int i = 0; i < pathCommandArray.length; ++i) {
                PathCommand pathCommand = pathCommandArray[i];
                pathCommand.appendPath(generalPath, buildHistory);
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0, -1.0);
            this.path = affineTransform.createTransformedShape(generalPath);
        }
        if (this.getPres(styleAttribute.setName("horiz-adv-x"))) {
            this.horizAdvX = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("vert-origin-x"))) {
            this.vertOriginX = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("vert-origin-y"))) {
            this.vertOriginY = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("vert-adv-y"))) {
            this.vertAdvY = styleAttribute.getIntValue();
        }
    }

    public Shape getPath() {
        return this.path;
    }

    @Override
    public void render(Graphics2D graphics2D) throws SVGException {
        if (this.path != null) {
            this.renderShape(graphics2D, this.path);
        }
        for (SVGElement sVGElement : this.children) {
            if (!(sVGElement instanceof RenderableElement)) continue;
            ((RenderableElement)sVGElement).render(graphics2D);
        }
    }

    public int getHorizAdvX() {
        if (this.horizAdvX == -1) {
            this.horizAdvX = ((Font)this.parent).getHorizAdvX();
        }
        return this.horizAdvX;
    }

    public int getVertOriginX() {
        if (this.vertOriginX == -1) {
            this.vertOriginX = this.getHorizAdvX() / 2;
        }
        return this.vertOriginX;
    }

    public int getVertOriginY() {
        if (this.vertOriginY == -1) {
            this.vertOriginY = ((Font)this.parent).getFontFace().getAscent();
        }
        return this.vertOriginY;
    }

    public int getVertAdvY() {
        if (this.vertAdvY == -1) {
            this.vertAdvY = ((Font)this.parent).getFontFace().getUnitsPerEm();
        }
        return this.vertAdvY;
    }

    @Override
    public Shape getShape() {
        if (this.path != null) {
            return this.shapeToParent(this.path);
        }
        return null;
    }

    @Override
    public Rectangle2D getBoundingBox() throws SVGException {
        if (this.path != null) {
            return this.boundsToParent(this.includeStrokeInBounds(this.path.getBounds2D()));
        }
        return null;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        return false;
    }
}

