/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Age;
import com.drew.metadata.Face;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.PanasonicMakernoteDirectory;
import java.io.UnsupportedEncodingException;

public class PanasonicMakernoteDescriptor
extends TagDescriptor<PanasonicMakernoteDirectory> {
    public PanasonicMakernoteDescriptor(@NotNull PanasonicMakernoteDirectory panasonicMakernoteDirectory) {
        super(panasonicMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getQualityModeDescription();
            }
            case 2: {
                return this.getVersionDescription();
            }
            case 3: {
                return this.getWhiteBalanceDescription();
            }
            case 7: {
                return this.getFocusModeDescription();
            }
            case 15: {
                return this.getAfAreaModeDescription();
            }
            case 26: {
                return this.getImageStabilizationDescription();
            }
            case 28: {
                return this.getMacroModeDescription();
            }
            case 31: {
                return this.getRecordModeDescription();
            }
            case 32: {
                return this.getAudioDescription();
            }
            case 33: {
                return this.getUnknownDataDumpDescription();
            }
            case 40: {
                return this.getColorEffectDescription();
            }
            case 41: {
                return this.getUptimeDescription();
            }
            case 42: {
                return this.getBurstModeDescription();
            }
            case 44: {
                return this.getContrastModeDescription();
            }
            case 45: {
                return this.getNoiseReductionDescription();
            }
            case 46: {
                return this.getSelfTimerDescription();
            }
            case 48: {
                return this.getRotationDescription();
            }
            case 49: {
                return this.getAfAssistLampDescription();
            }
            case 50: {
                return this.getColorModeDescription();
            }
            case 52: {
                return this.getOpticalZoomModeDescription();
            }
            case 53: {
                return this.getConversionLensDescription();
            }
            case 57: {
                return this.getContrastDescription();
            }
            case 58: {
                return this.getWorldTimeLocationDescription();
            }
            case 61: {
                return this.getAdvancedSceneModeDescription();
            }
            case 78: {
                return this.getDetectedFacesDescription();
            }
            case 89: {
                return this.getTransformDescription();
            }
            case 32786: {
                return this.getTransform1Description();
            }
            case 93: {
                return this.getIntelligentExposureDescription();
            }
            case 98: {
                return this.getFlashWarningDescription();
            }
            case 105: {
                return this.getCountryDescription();
            }
            case 107: {
                return this.getStateDescription();
            }
            case 109: {
                return this.getCityDescription();
            }
            case 111: {
                return this.getLandmarkDescription();
            }
            case 112: {
                return this.getIntelligentResolutionDescription();
            }
            case 97: {
                return this.getRecognizedFacesDescription();
            }
            case 3584: {
                return this.getPrintImageMatchingInfoDescription();
            }
            case 32769: {
                return this.getSceneModeDescription();
            }
            case 32775: {
                return this.getFlashFiredDescription();
            }
            case 59: {
                return this.getTextStampDescription();
            }
            case 62: {
                return this.getTextStamp1Description();
            }
            case 32776: {
                return this.getTextStamp2Description();
            }
            case 32777: {
                return this.getTextStamp3Description();
            }
            case 32768: {
                return this.getMakernoteVersionDescription();
            }
            case 38: {
                return this.getExifVersionDescription();
            }
            case 37: {
                return this.getInternalSerialNumberDescription();
            }
            case 101: {
                return this.getTitleDescription();
            }
            case 102: {
                return this.getBabyNameDescription();
            }
            case 103: {
                return this.getLocationDescription();
            }
            case 51: {
                return this.getBabyAgeDescription();
            }
            case 32784: {
                return this.getBabyAge1Description();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getPrintImageMatchingInfoDescription() {
        byte[] byArray = ((PanasonicMakernoteDirectory)this._directory).getByteArray(3584);
        if (byArray == null) {
            return null;
        }
        return "(" + byArray.length + " bytes)";
    }

    @Nullable
    public String getTextStampDescription() {
        return this.getOnOffDescription(59);
    }

    @Nullable
    public String getTextStamp1Description() {
        return this.getOnOffDescription(62);
    }

    @Nullable
    public String getTextStamp2Description() {
        return this.getOnOffDescription(32776);
    }

    @Nullable
    public String getTextStamp3Description() {
        return this.getOnOffDescription(32777);
    }

    @Nullable
    public String getMacroModeDescription() {
        return this.getOnOffDescription(28);
    }

    @Nullable
    public String getFlashFiredDescription() {
        return this.getOnOffDescription(32775);
    }

    @Nullable
    public String getImageStabilizationDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(26);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 2: {
                return "On, Mode 1";
            }
            case 3: {
                return "Off";
            }
            case 4: {
                return "On, Mode 2";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAudioDescription() {
        return this.getOnOffDescription(32);
    }

    @Nullable
    public String getTransformDescription() {
        return this.getTransformDescription(89);
    }

    @Nullable
    public String getTransform1Description() {
        return this.getTransformDescription(32786);
    }

    @Nullable
    private String getTransformDescription(int n) {
        byte[] byArray = ((PanasonicMakernoteDirectory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        try {
            int n2 = byteArrayReader.getUInt16(0);
            int n3 = byteArrayReader.getUInt16(2);
            if (n2 == -1 && n3 == 1) {
                return "Slim Low";
            }
            if (n2 == -3 && n3 == 2) {
                return "Slim High";
            }
            if (n2 == 0 && n3 == 0) {
                return "Off";
            }
            if (n2 == 1 && n3 == 1) {
                return "Stretch Low";
            }
            if (n2 == 3 && n3 == 2) {
                return "Stretch High";
            }
            return "Unknown (" + n2 + " " + n3 + ")";
        }
        catch (BufferBoundsException bufferBoundsException) {
            return null;
        }
    }

    @Nullable
    public String getIntelligentExposureDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(93);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "Standard";
            }
            case 3: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashWarningDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(98);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "No";
            }
            case 1: {
                return "Yes (Flash required but disabled)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getCountryDescription() {
        return this.getTextDescription(105);
    }

    @Nullable
    public String getStateDescription() {
        return this.getTextDescription(107);
    }

    @Nullable
    public String getCityDescription() {
        return this.getTextDescription(109);
    }

    @Nullable
    public String getLandmarkDescription() {
        return this.getTextDescription(111);
    }

    @Nullable
    public String getTitleDescription() {
        return this.getTextDescription(101);
    }

    @Nullable
    public String getBabyNameDescription() {
        return this.getTextDescription(102);
    }

    @Nullable
    public String getLocationDescription() {
        return this.getTextDescription(103);
    }

    @Nullable
    public String getIntelligentResolutionDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(112);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 2: {
                return "Auto";
            }
            case 3: {
                return "On";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(57);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getWorldTimeLocationDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(58);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Home";
            }
            case 2: {
                return "Destination";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAdvancedSceneModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(61);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Outdoor/Illuminations/Flower/HDR Art";
            }
            case 3: {
                return "Indoor/Architecture/Objects/HDR B&W";
            }
            case 4: {
                return "Creative";
            }
            case 5: {
                return "Auto";
            }
            case 7: {
                return "Expressive";
            }
            case 8: {
                return "Retro";
            }
            case 9: {
                return "Pure";
            }
            case 10: {
                return "Elegant";
            }
            case 12: {
                return "Monochrome";
            }
            case 13: {
                return "Dynamic Art";
            }
            case 14: {
                return "Silhouette";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getUnknownDataDumpDescription() {
        byte[] byArray = ((PanasonicMakernoteDirectory)this._directory).getByteArray(33);
        if (byArray == null) {
            return null;
        }
        return "[" + byArray.length + " bytes]";
    }

    @Nullable
    public String getColorEffectDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(40);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "Warm";
            }
            case 3: {
                return "Cool";
            }
            case 4: {
                return "Black & White";
            }
            case 5: {
                return "Sepia";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getUptimeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(41);
        if (n == null) {
            return null;
        }
        return (float)n.intValue() / 100.0f + " s";
    }

    @Nullable
    public String getBurstModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(42);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Infinite";
            }
            case 4: {
                return "Unlimited";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContrastModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(44);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
            case 6: {
                return "Medium Low";
            }
            case 7: {
                return "Medium High";
            }
            case 256: {
                return "Low";
            }
            case 272: {
                return "Normal";
            }
            case 288: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getNoiseReductionDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(45);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Standard (0)";
            }
            case 1: {
                return "Low (-1)";
            }
            case 2: {
                return "High (+1)";
            }
            case 3: {
                return "Lowest (-2)";
            }
            case 4: {
                return "Highest (+2)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSelfTimerDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(46);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "10 s";
            }
            case 3: {
                return "2 s";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getRotationDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(48);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Horizontal";
            }
            case 3: {
                return "Rotate 180";
            }
            case 6: {
                return "Rotate 90 CW";
            }
            case 8: {
                return "Rotate 270 CW";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAfAssistLampDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(49);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Fired";
            }
            case 2: {
                return "Enabled but not used";
            }
            case 3: {
                return "Disabled but required";
            }
            case 4: {
                return "Disabled and not required";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getColorModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(50);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Natural";
            }
            case 2: {
                return "Vivid";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getOpticalZoomModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(52);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Standard";
            }
            case 2: {
                return "Extended";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getConversionLensDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(53);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "Wide";
            }
            case 3: {
                return "Telephoto";
            }
            case 4: {
                return "Macro";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getDetectedFacesDescription() {
        return this.buildFacesDescription(((PanasonicMakernoteDirectory)this._directory).getDetectedFaces());
    }

    @Nullable
    public String getRecognizedFacesDescription() {
        return this.buildFacesDescription(((PanasonicMakernoteDirectory)this._directory).getRecognizedFaces());
    }

    @Nullable
    private String buildFacesDescription(@Nullable Face[] faceArray) {
        if (faceArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < faceArray.length; ++i) {
            stringBuilder.append("Face ").append(i + 1).append(": ").append(faceArray[i].toString()).append("\n");
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return null;
    }

    @Nullable
    public String getRecordModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(31);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Portrait";
            }
            case 3: {
                return "Scenery";
            }
            case 4: {
                return "Sports";
            }
            case 5: {
                return "Night Portrait";
            }
            case 6: {
                return "Program";
            }
            case 7: {
                return "Aperture Priority";
            }
            case 8: {
                return "Shutter Priority";
            }
            case 9: {
                return "Macro";
            }
            case 10: {
                return "Spot";
            }
            case 11: {
                return "Manual";
            }
            case 12: {
                return "Movie Preview";
            }
            case 13: {
                return "Panning";
            }
            case 14: {
                return "Simple";
            }
            case 15: {
                return "Color Effects";
            }
            case 16: {
                return "Self Portrait";
            }
            case 17: {
                return "Economy";
            }
            case 18: {
                return "Fireworks";
            }
            case 19: {
                return "Party";
            }
            case 20: {
                return "Snow";
            }
            case 21: {
                return "Night Scenery";
            }
            case 22: {
                return "Food";
            }
            case 23: {
                return "Baby";
            }
            case 24: {
                return "Soft Skin";
            }
            case 25: {
                return "Candlelight";
            }
            case 26: {
                return "Starry Night";
            }
            case 27: {
                return "High Sensitivity";
            }
            case 28: {
                return "Panorama Assist";
            }
            case 29: {
                return "Underwater";
            }
            case 30: {
                return "Beach";
            }
            case 31: {
                return "Aerial Photo";
            }
            case 32: {
                return "Sunset";
            }
            case 33: {
                return "Pet";
            }
            case 34: {
                return "Intelligent ISO";
            }
            case 35: {
                return "Clipboard";
            }
            case 36: {
                return "High Speed Continuous Shooting";
            }
            case 37: {
                return "Intelligent Auto";
            }
            case 39: {
                return "Multi-aspect";
            }
            case 41: {
                return "Transform";
            }
            case 42: {
                return "Flash Burst";
            }
            case 43: {
                return "Pin Hole";
            }
            case 44: {
                return "Film Grain";
            }
            case 45: {
                return "My Color";
            }
            case 46: {
                return "Photo Frame";
            }
            case 51: {
                return "HDR";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSceneModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(32769);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Portrait";
            }
            case 3: {
                return "Scenery";
            }
            case 4: {
                return "Sports";
            }
            case 5: {
                return "Night Portrait";
            }
            case 6: {
                return "Program";
            }
            case 7: {
                return "Aperture Priority";
            }
            case 8: {
                return "Shutter Priority";
            }
            case 9: {
                return "Macro";
            }
            case 10: {
                return "Spot";
            }
            case 11: {
                return "Manual";
            }
            case 12: {
                return "Movie Preview";
            }
            case 13: {
                return "Panning";
            }
            case 14: {
                return "Simple";
            }
            case 15: {
                return "Color Effects";
            }
            case 16: {
                return "Self Portrait";
            }
            case 17: {
                return "Economy";
            }
            case 18: {
                return "Fireworks";
            }
            case 19: {
                return "Party";
            }
            case 20: {
                return "Snow";
            }
            case 21: {
                return "Night Scenery";
            }
            case 22: {
                return "Food";
            }
            case 23: {
                return "Baby";
            }
            case 24: {
                return "Soft Skin";
            }
            case 25: {
                return "Candlelight";
            }
            case 26: {
                return "Starry Night";
            }
            case 27: {
                return "High Sensitivity";
            }
            case 28: {
                return "Panorama Assist";
            }
            case 29: {
                return "Underwater";
            }
            case 30: {
                return "Beach";
            }
            case 31: {
                return "Aerial Photo";
            }
            case 32: {
                return "Sunset";
            }
            case 33: {
                return "Pet";
            }
            case 34: {
                return "Intelligent ISO";
            }
            case 35: {
                return "Clipboard";
            }
            case 36: {
                return "High Speed Continuous Shooting";
            }
            case 37: {
                return "Intelligent Auto";
            }
            case 39: {
                return "Multi-aspect";
            }
            case 41: {
                return "Transform";
            }
            case 42: {
                return "Flash Burst";
            }
            case 43: {
                return "Pin Hole";
            }
            case 44: {
                return "Film Grain";
            }
            case 45: {
                return "My Color";
            }
            case 46: {
                return "Photo Frame";
            }
            case 51: {
                return "HDR";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocusModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(7);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Manual";
            }
            case 4: {
                return "Auto, Focus Button";
            }
            case 5: {
                return "Auto, Continuous";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAfAreaModeDescription() {
        int[] nArray = ((PanasonicMakernoteDirectory)this._directory).getIntArray(15);
        if (nArray == null || nArray.length < 2) {
            return null;
        }
        switch (nArray[0]) {
            case 0: {
                switch (nArray[1]) {
                    case 1: {
                        return "Spot Mode On";
                    }
                    case 16: {
                        return "Spot Mode Off";
                    }
                }
                return "Unknown (" + nArray[0] + " " + nArray[1] + ")";
            }
            case 1: {
                switch (nArray[1]) {
                    case 0: {
                        return "Spot Focusing";
                    }
                    case 1: {
                        return "5-area";
                    }
                }
                return "Unknown (" + nArray[0] + " " + nArray[1] + ")";
            }
            case 16: {
                switch (nArray[1]) {
                    case 0: {
                        return "1-area";
                    }
                    case 16: {
                        return "1-area (high speed)";
                    }
                }
                return "Unknown (" + nArray[0] + " " + nArray[1] + ")";
            }
            case 32: {
                switch (nArray[1]) {
                    case 0: {
                        return "Auto or Face Detect";
                    }
                    case 1: {
                        return "3-area (left)";
                    }
                    case 2: {
                        return "3-area (center)";
                    }
                    case 3: {
                        return "3-area (right)";
                    }
                }
                return "Unknown (" + nArray[0] + " " + nArray[1] + ")";
            }
            case 64: {
                return "Face Detect";
            }
        }
        return "Unknown (" + nArray[0] + " " + nArray[1] + ")";
    }

    @Nullable
    public String getQualityModeDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(1);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 2: {
                return "High";
            }
            case 3: {
                return "Normal";
            }
            case 6: {
                return "Very High";
            }
            case 7: {
                return "Raw";
            }
            case 9: {
                return "Motion Picture";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getVersionDescription() {
        return PanasonicMakernoteDescriptor.convertBytesToVersionString(((PanasonicMakernoteDirectory)this._directory).getIntArray(2), 2);
    }

    @Nullable
    public String getMakernoteVersionDescription() {
        return PanasonicMakernoteDescriptor.convertBytesToVersionString(((PanasonicMakernoteDirectory)this._directory).getIntArray(32768), 2);
    }

    @Nullable
    public String getExifVersionDescription() {
        return PanasonicMakernoteDescriptor.convertBytesToVersionString(((PanasonicMakernoteDirectory)this._directory).getIntArray(38), 2);
    }

    @Nullable
    public String getInternalSerialNumberDescription() {
        byte[] byArray = ((PanasonicMakernoteDirectory)this._directory).getByteArray(37);
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (n2 != 0 && n2 <= 127) continue;
            n = i;
            break;
        }
        return new String(byArray, 0, n);
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = ((PanasonicMakernoteDirectory)this._directory).getInteger(3);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Daylight";
            }
            case 3: {
                return "Cloudy";
            }
            case 4: {
                return "Incandescent";
            }
            case 5: {
                return "Manual";
            }
            case 8: {
                return "Flash";
            }
            case 10: {
                return "Black & White";
            }
            case 11: {
                return "Manual";
            }
            case 12: {
                return "Shade";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getBabyAgeDescription() {
        Age age = ((PanasonicMakernoteDirectory)this._directory).getAge(51);
        if (age == null) {
            return null;
        }
        return age.toFriendlyString();
    }

    @Nullable
    public String getBabyAge1Description() {
        Age age = ((PanasonicMakernoteDirectory)this._directory).getAge(32784);
        if (age == null) {
            return null;
        }
        return age.toFriendlyString();
    }

    @Nullable
    private String getTextDescription(int n) {
        byte[] byArray = ((PanasonicMakernoteDirectory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "ASCII").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Nullable
    private String getOnOffDescription(int n) {
        Integer n2 = ((PanasonicMakernoteDirectory)this._directory).getInteger(n);
        if (n2 == null) {
            return null;
        }
        switch (n2) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "On";
            }
        }
        return "Unknown (" + n2 + ")";
    }
}

