/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.Visitor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dominators {
    @NonNull
    public static Map<Instance, Instance> getDominatorMap(@NonNull Snapshot snapshot) {
        HashMap mDominatorMap = Maps.newHashMap();
        Map<Instance, Integer> topSort = TopologicalSortVisitor.getTopologicalSort(snapshot.getGCRoots());
        topSort.put(Snapshot.SENTINEL_ROOT, 0);
        HashSet roots = Sets.newHashSet((Object[])new Instance[]{Snapshot.SENTINEL_ROOT});
        for (RootObj root : snapshot.getGCRoots()) {
            Instance ref = root.getReferredInstance();
            if (ref == null) continue;
            mDominatorMap.put(ref, Snapshot.SENTINEL_ROOT);
            roots.add(ref);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Instance node : topSort.keySet()) {
                if (roots.contains(node)) continue;
                Instance dominator = null;
                for (Instance predecessor : node.getReferences()) {
                    if (mDominatorMap.get(predecessor) == null) continue;
                    if (dominator == null) {
                        dominator = predecessor;
                        continue;
                    }
                    Instance fingerA = dominator;
                    Instance fingerB = predecessor;
                    while (!fingerA.equals(fingerB)) {
                        if (topSort.get(fingerA) < topSort.get(fingerB)) {
                            fingerB = (Instance)mDominatorMap.get(fingerB);
                            continue;
                        }
                        fingerA = (Instance)mDominatorMap.get(fingerA);
                    }
                    dominator = fingerA;
                }
                if (mDominatorMap.get(node) == dominator) continue;
                mDominatorMap.put(node, dominator);
                changed = true;
            }
        }
        return ImmutableMap.copyOf((Map)mDominatorMap);
    }

    private static class TopologicalSortVisitor
    implements Visitor {
        private final Set<Instance> mVisited = Sets.newHashSet();
        private final List<Instance> mPostorder = Lists.newArrayList();

        private TopologicalSortVisitor() {
        }

        @Override
        public boolean visitEnter(Instance instance) {
            return this.mVisited.add(instance);
        }

        @Override
        public void visitLeave(Instance instance) {
            this.mPostorder.add(instance);
        }

        private Map<Instance, Integer> buildTopologicalSort() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            int currentIndex = 0;
            for (Instance node : Lists.reverse(this.mPostorder)) {
                result.put(node, ++currentIndex);
            }
            return result;
        }

        static Map<Instance, Integer> getTopologicalSort(Iterable<? extends Instance> roots) {
            TopologicalSortVisitor visitor = new TopologicalSortVisitor();
            for (Instance instance : roots) {
                instance.accept(visitor);
            }
            return visitor.buildTopologicalSort();
        }
    }
}

