/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

public class StackFrame {
    public static final int NO_LINE_NUMBER = 0;
    public static final int UNKNOWN_LOCATION = -1;
    public static final int COMPILED_METHOD = -2;
    public static final int NATIVE_METHOD = -3;
    long mId;
    String mMethodName;
    String mSignature;
    String mFilename;
    int mSerialNumber;
    int mLineNumber;

    public StackFrame(long id, String method, String sig, String file, int serial, int line) {
        this.mId = id;
        this.mMethodName = method;
        this.mSignature = sig;
        this.mFilename = file;
        this.mSerialNumber = serial;
        this.mLineNumber = line;
    }

    private final String lineNumberString() {
        switch (this.mLineNumber) {
            case 0: {
                return "No line number";
            }
            case -1: {
                return "Unknown line number";
            }
            case -2: {
                return "Compiled method";
            }
            case -3: {
                return "Native method";
            }
        }
        return String.valueOf(this.mLineNumber);
    }

    public final String toString() {
        return this.mMethodName + this.mSignature.replace('/', '.') + " - " + this.mFilename + ":" + this.lineNumberString();
    }
}

