/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.android.tools.perflib.heap.analysis.Dominators;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Snapshot {
    public static final Instance SENTINEL_ROOT = new RootObj(RootType.UNKNOWN);
    private static final int DEFAULT_HEAP_ID = 0;
    HashMap<Integer, Heap> mHeaps = new HashMap();
    Heap mCurrentHeap;
    private Map<Instance, Instance> mDominatorMap;

    public Snapshot() {
        this.setToDefaultHeap();
    }

    public Heap setToDefaultHeap() {
        return this.setHeapTo(0, "default");
    }

    public Heap setHeapTo(int id, String name) {
        Heap heap = this.mHeaps.get(id);
        if (heap == null) {
            heap = new Heap(name);
            heap.mSnapshot = this;
            this.mHeaps.put(id, heap);
        }
        this.mCurrentHeap = heap;
        return this.mCurrentHeap;
    }

    public Heap getHeap(int id) {
        return this.mHeaps.get(id);
    }

    public Collection<Heap> getHeaps() {
        return this.mHeaps.values();
    }

    public Heap getHeap(String name) {
        for (Heap heap : this.mHeaps.values()) {
            if (!heap.mName.equals(name)) continue;
            return heap;
        }
        return null;
    }

    public Iterable<RootObj> getGCRoots() {
        return this.mHeaps.get((Object)Integer.valueOf((int)0)).mRoots;
    }

    public final void addStackFrame(StackFrame theFrame) {
        this.mCurrentHeap.addStackFrame(theFrame);
    }

    public final StackFrame getStackFrame(long id) {
        return this.mCurrentHeap.getStackFrame(id);
    }

    public final void addStackTrace(StackTrace theTrace) {
        this.mCurrentHeap.addStackTrace(theTrace);
    }

    public final StackTrace getStackTrace(int traceSerialNumber) {
        return this.mCurrentHeap.getStackTrace(traceSerialNumber);
    }

    public final StackTrace getStackTraceAtDepth(int traceSerialNumber, int depth) {
        return this.mCurrentHeap.getStackTraceAtDepth(traceSerialNumber, depth);
    }

    public final void addRoot(RootObj root) {
        this.mCurrentHeap.addRoot(root);
        root.setHeap(this.mCurrentHeap);
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mCurrentHeap.addThread(thread, serialNumber);
    }

    public final ThreadObj getThread(int serialNumber) {
        return this.mCurrentHeap.getThread(serialNumber);
    }

    public final void addInstance(long id, Instance instance) {
        this.mCurrentHeap.addInstance(id, instance);
        instance.setHeap(this.mCurrentHeap);
    }

    public final void addClass(long id, ClassObj theClass) {
        this.mCurrentHeap.addClass(id, theClass);
        theClass.setHeap(this.mCurrentHeap);
    }

    public final Instance findReference(long id) {
        for (Heap heap : this.mHeaps.values()) {
            Instance instance = heap.getInstance(id);
            if (instance == null) continue;
            return instance;
        }
        return this.findClass(id);
    }

    public final ClassObj findClass(long id) {
        for (Heap heap : this.mHeaps.values()) {
            ClassObj theClass = heap.getClass(id);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    public final ClassObj findClass(String name) {
        for (Heap heap : this.mHeaps.values()) {
            ClassObj theClass = heap.getClass(name);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    public Map<Instance, Instance> computeDominatorMap() {
        if (this.mDominatorMap == null) {
            this.mDominatorMap = Dominators.getDominatorMap(this);
        }
        return this.mDominatorMap;
    }

    public void computeRetainedSizes() {
        for (Heap heap : this.mHeaps.values()) {
            for (Instance instance : Iterables.concat(heap.getClasses(), heap.getInstances())) {
                instance.setRetainedSize(instance.mHeap, instance.getSize());
            }
        }
        this.computeDominatorMap();
        for (Instance node : this.mDominatorMap.keySet()) {
            Instance dom = this.mDominatorMap.get(node);
            while (dom != SENTINEL_ROOT) {
                dom.setRetainedSize(node.mHeap, dom.getRetainedSize(node.mHeap) + (long)node.getSize());
                dom = this.mDominatorMap.get(dom);
            }
        }
    }

    public final void dumpInstanceCounts() {
        for (Heap heap : this.mHeaps.values()) {
            System.out.println("+------------------ instance counts for heap: " + heap.mName);
            heap.dumpInstanceCounts();
        }
    }

    public final void dumpSizes() {
        for (Heap heap : this.mHeaps.values()) {
            System.out.println("+------------------ sizes for heap: " + heap.mName);
            heap.dumpSizes();
        }
    }

    public final void dumpSubclasses() {
        for (Heap heap : this.mHeaps.values()) {
            System.out.println("+------------------ subclasses for heap: " + heap.mName);
            heap.dumpSubclasses();
        }
    }
}

