/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Queries {
    private static final String DEFAULT_PACKAGE = "<default>";

    public static Map<String, Set<ClassObj>> allClasses(Snapshot snapshot) {
        return Queries.classes(snapshot, null);
    }

    public static Map<String, Set<ClassObj>> classes(Snapshot snapshot, String[] excludedPrefixes) {
        TreeMap<String, Set<ClassObj>> result = new TreeMap<String, Set<ClassObj>>();
        TreeSet<ClassObj> classes = new TreeSet<ClassObj>();
        for (Heap heap : snapshot.mHeaps.values()) {
            classes.addAll(heap.mClassesById.values());
        }
        if (excludedPrefixes != null) {
            int N = excludedPrefixes.length;
            Iterator iter = classes.iterator();
            block1: while (iter.hasNext()) {
                ClassObj theClass = (ClassObj)iter.next();
                String classPath = theClass.toString();
                for (int i = 0; i < N; ++i) {
                    if (!classPath.startsWith(excludedPrefixes[i])) continue;
                    iter.remove();
                    continue block1;
                }
            }
        }
        for (ClassObj theClass : classes) {
            Set<ClassObj> classSet;
            String packageName = DEFAULT_PACKAGE;
            int lastDot = theClass.mClassName.lastIndexOf(46);
            if (lastDot != -1) {
                packageName = theClass.mClassName.substring(0, lastDot);
            }
            if ((classSet = result.get(packageName)) == null) {
                classSet = new TreeSet<ClassObj>();
                result.put(packageName, classSet);
            }
            classSet.add(theClass);
        }
        return result;
    }

    public static ClassObj findClass(Snapshot snapshot, String name) {
        return snapshot.findClass(name);
    }

    public static Instance[] instancesOf(Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        Instance[] instances = new Instance[theClass.mInstances.size()];
        return theClass.mInstances.toArray(instances);
    }

    public static Instance[] allInstancesOf(Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        ArrayList<ClassObj> classList = new ArrayList<ClassObj>();
        classList.add(theClass);
        classList.addAll(Queries.traverseSubclasses(theClass));
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (ClassObj someClass : classList) {
            instanceList.addAll(someClass.mInstances);
        }
        Instance[] result = new Instance[instanceList.size()];
        instanceList.toArray(result);
        return result;
    }

    private static ArrayList<ClassObj> traverseSubclasses(ClassObj base) {
        ArrayList<ClassObj> result = new ArrayList<ClassObj>();
        for (ClassObj subclass : base.mSubclasses) {
            result.add(subclass);
            result.addAll(Queries.traverseSubclasses(subclass));
        }
        return result;
    }

    public static Instance findObject(Snapshot snapshot, String id) {
        long id2 = Long.parseLong(id, 16);
        return snapshot.findReference(id2);
    }

    public static Collection<RootObj> getRoots(Snapshot snapshot) {
        HashSet<RootObj> result = new HashSet<RootObj>();
        for (Heap heap : snapshot.mHeaps.values()) {
            result.addAll(heap.mRoots);
        }
        return result;
    }

    public static final Instance[] newInstances(Snapshot older, Snapshot newer) {
        ArrayList<Instance> resultList = new ArrayList<Instance>();
        for (Heap newHeap : newer.mHeaps.values()) {
            Heap oldHeap = older.getHeap(newHeap.mName);
            if (oldHeap == null) continue;
            for (Instance instance : newHeap.getInstances()) {
                Instance oldInstance = oldHeap.getInstance(instance.mId);
                if (oldInstance != null && instance.getClassObj() == oldInstance.getClassObj()) continue;
                resultList.add(instance);
            }
        }
        Instance[] resultArray = new Instance[resultList.size()];
        return resultList.toArray(resultArray);
    }
}

