/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.HprofParser;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Queries;
import com.android.tools.perflib.heap.Snapshot;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Set;

public class Main {
    public static void main(String[] argv) {
        try {
            FileInputStream fis = new FileInputStream(argv[0]);
            BufferedInputStream bis = new BufferedInputStream(fis);
            DataInputStream dis = new DataInputStream(bis);
            Snapshot snapshot = new HprofParser(dis).parse();
            dis.close();
            Main.testClassesQuery(snapshot);
            Main.testAllClassesQuery(snapshot);
            Main.testFindInstancesOf(snapshot);
            Main.testFindAllInstancesOf(snapshot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testClassesQuery(Snapshot snapshot) {
        String[] x = new String[]{"char[", "javax.", "org.xml.sax"};
        Map<String, Set<ClassObj>> someClasses = Queries.classes(snapshot, x);
        for (String thePackage : someClasses.keySet()) {
            System.out.println("------------------- " + thePackage);
            Set<ClassObj> classes = someClasses.get(thePackage);
            for (ClassObj theClass : classes) {
                System.out.println("     " + theClass.mClassName);
            }
        }
    }

    private static void testAllClassesQuery(Snapshot snapshot) {
        Map<String, Set<ClassObj>> allClasses = Queries.allClasses(snapshot);
        for (String thePackage : allClasses.keySet()) {
            System.out.println("------------------- " + thePackage);
            Set<ClassObj> classes = allClasses.get(thePackage);
            for (ClassObj theClass : classes) {
                System.out.println("     " + theClass.mClassName);
            }
        }
    }

    private static void testFindInstancesOf(Snapshot snapshot) {
        Instance[] instances = Queries.instancesOf(snapshot, "java.lang.String");
        System.out.println("There are " + instances.length + " Strings.");
    }

    private static void testFindAllInstancesOf(Snapshot snapshot) {
        Instance[] instances = Queries.allInstancesOf(snapshot, "android.graphics.drawable.Drawable");
        System.out.println("There are " + instances.length + " instances of Drawables and its subclasses.");
    }
}

