/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Value;
import com.google.common.primitives.UnsignedInts;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;

public class HprofParser {
    private static final int STRING_IN_UTF8 = 1;
    private static final int LOAD_CLASS = 2;
    private static final int UNLOAD_CLASS = 3;
    private static final int STACK_FRAME = 4;
    private static final int STACK_TRACE = 5;
    private static final int ALLOC_SITES = 6;
    private static final int HEAP_SUMMARY = 7;
    private static final int START_THREAD = 10;
    private static final int END_THREAD = 11;
    private static final int HEAP_DUMP = 12;
    private static final int HEAP_DUMP_SEGMENT = 28;
    private static final int HEAP_DUMP_END = 44;
    private static final int CPU_SAMPLES = 13;
    private static final int CONTROL_SETTINGS = 14;
    private static final int ROOT_UNKNOWN = 255;
    private static final int ROOT_JNI_GLOBAL = 1;
    private static final int ROOT_JNI_LOCAL = 2;
    private static final int ROOT_JAVA_FRAME = 3;
    private static final int ROOT_NATIVE_STACK = 4;
    private static final int ROOT_STICKY_CLASS = 5;
    private static final int ROOT_THREAD_BLOCK = 6;
    private static final int ROOT_MONITOR_USED = 7;
    private static final int ROOT_THREAD_OBJECT = 8;
    private static final int ROOT_CLASS_DUMP = 32;
    private static final int ROOT_INSTANCE_DUMP = 33;
    private static final int ROOT_OBJECT_ARRAY_DUMP = 34;
    private static final int ROOT_PRIMITIVE_ARRAY_DUMP = 35;
    private static final int ROOT_HEAP_DUMP_INFO = 254;
    private static final int ROOT_INTERNED_STRING = 137;
    private static final int ROOT_FINALIZING = 138;
    private static final int ROOT_DEBUGGER = 139;
    private static final int ROOT_REFERENCE_CLEANUP = 140;
    private static final int ROOT_VM_INTERNAL = 141;
    private static final int ROOT_JNI_MONITOR = 142;
    private static final int ROOT_UNREACHABLE = 144;
    private static final int ROOT_PRIMITIVE_ARRAY_NODATA = 195;
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final PriorityQueue<PostOperation> mPost = new PriorityQueue();
    DataInputStream mInput;
    int mIdSize;
    Snapshot mSnapshot;
    HashMap<Long, String> mStrings = new HashMap();
    HashMap<Long, String> mClassNames = new HashMap();

    public HprofParser(DataInputStream in) {
        this.mInput = in;
    }

    public final Snapshot parse() {
        Snapshot snapshot;
        this.mSnapshot = snapshot = new Snapshot();
        try {
            try {
                String s = this.readNullTerminatedString();
                DataInputStream in = this.mInput;
                this.mIdSize = in.readInt();
                Type.setIdSize(this.mIdSize);
                in.readLong();
                block12: while (true) {
                    int tag = in.readUnsignedByte();
                    in.readInt();
                    int length = in.readInt();
                    switch (tag) {
                        case 1: {
                            this.loadString(length - 4);
                            continue block12;
                        }
                        case 2: {
                            this.loadClass();
                            continue block12;
                        }
                        case 4: {
                            this.loadStackFrame();
                            continue block12;
                        }
                        case 5: {
                            this.loadStackTrace();
                            continue block12;
                        }
                        case 12: {
                            this.loadHeapDump(length);
                            this.mSnapshot.setToDefaultHeap();
                            continue block12;
                        }
                        case 28: {
                            this.loadHeapDump(length);
                            this.mSnapshot.setToDefaultHeap();
                            continue block12;
                        }
                    }
                    this.skipFully(length);
                }
            }
            catch (EOFException eof) {
                PostOperation post = this.mPost.poll();
                while (post != null) {
                    post.mCall.call();
                    post = this.mPost.poll();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return snapshot;
    }

    private String readNullTerminatedString() throws IOException {
        StringBuilder s = new StringBuilder();
        DataInputStream in = this.mInput;
        int c = in.read();
        while (c != 0) {
            s.append((char)c);
            c = in.read();
        }
        return s.toString();
    }

    private long readId() throws IOException {
        return this.readId(this.mInput);
    }

    private long readId(DataInputStream stream) throws IOException {
        switch (this.mIdSize) {
            case 1: {
                return stream.readUnsignedByte();
            }
            case 2: {
                return stream.readUnsignedShort();
            }
            case 4: {
                return UnsignedInts.toLong((int)stream.readInt());
            }
            case 8: {
                return stream.readLong();
            }
        }
        throw new IllegalArgumentException("ID Length must be 1, 2, 4, or 8");
    }

    private String readUTF8(int length) throws IOException {
        byte[] b = new byte[length];
        this.mInput.read(b);
        return new String(b, "utf-8");
    }

    private void loadString(int length) throws IOException {
        long id = this.readId();
        String string = this.readUTF8(length);
        this.mStrings.put(id, string);
    }

    private void loadClass() throws IOException {
        DataInputStream in = this.mInput;
        in.readInt();
        long id = this.readId();
        in.readInt();
        String name = this.mStrings.get(this.readId());
        this.mClassNames.put(id, name);
    }

    private void loadStackFrame() throws IOException {
        long id = this.readId();
        String methodName = this.mStrings.get(this.readId());
        String methodSignature = this.mStrings.get(this.readId());
        String sourceFile = this.mStrings.get(this.readId());
        int serial = this.mInput.readInt();
        int lineNumber = this.mInput.readInt();
        StackFrame frame = new StackFrame(id, methodName, methodSignature, sourceFile, serial, lineNumber);
        this.mSnapshot.addStackFrame(frame);
    }

    private void loadStackTrace() throws IOException {
        int serialNumber = this.mInput.readInt();
        int threadSerialNumber = this.mInput.readInt();
        int numFrames = this.mInput.readInt();
        StackFrame[] frames = new StackFrame[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            frames[i] = this.mSnapshot.getStackFrame(this.readId());
        }
        StackTrace trace = new StackTrace(serialNumber, threadSerialNumber, frames);
        this.mSnapshot.addStackTrace(trace);
    }

    private void loadHeapDump(int length) throws IOException {
        DataInputStream in = this.mInput;
        block24: while (length > 0) {
            int tag = in.readUnsignedByte();
            --length;
            switch (tag) {
                case 255: {
                    length -= this.loadBasicObj(RootType.UNKNOWN);
                    continue block24;
                }
                case 1: {
                    length -= this.loadBasicObj(RootType.NATIVE_STATIC);
                    this.readId();
                    length -= this.mIdSize;
                    continue block24;
                }
                case 2: {
                    length -= this.loadJniLocal();
                    continue block24;
                }
                case 3: {
                    length -= this.loadJavaFrame();
                    continue block24;
                }
                case 4: {
                    length -= this.loadNativeStack();
                    continue block24;
                }
                case 5: {
                    length -= this.loadBasicObj(RootType.SYSTEM_CLASS);
                    continue block24;
                }
                case 6: {
                    length -= this.loadThreadBlock();
                    continue block24;
                }
                case 7: {
                    length -= this.loadBasicObj(RootType.BUSY_MONITOR);
                    continue block24;
                }
                case 8: {
                    length -= this.loadThreadObject();
                    continue block24;
                }
                case 32: {
                    length -= this.loadClassDump();
                    continue block24;
                }
                case 33: {
                    length -= this.loadInstanceDump();
                    continue block24;
                }
                case 34: {
                    length -= this.loadObjectArrayDump();
                    continue block24;
                }
                case 35: {
                    length -= this.loadPrimitiveArrayDump();
                    continue block24;
                }
                case 195: {
                    System.err.println("+--- PRIMITIVE ARRAY NODATA DUMP");
                    length -= this.loadPrimitiveArrayDump();
                    throw new IllegalArgumentException("Don't know how to load a nodata array");
                }
                case 254: {
                    int heapId = this.mInput.readInt();
                    long heapNameId = this.readId();
                    String heapName = this.mStrings.get(heapNameId);
                    this.mSnapshot.setHeapTo(heapId, heapName);
                    length -= 4 + this.mIdSize;
                    continue block24;
                }
                case 137: {
                    length -= this.loadBasicObj(RootType.INTERNED_STRING);
                    continue block24;
                }
                case 138: {
                    length -= this.loadBasicObj(RootType.FINALIZING);
                    continue block24;
                }
                case 139: {
                    length -= this.loadBasicObj(RootType.DEBUGGER);
                    continue block24;
                }
                case 140: {
                    length -= this.loadBasicObj(RootType.REFERENCE_CLEANUP);
                    continue block24;
                }
                case 141: {
                    length -= this.loadBasicObj(RootType.VM_INTERNAL);
                    continue block24;
                }
                case 142: {
                    length -= this.loadJniMonitor();
                    continue block24;
                }
                case 144: {
                    length -= this.loadBasicObj(RootType.UNREACHABLE);
                    continue block24;
                }
            }
            throw new IllegalArgumentException("loadHeapDump loop with unknown tag " + tag + " with " + this.mInput.available() + " bytes possibly remaining");
        }
    }

    private int loadJniLocal() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackFrameNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTraceAtDepth(thread.mStackTrace, stackFrameNumber);
        RootObj root = new RootObj(RootType.NATIVE_LOCAL, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4 + 4;
    }

    private int loadJavaFrame() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackFrameNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTraceAtDepth(thread.mStackTrace, stackFrameNumber);
        RootObj root = new RootObj(RootType.JAVA_LOCAL, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4 + 4;
    }

    private int loadNativeStack() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTrace(thread.mStackTrace);
        RootObj root = new RootObj(RootType.NATIVE_STACK, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4;
    }

    private int loadBasicObj(RootType type) throws IOException {
        long id = this.readId();
        RootObj root = new RootObj(type, id);
        this.mSnapshot.addRoot(root);
        return this.mIdSize;
    }

    private int loadThreadBlock() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace stack = this.mSnapshot.getStackTrace(thread.mStackTrace);
        RootObj root = new RootObj(RootType.THREAD_BLOCK, id, threadSerialNumber, stack);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4;
    }

    private int loadThreadObject() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackSerialNumber = this.mInput.readInt();
        ThreadObj thread = new ThreadObj(id, stackSerialNumber);
        this.mSnapshot.addThread(thread, threadSerialNumber);
        return this.mIdSize + 4 + 4;
    }

    private int loadClassDump() throws IOException {
        int i;
        DataInputStream in = this.mInput;
        long id = this.readId();
        int stackSerialNumber = in.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackSerialNumber);
        final long superClassId = this.readId();
        this.readId();
        this.readId();
        this.readId();
        this.readId();
        this.readId();
        int instanceSize = in.readInt();
        final ClassObj theClass = new ClassObj(id, stack, this.mClassNames.get(id));
        int bytesRead = 7 * this.mIdSize + 4 + 4;
        int numEntries = in.readUnsignedShort();
        bytesRead += 2;
        for (i = 0; i < numEntries; ++i) {
            in.readUnsignedShort();
            bytesRead += 2 + this.skipValue();
        }
        numEntries = in.readUnsignedShort();
        bytesRead += 2;
        for (i = 0; i < numEntries; ++i) {
            String name = this.mStrings.get(this.readId());
            Type type = Type.getType(in.readByte());
            Value value = this.readValue(theClass, type);
            theClass.addStaticField(type, name, value);
            bytesRead += this.mIdSize + 1 + type.getSize();
        }
        numEntries = in.readUnsignedShort();
        bytesRead += 2;
        Field[] fields = new Field[numEntries];
        for (int i2 = 0; i2 < numEntries; ++i2) {
            String name = this.mStrings.get(this.readId());
            Type type = Type.getType(in.readUnsignedByte());
            fields[i2] = new Field(type, name);
            bytesRead += this.mIdSize + 1;
        }
        theClass.setFields(fields);
        theClass.setInstanceSize(instanceSize);
        this.mSnapshot.addClass(id, theClass);
        if (superClassId > 0L) {
            this.mPost.add(new PostOperation(ResolvePriority.CLASSES, new Callable(){

                public Object call() throws Exception {
                    theClass.setSuperClass(HprofParser.this.mSnapshot.findClass(superClassId));
                    return null;
                }
            }));
        }
        this.mPost.add(new PostOperation(ResolvePriority.CLASSES, new Callable(){

            public Object call() throws Exception {
                int classSize = HprofParser.this.mSnapshot.findClass(HprofParser.JAVA_LANG_CLASS).getInstanceSize();
                for (Field f : theClass.mStaticFields.keySet()) {
                    classSize += f.getType().getSize();
                }
                theClass.setSize(classSize);
                return null;
            }
        }));
        return bytesRead;
    }

    private Value readValue(Instance instance, Type type) throws IOException {
        return this.readValue(this.mInput, instance, type);
    }

    private Value readValue(DataInputStream stream, Instance instance, Type type) throws IOException {
        final Value value = new Value(instance);
        switch (type) {
            case OBJECT: {
                final long id = this.readId(stream);
                this.mPost.add(new PostOperation(ResolvePriority.INSTANCES, new Callable(){

                    public Object call() throws Exception {
                        value.setValue(HprofParser.this.mSnapshot.findReference(id));
                        return null;
                    }
                }));
                break;
            }
            case BOOLEAN: {
                value.setValue(stream.readBoolean());
                break;
            }
            case CHAR: {
                value.setValue(Character.valueOf(stream.readChar()));
                break;
            }
            case FLOAT: {
                value.setValue(Float.valueOf(stream.readFloat()));
                break;
            }
            case DOUBLE: {
                value.setValue(stream.readDouble());
                break;
            }
            case BYTE: {
                value.setValue(stream.readByte());
                break;
            }
            case SHORT: {
                value.setValue(stream.readShort());
                break;
            }
            case INT: {
                value.setValue(stream.readInt());
                break;
            }
            case LONG: {
                value.setValue(stream.readLong());
            }
        }
        return value;
    }

    private int loadInstanceDump() throws IOException {
        long id = this.readId();
        int stackId = this.mInput.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackId);
        final long classId = this.readId();
        int remaining = this.mInput.readInt();
        final ClassInstance instance = new ClassInstance(id, stack);
        final byte[] data = new byte[remaining];
        this.mInput.readFully(data);
        this.mPost.add(new PostOperation(ResolvePriority.CLASSES, new Callable(){

            public Void call() throws Exception {
                instance.setClass(HprofParser.this.mSnapshot.findClass(classId));
                return null;
            }
        }));
        this.mPost.add(new PostOperation(ResolvePriority.VALUES, new Callable(){

            public Void call() throws Exception {
                DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data));
                for (ClassObj clazz = instance.getClassObj(); clazz != null; clazz = clazz.getSuperClassObj()) {
                    for (Field field : clazz.getFields()) {
                        instance.addField(field, HprofParser.this.readValue(stream, instance, field.getType()));
                    }
                }
                return null;
            }
        }));
        this.mSnapshot.addInstance(id, instance);
        return this.mIdSize + 4 + this.mIdSize + 4 + remaining;
    }

    private int loadObjectArrayDump() throws IOException {
        long id = this.readId();
        int stackId = this.mInput.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackId);
        int numElements = this.mInput.readInt();
        final long classId = this.readId();
        int totalBytes = numElements * this.mIdSize;
        Value[] values = new Value[numElements];
        String className = this.mClassNames.get(classId);
        final ArrayInstance array = new ArrayInstance(id, stack, Type.OBJECT);
        for (int i = 0; i < numElements; ++i) {
            values[i] = this.readValue(array, Type.OBJECT);
        }
        array.setValues(values);
        this.mPost.add(new PostOperation(ResolvePriority.CLASSES, new Callable(){

            public Object call() throws Exception {
                array.setClass(HprofParser.this.mSnapshot.findClass(classId));
                return null;
            }
        }));
        this.mSnapshot.addInstance(id, array);
        return this.mIdSize + 4 + 4 + this.mIdSize + totalBytes;
    }

    private int loadPrimitiveArrayDump() throws IOException {
        long id = this.readId();
        int stackId = this.mInput.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackId);
        int numElements = this.mInput.readInt();
        Type type = Type.getType(this.mInput.readUnsignedByte());
        int size = type.getSize();
        Value[] values = new Value[numElements];
        ArrayInstance array = new ArrayInstance(id, stack, type);
        for (int i = 0; i < numElements; ++i) {
            values[i] = this.readValue(array, type);
        }
        array.setValues(values);
        this.mSnapshot.addInstance(id, array);
        return this.mIdSize + 4 + 4 + 1 + numElements * size;
    }

    private int loadJniMonitor() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackDepth = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTraceAtDepth(thread.mStackTrace, stackDepth);
        RootObj root = new RootObj(RootType.NATIVE_MONITOR, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4 + 4;
    }

    private int skipValue() throws IOException {
        Type type = Type.getType(this.mInput.readUnsignedByte());
        int size = type.getSize();
        this.skipFully(size);
        return size + 1;
    }

    private void skipFully(long numBytes) throws IOException {
        while (numBytes > 0L) {
            long skipped = this.mInput.skip(numBytes);
            numBytes -= skipped;
        }
    }

    static class PostOperation
    implements Comparable<PostOperation> {
        ResolvePriority mPriority;
        Callable mCall;

        PostOperation(ResolvePriority priority, Callable call) {
            this.mPriority = priority;
            this.mCall = call;
        }

        @Override
        public int compareTo(PostOperation other) {
            return this.mPriority.compareTo(other.mPriority);
        }
    }

    static enum ResolvePriority {
        CLASSES,
        VALUES,
        INSTANCES;

    }
}

