/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Value;
import com.android.tools.perflib.heap.Visitor;

public class ArrayInstance
extends Instance {
    private Type mType;
    private Value[] mValues;

    public ArrayInstance(long id, StackTrace stack, Type type) {
        this.mId = id;
        this.mStack = stack;
        this.mType = type;
    }

    public void setValues(Value[] values) {
        this.mValues = values;
    }

    public Value[] getValues() {
        return this.mValues;
    }

    @Override
    public final int getSize() {
        return this.mValues.length * this.mType.getSize();
    }

    @Override
    public final void accept(Visitor visitor) {
        if (this.mType != Type.OBJECT) {
            return;
        }
        if (visitor.visitEnter(this)) {
            for (Value value : this.mValues) {
                if (!(value.getValue() instanceof Instance)) continue;
                ((Instance)value.getValue()).accept(visitor);
            }
            visitor.visitLeave(this);
        }
    }

    public final String toString() {
        return String.format("%s[%d]@0x%08x", this.mType.name(), this.mValues.length, this.mId);
    }
}

