/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class AddJavascriptInterfaceDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("AddJavascriptInterface", "addJavascriptInterface Called", "Checks that `WebView#addJavascriptInterface` is not called for API levels below 17", "For applications built for API levels below 17, `WebView#addJavascriptInterface` presents a security hazard as JavaScript on the target web page has the ability to use reflection to access the injected object's public fields and thus manipulate the host application in unintended ways.", Category.SECURITY, 9, Severity.WARNING, new Implementation(AddJavascriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://labs.mwrinfosecurity.com/blog/2013/09/24/webview-addjavascriptinterface-remote-code-execution/");
    private static final String WEB_VIEW = "android.webkit.WebView";
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(ADD_JAVASCRIPT_INTERFACE);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        if (context.getMainProject().getMinSdk() >= 17) {
            return;
        }
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        if (!method.getContainingClass().isSubclassOf(WEB_VIEW, false)) {
            return;
        }
        if (method.getArgumentCount() != 2 || !method.getArgumentType(0).matchesName("java.lang.Object") || !method.getArgumentType(1).matchesName("java.lang.String")) {
            return;
        }
        String message = "WebView.addJavascriptInterface should not be called with minSdkVersion < 17 for security reasons: JavaScript can use reflection to manipulate application";
        context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message, null);
    }
}

