/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Device;
import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GetPropReceiver
extends MultiLineReceiver {
    static final String GETPROP_COMMAND = "getprop";
    private static final Pattern GETPROP_PATTERN = Pattern.compile("^\\[([^]]+)\\]\\:\\s*\\[(.*)\\]$");
    private Device mDevice = null;

    public GetPropReceiver(Device device) {
        this.mDevice = device;
    }

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            Matcher m;
            if (line.isEmpty() || line.startsWith("#") || !(m = GETPROP_PATTERN.matcher(line)).matches()) continue;
            String label = m.group(1);
            String value = m.group(2);
            if (label.isEmpty()) continue;
            this.mDevice.addProperty(label, value);
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void done() {
        this.mDevice.update(4);
    }
}

