/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeQuickFix
implements LocalQuickFix,
I18nQuickFixHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeQuickFix");
    private TextRange mySelectionRange;

    public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/i18n/I18nizeQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/i18n/I18nizeQuickFix", "applyFix"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                I18nizeQuickFix.this.doFix(descriptor, project);
            }
        });
    }

    @NotNull
    public String getName() {
        String string = CodeInsightBundle.message((String)"inspection.i18n.quickfix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/I18nizeQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/I18nizeQuickFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        PsiLiteralExpression literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        if (literalExpression != null) {
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                return;
            }
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            TextRange textRange = literalExpression.getTextRange();
            if (textRange.contains(start) && textRange.contains(end)) {
                this.mySelectionRange = new TextRange(start, end);
                return;
            }
        }
        String message = CodeInsightBundle.message((String)"i18nize.error.message", (Object[])new Object[0]);
        throw new IncorrectOperationException(message);
    }

    @Override
    public void performI18nization(PsiFile psiFile, Editor editor, PsiLiteralExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, PsiExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
        Project project = psiFile.getProject();
        propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
        try {
            PsiElement newExpression = this.doReplacementInJava(psiFile, editor, literalExpression, i18nizedText);
            I18nizeQuickFix.reformatAndCorrectReferences(newExpression);
        }
        catch (IncorrectOperationException e) {
            Messages.showErrorDialog((Project)project, (String)CodeInsightBundle.message((String)"inspection.i18n.expression.is.invalid.error.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"inspection.error.dialog.title", (Object[])new Object[0]));
        }
    }

    @Override
    public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
        PsiLiteralExpression literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        return this.createDialog(project, psiFile, literalExpression);
    }

    private void doFix(ProblemDescriptor descriptor, Project project) {
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)descriptor.getPsiElement();
        final PsiFile psiFile = literalExpression.getContainingFile();
        if (!JavaI18nizeQuickFixDialog.isAvailable(psiFile)) {
            return;
        }
        final JavaI18nizeQuickFixDialog dialog = this.createDialog(project, psiFile, literalExpression);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        final Collection propertiesFiles = dialog.getAllPropertiesFiles();
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)literalExpression)) {
            return;
        }
        for (PropertiesFile file : propertiesFiles) {
            if (file.findPropertyByKey(dialog.getKey()) != null || FileModificationService.getInstance().prepareFileForWrite(file.getContainingFile())) continue;
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            I18nizeQuickFix.this.performI18nization(psiFile, PsiUtilBase.findEditor((PsiElement)psiFile), dialog.getLiteralExpression(), propertiesFiles, dialog.getKey(), dialog.getValue(), dialog.getI18nizedText(), dialog.getParameters(), dialog.getPropertyCreationHandler());
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, CodeInsightBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
    }

    protected PsiElement doReplacementInJava(@NotNull PsiFile psiFile, Editor editor, PsiLiteralExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/i18n/I18nizeQuickFix", "doReplacementInJava"));
        }
        return this.replaceStringLiteral(literalExpression, i18nizedText);
    }

    private static void reformatAndCorrectReferences(PsiElement newExpression) throws IncorrectOperationException {
        Project project = newExpression.getProject();
        newExpression = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newExpression);
        CodeStyleManager.getInstance((Project)project).reformat(newExpression);
    }

    protected JavaI18nizeQuickFixDialog createDialog(Project project, PsiFile context, PsiLiteralExpression literalExpression) {
        String value = (String)literalExpression.getValue();
        if (this.mySelectionRange != null) {
            TextRange literalRange = literalExpression.getTextRange();
            TextRange intersection = literalRange.intersection(this.mySelectionRange);
            value = literalExpression.getText().substring(intersection.getStartOffset() - literalRange.getStartOffset(), intersection.getEndOffset() - literalRange.getStartOffset());
        }
        value = StringUtil.escapeStringCharacters((String)value);
        return new JavaI18nizeQuickFixDialog(project, context, literalExpression, value, null, true, true);
    }

    @Nullable
    private static PsiBinaryExpression breakStringLiteral(PsiLiteralExpression literalExpression, int offset) throws IncorrectOperationException {
        TextRange literalRange = literalExpression.getTextRange();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)literalExpression.getProject()).getElementFactory();
        if (literalRange.getStartOffset() + 1 < offset && offset < literalRange.getEndOffset() - 1) {
            PsiBinaryExpression expression = (PsiBinaryExpression)factory.createExpressionFromText("a + b", (PsiElement)literalExpression);
            String value = (String)literalExpression.getValue();
            int breakIndex = offset - literalRange.getStartOffset() - 1;
            String lsubstring = value.substring(0, breakIndex);
            expression.getLOperand().replace((PsiElement)factory.createExpressionFromText("\"" + lsubstring + "\"", (PsiElement)literalExpression));
            String rsubstring = value.substring(breakIndex);
            expression.getROperand().replace((PsiElement)factory.createExpressionFromText("\"" + rsubstring + "\"", (PsiElement)literalExpression));
            return (PsiBinaryExpression)literalExpression.replace((PsiElement)expression);
        }
        return null;
    }

    private PsiElement replaceStringLiteral(PsiLiteralExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)literalExpression.getProject()).getElementFactory();
        if (this.mySelectionRange != null) {
            try {
                PsiBinaryExpression binaryExpression = I18nizeQuickFix.breakStringLiteral(literalExpression, this.mySelectionRange.getEndOffset());
                if (binaryExpression != null) {
                    literalExpression = (PsiLiteralExpression)binaryExpression.getLOperand();
                }
                if ((binaryExpression = I18nizeQuickFix.breakStringLiteral(literalExpression, this.mySelectionRange.getStartOffset())) != null) {
                    literalExpression = (PsiLiteralExpression)binaryExpression.getROperand();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        PsiExpression expression = factory.createExpressionFromText(i18nizedText, (PsiElement)literalExpression);
        return literalExpression.replace((PsiElement)expression);
    }
}

