/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.Convertor;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.ui.GithubBasicLoginDialog;
import org.jetbrains.plugins.github.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

public class GithubUtil {
    public static final Logger LOG = Logger.getInstance((String)"github");

    @NotNull
    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull ThrowableConvertor<GithubAuthData, T, IOException> task) throws IOException {
        Object object;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        try {
            object = task.convert((Object)auth);
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            T t = GithubUtil.runTask(project, authHolder, indicator, task);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
            }
            return t;
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, auth);
            T t = GithubUtil.runTask(project, authHolder, indicator, task);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
            }
            return t;
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        return (T)object;
    }

    public static void runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull ThrowableConsumer<GithubAuthData, IOException> task) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        try {
            task.consume((Object)auth);
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            GithubUtil.runTask(project, authHolder, indicator, task);
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, auth);
            GithubUtil.runTask(project, authHolder, indicator, task);
        }
    }

    @NotNull
    public static <T> T runTaskWithBasicAuthForHost(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull String host, @NotNull ThrowableConvertor<GithubAuthData, T, IOException> task) throws IOException {
        Object object;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        try {
            if (auth.getAuthType() != GithubAuthData.AuthType.BASIC) {
                throw new GithubAuthenticationException("Expected basic authentication");
            }
            object = task.convert((Object)auth);
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            T t = GithubUtil.runTaskWithBasicAuthForHost(project, authHolder, indicator, host, task);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
            }
            return t;
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidBasicAuthDataForHost(project, authHolder, indicator, auth, host);
            T t = GithubUtil.runTaskWithBasicAuthForHost(project, authHolder, indicator, host, task);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
            }
            return t;
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "runTaskWithBasicAuthForHost"));
        }
        return (T)object;
    }

    @NotNull
    private static GithubUserDetailed testConnection(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        GithubUserDetailed githubUserDetailed;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        try {
            githubUserDetailed = GithubApiUtil.getCurrentUserDetailed(auth);
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            GithubUserDetailed githubUserDetailed2 = GithubUtil.testConnection(project, authHolder, indicator);
            if (githubUserDetailed2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
            }
            return githubUserDetailed2;
        }
        if (githubUserDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        return githubUserDetailed;
    }

    public static void getValidAuthData(final @NotNull Project project, @NotNull GithubAuthDataHolder authHolder, final @NotNull ProgressIndicator indicator, final @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        if (oldAuth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        authHolder.runTransaction(oldAuth, new ThrowableComputable<GithubAuthData, GithubOperationCanceledException>(){

            @NotNull
            public GithubAuthData compute() throws GithubOperationCanceledException {
                final GithubLoginDialog dialog = new GithubLoginDialog(project, oldAuth);
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DialogManager.show((DialogWrapper)dialog);
                    }
                }, indicator.getModalityState());
                if (!dialog.isOK()) {
                    throw new GithubOperationCanceledException("Can't get valid credentials");
                }
                GithubAuthData authData = dialog.getAuthData();
                GithubSettings.getInstance().setAuthData(authData, dialog.isSavePasswordSelected());
                GithubAuthData githubAuthData = authData;
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil$1", "compute"));
                }
                return githubAuthData;
            }
        });
    }

    public static void getValidBasicAuthDataForHost(final @NotNull Project project, @NotNull GithubAuthDataHolder authHolder, final @NotNull ProgressIndicator indicator, final @NotNull GithubAuthData oldAuth, final @NotNull String host) throws GithubOperationCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "getValidBasicAuthDataForHost"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "getValidBasicAuthDataForHost"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "getValidBasicAuthDataForHost"));
        }
        if (oldAuth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubUtil", "getValidBasicAuthDataForHost"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/util/GithubUtil", "getValidBasicAuthDataForHost"));
        }
        authHolder.runTransaction(oldAuth, new ThrowableComputable<GithubAuthData, GithubOperationCanceledException>(){

            @NotNull
            public GithubAuthData compute() throws GithubOperationCanceledException {
                final GithubBasicLoginDialog dialog = new GithubBasicLoginDialog(project, oldAuth, host);
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DialogManager.show((DialogWrapper)dialog);
                    }
                }, indicator.getModalityState());
                if (!dialog.isOK()) {
                    throw new GithubOperationCanceledException("Can't get valid credentials");
                }
                GithubAuthData authData = dialog.getAuthData();
                GithubSettings settings = GithubSettings.getInstance();
                if (settings.getAuthType() != GithubAuthData.AuthType.TOKEN) {
                    GithubSettings.getInstance().setAuthData(authData, dialog.isSavePasswordSelected());
                }
                GithubAuthData githubAuthData = authData;
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil$2", "compute"));
                }
                return githubAuthData;
            }
        });
    }

    private static void getTwoFactorAuthData(final @NotNull Project project, final @NotNull GithubAuthDataHolder authHolder, final @NotNull ProgressIndicator indicator, final @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        if (oldAuth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        authHolder.runTransaction(oldAuth, new ThrowableComputable<GithubAuthData, GithubOperationCanceledException>(){

            @NotNull
            public GithubAuthData compute() throws GithubOperationCanceledException {
                if (authHolder.getAuthData().getAuthType() != GithubAuthData.AuthType.BASIC) {
                    throw new GithubOperationCanceledException("Two factor authentication can be used only with Login/Password");
                }
                GithubApiUtil.askForTwoFactorCodeSMS(oldAuth);
                final Ref codeRef = new Ref();
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        codeRef.set((Object)Messages.showInputDialog((Project)project, (String)"Authentication Code", (String)"Github Two-Factor Authentication", null));
                    }
                }, indicator.getModalityState());
                if (codeRef.isNull()) {
                    throw new GithubOperationCanceledException("Can't get two factor authentication code");
                }
                GithubSettings settings = GithubSettings.getInstance();
                if (settings.getAuthType() == GithubAuthData.AuthType.BASIC && StringUtil.equalsIgnoreCase((CharSequence)settings.getLogin(), (CharSequence)oldAuth.getBasicAuth().getLogin())) {
                    settings.setValidGitAuth(false);
                }
                GithubAuthData githubAuthData = oldAuth.copyWithTwoFactorCode((String)codeRef.get());
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil$3", "compute"));
                }
                return githubAuthData;
            }
        });
    }

    @NotNull
    public static GithubAuthDataHolder getValidAuthDataHolderFromConfig(@NotNull Project project, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthDataHolder githubAuthDataHolder;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
        }
        GithubAuthData auth = GithubAuthData.createFromSettings();
        GithubAuthDataHolder authHolder = new GithubAuthDataHolder(auth);
        try {
            GithubUtil.checkAuthData(project, authHolder, indicator);
            githubAuthDataHolder = authHolder;
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, auth);
            GithubAuthDataHolder githubAuthDataHolder2 = authHolder;
            if (githubAuthDataHolder2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
            }
            return githubAuthDataHolder2;
        }
        if (githubAuthDataHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
        }
        return githubAuthDataHolder;
    }

    @NotNull
    public static GithubUserDetailed checkAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        if (StringUtil.isEmptyOrSpaces((String)auth.getHost())) {
            throw new GithubAuthenticationException("Target host not defined");
        }
        switch (auth.getAuthType()) {
            case BASIC: {
                GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
                assert (basicAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)basicAuth.getLogin()) && !StringUtil.isEmptyOrSpaces((String)basicAuth.getPassword())) break;
                throw new GithubAuthenticationException("Empty login or password");
            }
            case TOKEN: {
                GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
                assert (tokenAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)tokenAuth.getToken())) break;
                throw new GithubAuthenticationException("Empty token");
            }
            case ANONYMOUS: {
                throw new GithubAuthenticationException("Anonymous connection not allowed");
            }
        }
        GithubUserDetailed githubUserDetailed = GithubUtil.testConnection(project, authHolder, indicator);
        if (githubUserDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        return githubUserDetailed;
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, final @NotNull ThrowableConvertor<ProgressIndicator, T, IOException> task) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        final Ref dataRef = new Ref();
        final Ref exceptionRef = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, caption, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil$4", "run"));
                }
                try {
                    dataRef.set(task.convert((Object)indicator));
                }
                catch (IOException e) {
                    exceptionRef.set((Object)e);
                }
                catch (Error e) {
                    exceptionRef.set((Object)new GithubOperationCanceledException(e));
                }
                catch (RuntimeException e) {
                    exceptionRef.set((Object)new GithubOperationCanceledException(e));
                }
            }
        });
        if (!exceptionRef.isNull()) {
            throw (IOException)exceptionRef.get();
        }
        return (T)dataRef.get();
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, final @NotNull Convertor<ProgressIndicator, T> task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        final Ref dataRef = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, caption, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil$5", "run"));
                }
                dataRef.set(task.convert((Object)indicator));
            }
        });
        return (T)dataRef.get();
    }

    @Nullable
    public static String findGithubRemoteUrl(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "findGithubRemoteUrl"));
        }
        Pair<GitRemote, String> remote = GithubUtil.findGithubRemote(repository);
        if (remote == null) {
            return null;
        }
        return (String)remote.getSecond();
    }

    @Nullable
    public static Pair<GitRemote, String> findGithubRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "findGithubRemote"));
        }
        Pair githubRemote = null;
        block0: for (GitRemote gitRemote : repository.getRemotes()) {
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                String remoteName = gitRemote.getName();
                if ("github".equals(remoteName) || "origin".equals(remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @Nullable
    public static String findUpstreamRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "findUpstreamRemote"));
        }
        for (GitRemote gitRemote : repository.getRemotes()) {
            String remoteName = gitRemote.getName();
            if (!"upstream".equals(remoteName)) continue;
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                return remoteUrl;
            }
            return gitRemote.getFirstUrl();
        }
        return null;
    }

    @Nullable
    public static GitRemote findGithubRemote(@NotNull GitRepository gitRepository, @NotNull GithubFullPath path) {
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "findGithubRemote"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "findGithubRemote"));
        }
        for (GitRemote remote : gitRepository.getRemotes()) {
            for (String url : remote.getUrls()) {
                if (!path.equals(GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url))) continue;
                return remote;
            }
        }
        return null;
    }

    public static boolean testGitExecutable(Project project) {
        GitVersion version;
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        String executable = settings.getPathToGit();
        try {
            version = GitVersion.identifyVersion((String)executable);
        }
        catch (Exception e) {
            GithubNotifications.showErrorDialog(project, GitBundle.getString((String)"find.git.error.title"), e);
            return false;
        }
        if (!version.isSupported()) {
            GithubNotifications.showWarningDialog(project, GitBundle.message((String)"find.git.unsupported.message", (Object[])new Object[]{version.toString(), GitVersion.MIN}), GitBundle.getString((String)"find.git.success.title"));
            return false;
        }
        return true;
    }

    public static boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "isRepositoryOnGitHub"));
        }
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    public static void setVisibleEnabled(AnActionEvent e, boolean visible, boolean enabled) {
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public static String getErrorTextFromException(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "getErrorTextFromException"));
        }
        if (e instanceof UnknownHostException) {
            String string = "Unknown host: " + e.getMessage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getErrorTextFromException"));
            }
            return string;
        }
        String string = e.getMessage();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getErrorTextFromException"));
        }
        return string;
    }

    @Nullable
    public static GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        GitRepository repository;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "getGitRepository"));
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        List repositories = manager.getRepositories();
        if (repositories.size() == 0) {
            return null;
        }
        if (repositories.size() == 1) {
            return (GitRepository)repositories.get(0);
        }
        if (file != null && (repository = (GitRepository)manager.getRepositoryForFile(file)) != null) {
            return repository;
        }
        return (GitRepository)manager.getRepositoryForFile(project.getBaseDir());
    }

    public static boolean addGithubRemote(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remote, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"add", remote, url});
            handler.run();
            if (handler.getExitCode() != 0) {
                GithubNotifications.showError(project, "Can't add remote", "Failed to add GitHub remote: '" + url + "'. " + handler.getStderr());
                return false;
            }
            repository.update();
            return true;
        }
        catch (VcsException e) {
            GithubNotifications.showError(project, "Can't add remote", (Exception)((Object)e));
            return false;
        }
    }
}

