/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubNotifications {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String GITHUB_NOTIFICATION_GROUP = "github";

    public static void showInfo(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfo"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfo"));
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String logDetails) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (logDetails == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        LOG.warn(title + "; " + message + "; " + logDetails);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        LOG.warn(title + "; ", (Throwable)e);
        VcsNotifier.getInstance((Project)project).notifyError(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showInfoURL(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, "<a href='" + url + "'>" + message + "</a>", NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (highlight == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (postfix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showErrorURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (highlight == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (postfix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyError(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showInfoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Project)project, (String)message, (String)title);
    }

    public static void showInfoDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Component)component, (String)message, (String)title);
    }

    public static void showWarningDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Project)project, (String)message, (String)title);
    }

    public static void showWarningDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Component)component, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull Exception e) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.warn(title, (Throwable)e);
        Messages.showErrorDialog((Project)project, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Component)component, (String)message, (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull Exception e) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.info(title, (Throwable)e);
        Messages.showInfoMessage((Component)component, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    @Messages.YesNoResult
    public static int showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubNotifications", "showYesNoDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubNotifications", "showYesNoDialog"));
        }
        return Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
    }
}

