/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubAuthData {
    @NotNull
    private final AuthType myAuthType;
    @NotNull
    private final String myHost;
    @Nullable
    private final BasicAuth myBasicAuth;
    @Nullable
    private final TokenAuth myTokenAuth;
    private final boolean myUseProxy;

    private GithubAuthData(@NotNull AuthType authType, @NotNull String host, @Nullable BasicAuth basicAuth, @Nullable TokenAuth tokenAuth, boolean useProxy) {
        if (authType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData", "<init>"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubAuthData", "<init>"));
        }
        this.myAuthType = authType;
        this.myHost = host;
        this.myBasicAuth = basicAuth;
        this.myTokenAuth = tokenAuth;
        this.myUseProxy = useProxy;
    }

    public static GithubAuthData createFromSettings() {
        return GithubSettings.getInstance().getAuthData();
    }

    public static GithubAuthData createAnonymous() {
        return GithubAuthData.createAnonymous("github.com");
    }

    public static GithubAuthData createAnonymous(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData", "createAnonymous"));
        }
        return new GithubAuthData(AuthType.ANONYMOUS, host, null, null, true);
    }

    public static GithubAuthData createBasicAuth(@NotNull String host, @NotNull String login, @NotNull String password) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData", "createBasicAuth"));
        }
        if (login == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubAuthData", "createBasicAuth"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubAuthData", "createBasicAuth"));
        }
        return new GithubAuthData(AuthType.BASIC, host, new BasicAuth(login, password), null, true);
    }

    public static GithubAuthData createBasicAuthTF(@NotNull String host, @NotNull String login, @NotNull String password, @NotNull String code) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData", "createBasicAuthTF"));
        }
        if (login == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubAuthData", "createBasicAuthTF"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/util/GithubAuthData", "createBasicAuthTF"));
        }
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/util/GithubAuthData", "createBasicAuthTF"));
        }
        return new GithubAuthData(AuthType.BASIC, host, new BasicAuth(login, password, code), null, true);
    }

    public static GithubAuthData createTokenAuth(@NotNull String host, @NotNull String token) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData", "createTokenAuth"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubAuthData", "createTokenAuth"));
        }
        return new GithubAuthData(AuthType.TOKEN, host, null, new TokenAuth(token), true);
    }

    public static GithubAuthData createTokenAuth(@NotNull String host, @NotNull String token, boolean useProxy) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData", "createTokenAuth"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubAuthData", "createTokenAuth"));
        }
        return new GithubAuthData(AuthType.TOKEN, host, null, new TokenAuth(token), useProxy);
    }

    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myAuthType;
        if (authType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubAuthData", "getAuthType"));
        }
        return authType;
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubAuthData", "getHost"));
        }
        return string;
    }

    @Nullable
    public BasicAuth getBasicAuth() {
        return this.myBasicAuth;
    }

    @Nullable
    public TokenAuth getTokenAuth() {
        return this.myTokenAuth;
    }

    public boolean isUseProxy() {
        return this.myUseProxy;
    }

    @NotNull
    public GithubAuthData copyWithTwoFactorCode(@NotNull String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData", "copyWithTwoFactorCode"));
        }
        if (this.myBasicAuth == null) {
            throw new IllegalStateException("Two factor authentication can be used only with Login/Password");
        }
        GithubAuthData githubAuthData = GithubAuthData.createBasicAuthTF(this.getHost(), this.myBasicAuth.getLogin(), this.myBasicAuth.getPassword(), code);
        if (githubAuthData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubAuthData", "copyWithTwoFactorCode"));
        }
        return githubAuthData;
    }

    public static class TokenAuth {
        @NotNull
        private final String myToken;

        private TokenAuth(@NotNull String token) {
            if (token == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData$TokenAuth", "<init>"));
            }
            this.myToken = token;
        }

        @NotNull
        public String getToken() {
            String string = this.myToken;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubAuthData$TokenAuth", "getToken"));
            }
            return string;
        }
    }

    public static class BasicAuth {
        @NotNull
        private final String myLogin;
        @NotNull
        private final String myPassword;
        @Nullable
        private final String myCode;

        private BasicAuth(@NotNull String login, @NotNull String password) {
            if (login == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData$BasicAuth", "<init>"));
            }
            if (password == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubAuthData$BasicAuth", "<init>"));
            }
            this(login, password, (String)null);
        }

        private BasicAuth(@NotNull String login, @NotNull String password, @Nullable String code) {
            if (login == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubAuthData$BasicAuth", "<init>"));
            }
            if (password == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/util/GithubAuthData$BasicAuth", "<init>"));
            }
            this.myLogin = login;
            this.myPassword = password;
            this.myCode = code;
        }

        @NotNull
        public String getLogin() {
            String string = this.myLogin;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubAuthData$BasicAuth", "getLogin"));
            }
            return string;
        }

        @NotNull
        public String getPassword() {
            String string = this.myPassword;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubAuthData$BasicAuth", "getPassword"));
            }
            return string;
        }

        @Nullable
        public String getCode() {
            return this.myCode;
        }
    }

    public static enum AuthType {
        BASIC,
        TOKEN,
        ANONYMOUS;

    }
}

