/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.ui.GithubSharePanel;

public class GithubShareDialog
extends DialogWrapper {
    private static final Pattern GITHUB_REPO_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
    private final GithubSharePanel myGithubSharePanel;
    private final Set<String> myAvailableNames;

    public GithubShareDialog(Project project, Set<String> availableNames, boolean privateRepoAllowed) {
        super(project);
        this.myAvailableNames = availableNames;
        this.myGithubSharePanel = new GithubSharePanel(this);
        this.init();
        this.setTitle("Share Project On GitHub");
        this.setOKButtonText("Share");
        this.myGithubSharePanel.setRepositoryName(project.getName());
        this.myGithubSharePanel.setPrivateRepoAvailable(privateRepoAllowed);
        this.init();
        this.updateOkButton();
    }

    protected String getHelpId() {
        return "github.share";
    }

    protected String getDimensionServiceKey() {
        return "Github.ShareDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myGithubSharePanel.getPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGithubSharePanel.getPreferredFocusComponent();
    }

    public void updateOkButton() {
        String repositoryName = this.getRepositoryName();
        if (StringUtil.isEmpty((String)repositoryName)) {
            this.setErrorText("No repository name selected");
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myAvailableNames.contains(repositoryName)) {
            this.setErrorText("Repository with selected name already exists");
            this.setOKActionEnabled(false);
            return;
        }
        if (!GITHUB_REPO_PATTERN.matcher(repositoryName).matches()) {
            this.setErrorText("Invalid repository name. Name should consist of letters, numbers, dashes, dots and underscores");
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    public String getRepositoryName() {
        return this.myGithubSharePanel.getRepositoryName();
    }

    public boolean isPrivate() {
        return this.myGithubSharePanel.isPrivate();
    }

    public String getDescription() {
        return this.myGithubSharePanel.getDescription();
    }

    public void testSetRepositoryName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubShareDialog", "testSetRepositoryName"));
        }
        this.myGithubSharePanel.setRepositoryName(name);
    }
}

